/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/08, 15:47
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfaceTableSpecManager.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface.inputinterfacetable;

import java.io.Serializable;
import java.net.URL;
import java.util.List;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.XMLUtils;

/**
 * manipulates instances of InputInterfaceTableSpec
 * 
 * @author KOGA, Junichiro
 */
public class InputInterfaceTableSpecManager implements Serializable {
    private Logger logger = Logger
            .getLogger(InputInterfaceTableSpecManager.class.getName());

    private InputInterface parent;

    private InputInterfaceTableSpec[] tableSpecs;

    /**
     * Creates a new instance of InputInterfaceTableSpecManager
     * 
     * @param url
     *            the url which points to the table-spec file.
     * @param parent
     *            the InputInterface object to which this class is associated.
     */
    public InputInterfaceTableSpecManager(URL url, InputInterface parent) {
        this.parent = parent;
        tableSpecs = createTableSpecFrom(url);
    }

    /**
     * sets the referance to the InputInterface object to which this class is
     * associated.
     * 
     * @param parent
     *            the InputInterface object to which this class is associated.
     */
    public void setInputInterface(InputInterface parent) {
        this.parent = parent;
        logger.debug("parent: " + parent);
    }

    /**
     * returns the referance to the InputInterface object to which this class is
     * associated.
     * 
     * @return the InputInterface object to which this class is associated.
     */
    public InputInterface getInputInterface() {
        return this.parent;
    }

    /**
     * returns an array of InputInterfaceTableSpec created from the url passed
     * by the constructor. each InputInterfaceTableSpec object encapsulates
     * several table columns.
     * 
     * @return an array of InputInterfaceTableSpec objects.
     */
    public InputInterfaceTableSpec[] getTableSpecs() {
        return tableSpecs;
    }

    /**
     * returns an InputInterfaceTableSpec object with a specific ID.
     * 
     * @param ID
     *            the ID of the desired InputInterfaceTableSpec object (for
     *            example, structure.atom_list.atoms)
     * @return the InputInterfaceTableSpec object.
     */
    public InputInterfaceTableSpec getTableSpec(String ID) {
        if (tableSpecs == null) {
            return null;
        }

        for (int i = 0; i < tableSpecs.length; i++) {
            if (tableSpecs[i].getID().equalsIgnoreCase(ID)) {
                return tableSpecs[i];
            }
        }

        return null;
    }

    /**
     * returns the index-th InputInterfaceTableSpec object with tag ID.
     * 
     * @param ID
     *            the ID of the desired InputInterfaceTableSpec object (for
     *            example, structure.atom_list.atoms)
     * @param index
     *            the index for the ID.
     * @return the InputInterfaceTableSpec object.
     */
    public InputInterfaceTableSpec getTableSpec(String ID, int index) {
        if (tableSpecs == null) {
            return null;
        }

        int count = 0;
        for (int i = 0; i < tableSpecs.length; i++) {
            if (tableSpecs[i].getID().equalsIgnoreCase(ID)) {
                if (count == index) {
                    return tableSpecs[i];
                }
                count++;
            }
        }

        return null;
    }

    private InputInterfaceTableSpec[] createTableSpecFrom(URL url) {
        Document doc = XMLUtils.getDocumentFromURL(url);
        Element root = doc.getRootElement();
        List columns = root.getChildren();
        if (columns == null) {
            logger.error("invalid specification for table spec.");
            return null;
        }

        InputInterfaceTableSpec[] ret = new InputInterfaceTableSpec[columns
                .size()];
        for (int i = 0; i < columns.size(); i++) {
            ret[i] = createTableSpec((Element) columns.get(i));
        }
        return ret;
    }

    private InputInterfaceTableSpec createTableSpec(Element element) {
        InputInterfaceTableSpec spec = new InputInterfaceTableSpec(element,
                this);
        return spec;
    }

}
