/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/12, 16:41
!  AUTHOR(S): KOGA, Junichiro
!  File : ElementDef.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.common;

import java.text.DecimalFormat;

/**
 * ufv̒`.
 * 
 * @author
 */
public class ElementDef {

    private String symbol;
    private String atomicNumber;
    private String mass;

    private boolean hbond = false;

    public ElementDef() {
    }

    public ElementDef(String symbol, String atomicNumber, String mass) {
        this.symbol = symbol;
        this.atomicNumber = atomicNumber;
        this.mass = mass;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setAtomicNumber(String atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    public void setMass(String mass) {
        this.mass = mass;
    }

    public String getSymbol() {
        return (symbol);
    }

    public String getAtomicNumber() {
        return (atomicNumber);
    }

    public String getMass() {
        return (mass);
    }

    public void hasHbond(boolean hbond) {
        this.hbond = hbond;
    }

    public boolean hasHbond() {
        return this.hbond;
    }

    private double maxHbondDistance = 0.0;

    public void setMaxHbondDistance(double maxHbondDistance) {
        this.maxHbondDistance = maxHbondDistance;
        hbond = maxHbondDistance > 0;
    }

    public double getMaxHbondDistance() {
        return this.maxHbondDistance;
    }

    private double covrad;

    public void setCovalentRadius(double covrad) {
        this.covrad = covrad;
    }

    public double getCovalentRadius() {
        return this.covrad;
    }

    private float[] color;

    public void setColor(float[] color) {
        this.color = color;
    }

    public float[] getColor() {
        return this.color;
    }

    private float radius;

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return radius;
    }

    private DecimalFormat form = new DecimalFormat("0.00000");

    public String toString() {
        if (symbol == null || symbol.trim().length() == 0)
            return "";
        String ret = symbol + "            " + String.valueOf(radius)
                + "            " + String.valueOf(covrad) + "          "
                + String.valueOf(color[0]) + " " + String.valueOf(color[1])
                + " " + String.valueOf(color[2]) + "      "
                + form.format(Double.parseDouble(mass) / ConstParameters.AMU);
        if (hbond) {
            ret += "  " + String.valueOf(maxHbondDistance);
        }
        return ret;
    }

}
