/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/31, 14:38
!  AUTHOR(S): KOGA, Junichiro
!  File : ExpandKeyListener.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.keylistener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;

import org.apache.log4j.Logger;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * "gk"sL[Xi[
 * 
 * @author
 */
public class ExpandKeyListener implements KeyListener, PropertiesListener {
    private Logger logger = Logger.getLogger(ExpandKeyListener.class.getName());
    private TransformGroup[] tgroup;
    private double factor = 1.1f;

    /** Creates a new instance of ExpandKeyListener */
    public ExpandKeyListener(TransformGroup[] tgroup) {
        this.tgroup = tgroup;
        PropertiesManager.getGlobalProperties(PropertiesManager.PROPERTIES_ACV)
                .addPropertiesListener(this);
        try {
            factor = Double.parseDouble(PropertiesManager.getGlobalProperties(
                    PropertiesManager.PROPERTIES_ACV).getProperty(
                    "keylistener_zoom"));
        } catch (Exception exc) {
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private Transform3D scale3d = new Transform3D();
    private Transform3D currTrans = new Transform3D();

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_SEMICOLON && e.isShiftDown()) {
            logger.debug("'+'");
            scale3d.set(factor);
            for (int i = 0; i < tgroup.length; i++) {
                tgroup[i].getTransform(currTrans);
                currTrans.mul(scale3d);
                tgroup[i].setTransform(currTrans);
            }
        }
        if (e.getKeyCode() == KeyEvent.VK_MINUS && !e.isMetaDown()) {
            logger.debug("'-'");
            scale3d.set(1d / factor);
            for (int i = 0; i < tgroup.length; i++) {
                tgroup[i].getTransform(currTrans);
                currTrans.mul(scale3d);
                tgroup[i].setTransform(currTrans);
            }
        }
    }

    public void propertiesStored(GlobalProperties properties) {
        try {
            factor = Double.parseDouble(properties
                    .getProperty("keylistener_zoom"));
        } catch (Exception exc) {
        }
    }

}
