/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;

public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length = 0;

    protected MidiMessage(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    protected void setMessage(byte[] data, int length) throws InvalidMidiDataException {
        this.length = length;
        if (this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        System.arraycopy(data, 0, this.data, 0, length);
    }

    public byte[] getMessage() {
        byte[] returnedArray = new byte[this.length];
        System.arraycopy(this.data, 0, returnedArray, 0, this.length);
        return returnedArray;
    }

    public int getStatus() {
        int status = 0;
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream das = new DataInputStream(bas);
            status = das.readUnsignedByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    public int getLength() {
        return this.length;
    }

    public abstract Object clone();
}

