/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFString;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.BindableNode;
import org.cybergarage.x3d.node.Node;

public class ViewpointNode
extends BindableNode {
    private String positionFieldName = "position";
    private String orientationFieldName = "orientation";
    private String fieldOfViewFieldName = "fieldOfView";
    private String descriptionFieldName = "description";
    private String jumpFieldName = "jump";
    private SFVec3f positionField;
    private SFRotation orientationField;
    private SFString descriptionField;
    private SFFloat fovField;
    private SFBool jumpField;

    public ViewpointNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.VIEWPOINT);
        this.positionField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.positionField.setName(this.positionFieldName);
        this.addExposedField(this.positionField);
        this.orientationField = new SFRotation(0.0f, 0.0f, 1.0f, 0.0f);
        this.orientationField.setName(this.orientationFieldName);
        this.addExposedField(this.orientationField);
        this.descriptionField = new SFString();
        this.descriptionField.setName(this.descriptionFieldName);
        this.addExposedField(this.descriptionField);
        this.fovField = new SFFloat(0.785398f);
        this.fovField.setName(this.fieldOfViewFieldName);
        this.addExposedField(this.fovField);
        this.jumpField = new SFBool(true);
        this.jumpField.setName(this.jumpFieldName);
        this.addExposedField(this.jumpField);
    }

    public ViewpointNode(ViewpointNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFBool getJumpField() {
        if (!this.isInstanceNode()) {
            return this.jumpField;
        }
        return (SFBool)this.getExposedField(this.jumpFieldName);
    }

    public void setJump(boolean value) {
        this.getJumpField().setValue(value);
    }

    public void setJump(String value) {
        this.getJumpField().setValue(value);
    }

    public boolean getJump() {
        return this.getJumpField().getValue();
    }

    public SFFloat getFieldOfViewField() {
        if (!this.isInstanceNode()) {
            return this.fovField;
        }
        return (SFFloat)this.getExposedField(this.fieldOfViewFieldName);
    }

    public void setFieldOfView(float value) {
        this.getFieldOfViewField().setValue(value);
    }

    public void setFieldOfView(String value) {
        this.getFieldOfViewField().setValue(value);
    }

    public float getFieldOfView() {
        return this.getFieldOfViewField().getValue();
    }

    public SFString getDescriptionField() {
        if (!this.isInstanceNode()) {
            return this.descriptionField;
        }
        return (SFString)this.getExposedField(this.descriptionFieldName);
    }

    public void setDescription(String value) {
        this.getDescriptionField().setValue(value);
    }

    public String getDescription() {
        return this.getDescriptionField().getValue();
    }

    public SFVec3f getPositionField() {
        if (!this.isInstanceNode()) {
            return this.positionField;
        }
        return (SFVec3f)this.getExposedField(this.positionFieldName);
    }

    public void setPosition(float[] value) {
        this.getPositionField().setValue(value);
    }

    public void setPosition(float x, float y, float z) {
        this.getPositionField().setValue(x, y, z);
    }

    public void setPosition(String value) {
        this.getPositionField().setValue(value);
    }

    public void getPosition(float[] value) {
        this.getPositionField().getValue(value);
    }

    public SFRotation getOrientationField() {
        if (!this.isInstanceNode()) {
            return this.orientationField;
        }
        return (SFRotation)this.getExposedField(this.orientationFieldName);
    }

    public void setOrientation(float[] value) {
        this.getOrientationField().setValue(value);
    }

    public void setOrientation(float x, float y, float z, float w) {
        this.getOrientationField().setValue(x, y, z, w);
    }

    public void setOrientation(String value) {
        this.getOrientationField().setValue(value);
    }

    public void getOrientation(float[] value) {
        this.getOrientationField().getValue(value);
    }

    public void addPosition(float[] worldTranslation) {
        this.getPositionField().add(worldTranslation);
    }

    public void addPosition(float[] localTranslation, float[][] frame) {
        SFVec3f position = this.getPositionField();
        float[] translation = new float[3];
        for (int axis = 0; axis < 3; ++axis) {
            SFVec3f vector = new SFVec3f(frame[axis]);
            vector.scale(localTranslation[axis]);
            vector.getValue(translation);
            position.add(translation);
        }
    }

    public void addPosition(float x, float y, float z, float[][] frame) {
        float[] localTranslation = new float[]{x, y, z};
        this.addPosition(localTranslation, frame);
    }

    public void addOrientation(SFRotation rot) {
        this.getOrientationField().add(rot);
    }

    public void addOrientation(float[] rotationValue) {
        this.getOrientationField().add(rotationValue);
    }

    public void addOrientation(float x, float y, float z, float rot) {
        this.getOrientationField().add(x, y, z, rot);
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        float[] vec = new float[3];
        float[] rot = new float[4];
        SFBool jump = this.getJumpField();
        SFString description = this.getDescriptionField();
        printStream.println(indentString + "\t" + "fieldOfView " + this.getFieldOfView());
        printStream.println(indentString + "\t" + "jump " + jump);
        this.getPosition(vec);
        printStream.println(indentString + "\t" + "position " + vec[0] + " " + vec[1] + " " + vec[2]);
        this.getOrientation(rot);
        printStream.println(indentString + "\t" + "orientation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3]);
        printStream.println(indentString + "\t" + "description " + description);
    }

    public void getFrame(float[][] frame) {
        SFRotation orientation = this.getOrientationField();
        frame[0][0] = 1.0f;
        frame[0][1] = 0.0f;
        frame[0][2] = 0.0f;
        orientation.multi(frame[0]);
        frame[1][0] = 0.0f;
        frame[1][1] = 1.0f;
        frame[1][2] = 0.0f;
        orientation.multi(frame[1]);
        frame[2][0] = 0.0f;
        frame[2][1] = 0.0f;
        frame[2][2] = 1.0f;
        orientation.multi(frame[2]);
    }

    public float[][] getFrame() {
        float[][] frame = new float[3][3];
        this.getFrame(frame);
        return frame;
    }

    public void getMatrix(SFMatrix matrix) {
        float[] position = new float[3];
        float[] rotation = new float[4];
        this.getPosition(position);
        SFVec3f transView = new SFVec3f(position);
        transView.invert();
        this.getOrientation(rotation);
        SFRotation rotView = new SFRotation(rotation);
        rotView.invert();
        SFMatrix mxTrans = new SFMatrix();
        SFMatrix mxRot = new SFMatrix();
        mxTrans.setValueAsTranslation(transView);
        mxRot.setValueAsRotation(rotView);
        matrix.init();
        matrix.add(mxRot);
        matrix.add(mxTrans);
    }

    public SFMatrix getMatrix() {
        SFMatrix mx = new SFMatrix();
        this.getMatrix(mx);
        return mx;
    }

    public void getMatrix(float[][] value) {
        SFMatrix mx = new SFMatrix();
        this.getMatrix(mx);
        mx.getValue(value);
    }
}

