/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFColor;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.node.AppearanceChildNode;
import org.cybergarage.x3d.node.Node;

public class MaterialNode
extends AppearanceChildNode {
    private static final String transparencyFieldName = "transparency";
    private static final String ambientIntensityFieldName = "ambientIntensity";
    private static final String shininessFieldName = "shininess";
    private static final String diffuseColorFieldName = "diffuseColor";
    private static final String specularColorFieldName = "specularColor";
    private static final String emissiveColorFieldName = "emissiveColor";
    private SFFloat transparencyField;
    private SFFloat ambientIntensityField;
    private SFFloat shininessField;
    private SFColor diffuseColorField;
    private SFColor specularColorField;
    private SFColor emissiveColorField;

    public MaterialNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.MATERIAL);
        this.transparencyField = new SFFloat(0.0f);
        this.transparencyField.setName(transparencyFieldName);
        this.addExposedField(this.transparencyField);
        this.ambientIntensityField = new SFFloat(0.2f);
        this.ambientIntensityField.setName(ambientIntensityFieldName);
        this.addExposedField(this.ambientIntensityField);
        this.shininessField = new SFFloat(0.2f);
        this.shininessField.setName(shininessFieldName);
        this.addExposedField(this.shininessField);
        this.diffuseColorField = new SFColor(0.8f, 0.8f, 0.8f);
        this.diffuseColorField.setName(diffuseColorFieldName);
        this.addExposedField(this.diffuseColorField);
        this.specularColorField = new SFColor(0.0f, 0.0f, 0.0f);
        this.specularColorField.setName(specularColorFieldName);
        this.addExposedField(this.specularColorField);
        this.emissiveColorField = new SFColor(0.0f, 0.0f, 0.0f);
        this.emissiveColorField.setName(emissiveColorFieldName);
        this.addExposedField(this.emissiveColorField);
    }

    public MaterialNode(MaterialNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFFloat getTransparencyField() {
        if (!this.isInstanceNode()) {
            return this.transparencyField;
        }
        return (SFFloat)this.getExposedField(transparencyFieldName);
    }

    public void setTransparency(float value) {
        this.getTransparencyField().setValue(value);
    }

    public void setTransparency(String value) {
        this.getTransparencyField().setValue(value);
    }

    public float getTransparency() {
        return this.getTransparencyField().getValue();
    }

    public SFFloat getAmbientIntensityField() {
        if (!this.isInstanceNode()) {
            return this.ambientIntensityField;
        }
        return (SFFloat)this.getExposedField(ambientIntensityFieldName);
    }

    public void setAmbientIntensity(float intensity) {
        this.getAmbientIntensityField().setValue(intensity);
    }

    public void setAmbientIntensity(String intensity) {
        this.getAmbientIntensityField().setValue(intensity);
    }

    public float getAmbientIntensity() {
        return this.getAmbientIntensityField().getValue();
    }

    public SFFloat getShininessField() {
        if (!this.isInstanceNode()) {
            return this.shininessField;
        }
        return (SFFloat)this.getExposedField(shininessFieldName);
    }

    public void setShininess(float value) {
        this.getShininessField().setValue(value);
    }

    public void setShininess(String value) {
        this.getShininessField().setValue(value);
    }

    public float getShininess() {
        return this.getShininessField().getValue();
    }

    public void getAmbientColor(float[] value) {
        float ambientIntensity = this.getAmbientIntensity();
        this.getDiffuseColor(value);
        value[0] = value[0] * ambientIntensity;
        value[1] = value[1] * ambientIntensity;
        value[2] = value[2] * ambientIntensity;
    }

    public SFColor getDiffuseColorField() {
        if (!this.isInstanceNode()) {
            return this.diffuseColorField;
        }
        return (SFColor)this.getExposedField(diffuseColorFieldName);
    }

    public void setDiffuseColor(float[] value) {
        this.getDiffuseColorField().setValue(value);
    }

    public void setDiffuseColor(float r, float g, float b2) {
        this.getDiffuseColorField().setValue(r, g, b2);
    }

    public void setDiffuseColor(String value) {
        this.getDiffuseColorField().setValue(value);
    }

    public void getDiffuseColor(float[] value) {
        this.getDiffuseColorField().getValue(value);
    }

    public SFColor getSpecularColorField() {
        if (!this.isInstanceNode()) {
            return this.specularColorField;
        }
        return (SFColor)this.getExposedField(specularColorFieldName);
    }

    public void setSpecularColor(float[] value) {
        this.getSpecularColorField().setValue(value);
    }

    public void setSpecularColor(float r, float g, float b2) {
        this.getSpecularColorField().setValue(r, g, b2);
    }

    public void setSpecularColor(String value) {
        this.getSpecularColorField().setValue(value);
    }

    public void getSpecularColor(float[] value) {
        this.getSpecularColorField().getValue(value);
    }

    public SFColor getEmissiveColorField() {
        if (!this.isInstanceNode()) {
            return this.emissiveColorField;
        }
        return (SFColor)this.getExposedField(emissiveColorFieldName);
    }

    public void setEmissiveColor(float[] value) {
        this.getEmissiveColorField().setValue(value);
    }

    public void setEmissiveColor(float r, float g, float b2) {
        this.getEmissiveColorField().setValue(r, g, b2);
    }

    public void setEmissiveColor(String value) {
        this.getEmissiveColorField().setValue(value);
    }

    public void getEmissiveColor(float[] value) {
        this.getEmissiveColorField().getValue(value);
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        float[] color = new float[3];
        this.getDiffuseColor(color);
        printStream.println(indentString + "\t" + "diffuseColor " + color[0] + " " + color[1] + " " + color[2]);
        printStream.println(indentString + "\t" + "ambientIntensity " + this.getAmbientIntensity());
        this.getSpecularColor(color);
        printStream.println(indentString + "\t" + "specularColor " + color[0] + " " + color[1] + " " + color[2]);
        this.getEmissiveColor(color);
        printStream.println(indentString + "\t" + "emissiveColor " + color[0] + " " + color[1] + " " + color[2]);
        printStream.println(indentString + "\t" + "shininess " + this.getShininess());
        printStream.println(indentString + "\t" + "transparency " + this.getTransparency());
    }
}

