/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFNode;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.TextureNode;
import org.cybergarage.x3d.node.TextureTransformNode;

public class AppearanceNode
extends Node {
    private static final String materialExposedFieldName = "material";
    private static final String textureExposedFieldName = "texture";
    private static final String textureTransformExposedFieldName = "textureTransform";
    private static final String linePropertiesExposedFieldName = "lineProperties";
    private static final String fillPropertiesExposedFieldName = "fillProperties";
    private SFNode materialField;
    private SFNode textureField;
    private SFNode texTransformField;
    private SFNode linePropertiesField;
    private SFNode fillPropertiesField;

    public AppearanceNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.APPEARANCE);
        this.materialField = new SFNode();
        this.addExposedField(materialExposedFieldName, this.materialField);
        this.textureField = new SFNode();
        this.addExposedField(textureExposedFieldName, this.textureField);
        this.texTransformField = new SFNode();
        this.addExposedField(textureTransformExposedFieldName, this.texTransformField);
        this.linePropertiesField = new SFNode();
        this.addExposedField(linePropertiesExposedFieldName, this.linePropertiesField);
        this.fillPropertiesField = new SFNode();
        this.addExposedField(fillPropertiesExposedFieldName, this.fillPropertiesField);
    }

    public AppearanceNode(AppearanceNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFNode getMaterialField() {
        if (!this.isInstanceNode()) {
            return this.materialField;
        }
        return (SFNode)this.getExposedField(materialExposedFieldName);
    }

    public SFNode getTextureField() {
        if (!this.isInstanceNode()) {
            return this.textureField;
        }
        return (SFNode)this.getExposedField(textureExposedFieldName);
    }

    public SFNode getTextureTransformField() {
        if (!this.isInstanceNode()) {
            return this.texTransformField;
        }
        return (SFNode)this.getExposedField(textureTransformExposedFieldName);
    }

    public SFNode getLinePropertiesField() {
        if (!this.isInstanceNode()) {
            return this.linePropertiesField;
        }
        return (SFNode)this.getExposedField(linePropertiesExposedFieldName);
    }

    public SFNode getFillPropertiesField() {
        if (!this.isInstanceNode()) {
            return this.fillPropertiesField;
        }
        return (SFNode)this.getExposedField(fillPropertiesExposedFieldName);
    }

    public void updateMaterialField() {
        this.getMaterialField().setValue(this.getMaterialNodes());
    }

    public void updateTextureField() {
        this.getTextureField().setValue(this.getTextureNode());
    }

    public void updateTextureTransformlField() {
        this.getTextureTransformField().setValue(this.getTextureTransformNodes());
    }

    public void updateLinePropertiesField() {
    }

    public void updateFillPropertiesField() {
    }

    public boolean isChildNodeType(Node node) {
        return node.isMaterialNode() || node.isTextureNode() || node.isTextureTransformNode();
    }

    public void initialize() {
        super.initialize();
        this.updateMaterialField();
        this.updateTextureField();
        this.updateTextureTransformlField();
        this.updateLinePropertiesField();
        this.updateFillPropertiesField();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        TextureTransformNode textureTransform;
        TextureNode texture;
        MaterialNode material = this.getMaterialNodes();
        if (material != null) {
            if (!material.isInstanceNode()) {
                String nodeName = material.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "material DEF " + material.getName() + " Material {");
                } else {
                    printStream.println(indentString + "\t" + "material Material {");
                }
                material.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "material USE " + material.getName());
            }
        }
        if ((texture = this.getTextureNode()) != null) {
            if (!texture.isInstanceNode()) {
                String nodeName = texture.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "texture DEF " + texture.getName() + " " + texture.getTypeString() + " {");
                } else {
                    printStream.println(indentString + "\t" + "texture " + texture.getTypeString() + " {");
                }
                texture.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "texture USE " + texture.getName());
            }
        }
        if ((textureTransform = this.getTextureTransformNodes()) != null) {
            if (!textureTransform.isInstanceNode()) {
                String nodeName = textureTransform.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "textureTransform DEF " + textureTransform.getName() + " TextureTransform {");
                } else {
                    printStream.println(indentString + "\t" + "textureTransform TextureTransform {");
                }
                textureTransform.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "textureTransform USE " + textureTransform.getName());
            }
        }
    }
}

