/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import java.awt.image.BufferedImage;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.Billboard;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ExponentialFog;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointLight;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Switch;
import javax.media.j3d.Text3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.media.j3d.View;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.BackgroundNode;
import org.cybergarage.x3d.node.BillboardNode;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.DirectionalLightNode;
import org.cybergarage.x3d.node.FogNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.GroupNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.IndexedLineSetNode;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.PixelTextureNode;
import org.cybergarage.x3d.node.PointLightNode;
import org.cybergarage.x3d.node.PointSetNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.node.SpotLightNode;
import org.cybergarage.x3d.node.SwitchNode;
import org.cybergarage.x3d.node.TextNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.node.TransformNode;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.util.Debug;

public class VRML97Saver
extends SceneGraph {
    private boolean solid = false;
    private Logger logger = Logger.getLogger(VRML97Saver.class.getName());
    private Stack mVRML97NodeStack = new Stack();
    public static int IDXGEOMTYPE_TRIANGLE = 3;
    public static int IDXGEOMTYPE_QUAD = 4;

    public VRML97Saver() {
    }

    public VRML97Saver(boolean solid) {
        this.solid = solid;
    }

    public void setBranchGroup(BranchGroup bgroup) {
        this.initializeVRML97NodeStack();
        this.clear();
        this.addJ3dGroupNode((Group)bgroup);
    }

    public void nullify() {
        this.stop();
        this.getRootNode().removeChildNodesAndNullifyHeadPointer();
    }

    public void finalize() {
        this.logger.debug("byebye.");
    }

    public void addJ3dGroupNode(Group j3dGroup) {
        if (j3dGroup == null) {
            return;
        }
        org.cybergarage.x3d.node.Node vrml97Node = this.addJ3dNode((Node)j3dGroup);
        if (vrml97Node == null) {
            return;
        }
        this.pushVRML97Node(vrml97Node);
        this.setCapability((SceneGraphObject)j3dGroup, 12);
        int numChildren = 0;
        try {
            numChildren = j3dGroup.numChildren();
        }
        catch (Exception exc) {
            System.out.println(j3dGroup.getClass());
            exc.printStackTrace();
        }
        for (int n = 0; n < numChildren; ++n) {
            Node j3dChildNode = j3dGroup.getChild(n);
            if (j3dChildNode instanceof Group) {
                this.addJ3dGroupNode((Group)j3dChildNode);
                continue;
            }
            this.addJ3dNode(j3dChildNode);
        }
        this.popVRML97Node();
    }

    public org.cybergarage.x3d.node.Node addJ3dNode(Node j3dNode) {
        org.cybergarage.x3d.node.Node vrml97Node = this.createVRML97Node(j3dNode);
        if (vrml97Node != null) {
            this.getCurrentVRML97Node().addChildNode(vrml97Node);
        }
        return vrml97Node;
    }

    public void initializeVRML97NodeStack() {
        this.mVRML97NodeStack.clear();
    }

    public void pushVRML97Node(org.cybergarage.x3d.node.Node node) {
        this.mVRML97NodeStack.push(node);
    }

    public org.cybergarage.x3d.node.Node popVRML97Node() {
        return (org.cybergarage.x3d.node.Node)this.mVRML97NodeStack.pop();
    }

    public org.cybergarage.x3d.node.Node getCurrentVRML97Node() {
        org.cybergarage.x3d.node.Node stackNode = null;
        try {
            stackNode = (org.cybergarage.x3d.node.Node)this.mVRML97NodeStack.peek();
        }
        catch (EmptyStackException ese) {
            return this.getRootNode();
        }
        if (stackNode != null) {
            return stackNode;
        }
        return this.getRootNode();
    }

    public void setCapability(SceneGraphObject j3dNode, int bit) {
        try {
            j3dNode.setCapability(bit);
        }
        catch (RestrictedAccessException restrictedAccessException) {
            // empty catch block
        }
    }

    public org.cybergarage.x3d.node.Node createVRML97Node(Node j3dNode) {
        if (j3dNode instanceof Background) {
            return this.createVRML97BackgroundNode((Background)j3dNode);
        }
        if (j3dNode instanceof Billboard) {
            return this.createVRML97BillboardNode((Billboard)j3dNode);
        }
        if (j3dNode instanceof LinearFog) {
            return this.createVRML97FogNode((LinearFog)j3dNode);
        }
        if (j3dNode instanceof ExponentialFog) {
            return this.createVRML97FogNode((ExponentialFog)j3dNode);
        }
        if (j3dNode instanceof Switch) {
            return this.createVRML97SwitchNode((Switch)j3dNode);
        }
        if (j3dNode instanceof DirectionalLight) {
            return this.createVRML97DirectionalLightNode((DirectionalLight)j3dNode);
        }
        if (j3dNode instanceof PointLight) {
            return this.createVRML97PointLightNode((PointLight)j3dNode);
        }
        if (j3dNode instanceof SpotLight) {
            return this.createVRML97SpotLightNode((SpotLight)j3dNode);
        }
        if (j3dNode instanceof TransformGroup) {
            return this.createVRML97TransformNode((TransformGroup)j3dNode);
        }
        if (j3dNode instanceof AmbientLight) {
            return this.createVRML97PointLightNode((AmbientLight)j3dNode);
        }
        if (j3dNode instanceof Shape3D) {
            return this.createVRML97ShapeNode((Shape3D)j3dNode);
        }
        if (j3dNode instanceof Group) {
            return new GroupNode();
        }
        return null;
    }

    public BackgroundNode createVRML97BackgroundNode(Background j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 16);
        BackgroundNode vrml97Node = new BackgroundNode();
        Color3f color = new Color3f();
        j3dNode.getColor(color);
        vrml97Node.addSkyColor(color.x, color.y, color.z);
        return vrml97Node;
    }

    public BillboardNode createVRML97BillboardNode(Billboard j3dNode) {
        BillboardNode vrml97Node = new BillboardNode();
        if (j3dNode.getAlignmentMode() == 0) {
            Vector3f axis = new Vector3f();
            j3dNode.getAlignmentAxis(axis);
            vrml97Node.setAxisOfRotation(axis.x, axis.y, axis.z);
        } else {
            vrml97Node.setAxisOfRotation(0.0f, 0.0f, 0.0f);
        }
        return vrml97Node;
    }

    public FogNode createVRML97FogNode(LinearFog j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 14);
        this.setCapability((SceneGraphObject)j3dNode, 16);
        FogNode vrml97Node = new FogNode();
        vrml97Node.setFogType("LINEAR");
        Color3f color = new Color3f();
        j3dNode.getColor(color);
        vrml97Node.setColor(color.x, color.y, color.z);
        vrml97Node.setVisibilityRange((float)j3dNode.getBackDistance());
        return vrml97Node;
    }

    public FogNode createVRML97FogNode(ExponentialFog j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 14);
        this.setCapability((SceneGraphObject)j3dNode, 16);
        FogNode vrml97Node = new FogNode();
        vrml97Node.setFogType("EXPONENTIAL");
        Color3f color = new Color3f();
        j3dNode.getColor(color);
        vrml97Node.setColor(color.x, color.y, color.z);
        vrml97Node.setVisibilityRange(j3dNode.getDensity());
        return vrml97Node;
    }

    public DirectionalLightNode createVRML97DirectionalLightNode(DirectionalLight j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 14);
        this.setCapability((SceneGraphObject)j3dNode, 12);
        this.setCapability((SceneGraphObject)j3dNode, 18);
        DirectionalLightNode vrml97Node = new DirectionalLightNode();
        vrml97Node.setOn(j3dNode.getEnable());
        Color3f color = new Color3f();
        j3dNode.getColor(color);
        vrml97Node.setColor(color.x, color.y, color.z);
        Vector3f dir = new Vector3f();
        j3dNode.getDirection(dir);
        vrml97Node.setDirection(dir.x, dir.y, dir.y);
        vrml97Node.setIntensity(1.0f);
        return vrml97Node;
    }

    public PointLightNode createVRML97PointLightNode(PointLight j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 14);
        this.setCapability((SceneGraphObject)j3dNode, 12);
        this.setCapability((SceneGraphObject)j3dNode, 20);
        this.setCapability((SceneGraphObject)j3dNode, 18);
        this.setCapability((SceneGraphObject)j3dNode, 16);
        PointLightNode vrml97Node = new PointLightNode();
        vrml97Node.setOn(j3dNode.getEnable());
        Color3f color = new Color3f();
        j3dNode.getColor(color);
        vrml97Node.setColor(color.x, color.y, color.z);
        Point3f pos = new Point3f();
        j3dNode.getPosition(pos);
        vrml97Node.setLocation(pos.x, pos.y, pos.y);
        Point3f att = new Point3f();
        j3dNode.getAttenuation(att);
        vrml97Node.setAttenuation(att.x, att.y, att.y);
        BoundingSphere boundSphere = new BoundingSphere(j3dNode.getInfluencingBounds());
        vrml97Node.setRadius((float)boundSphere.getRadius());
        vrml97Node.setIntensity(1.0f);
        return vrml97Node;
    }

    public SpotLightNode createVRML97SpotLightNode(SpotLight j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 14);
        this.setCapability((SceneGraphObject)j3dNode, 12);
        this.setCapability((SceneGraphObject)j3dNode, 27);
        SpotLightNode vrml97Node = new SpotLightNode();
        vrml97Node.setOn(j3dNode.getEnable());
        Color3f color = new Color3f();
        j3dNode.getColor(color);
        vrml97Node.setColor(color.x, color.y, color.z);
        Vector3f dir = new Vector3f();
        j3dNode.getDirection(dir);
        vrml97Node.setDirection(dir.x, dir.y, dir.y);
        Point3f pos = new Point3f();
        j3dNode.getPosition(pos);
        vrml97Node.setLocation(pos.x, pos.y, pos.y);
        Point3f att = new Point3f();
        j3dNode.getAttenuation(att);
        vrml97Node.setAttenuation(att.x, att.y, att.y);
        BoundingSphere boundSphere = new BoundingSphere(j3dNode.getInfluencingBounds());
        vrml97Node.setRadius((float)boundSphere.getRadius());
        vrml97Node.setIntensity(1.0f);
        return vrml97Node;
    }

    public ViewpointNode createVRML97ViewpointNode(View j3dNode) {
        ViewpointNode vrml97Node = new ViewpointNode();
        vrml97Node.setFieldOfView((float)j3dNode.getFieldOfView());
        return vrml97Node;
    }

    public SwitchNode createVRML97SwitchNode(Switch j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        SwitchNode vrml97Node = new SwitchNode();
        vrml97Node.setWhichChoice(j3dNode.getWhichChild());
        return vrml97Node;
    }

    public TransformNode createVRML97TransformNode(TransformGroup j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        TransformNode vrml97Node = new TransformNode();
        Transform3D trans3D = new Transform3D();
        j3dNode.getTransform(trans3D);
        Vector3f trans = new Vector3f();
        trans3D.get(trans);
        vrml97Node.setTranslation(trans.x, trans.y, trans.z);
        Quat4f q2 = new Quat4f();
        trans3D.get(q2);
        AxisAngle4f axisAngle = new AxisAngle4f();
        axisAngle.set(q2);
        vrml97Node.setRotation(axisAngle.x, axisAngle.y, axisAngle.z, axisAngle.angle);
        Vector3d scale = new Vector3d();
        trans3D.getScale(scale);
        vrml97Node.setScale((float)scale.x, (float)scale.y, (float)scale.z);
        j3dNode.getTransform(trans3D);
        return vrml97Node;
    }

    public PointLightNode createVRML97PointLightNode(AmbientLight j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 14);
        PointLightNode vrml97Node = new PointLightNode();
        Color3f color = new Color3f();
        j3dNode.getColor(color);
        vrml97Node.setColor(color.x, color.y, color.z);
        vrml97Node.setAmbientIntensity(1.0f);
        vrml97Node.setIntensity(0.0f);
        vrml97Node.setRadius(0.0f);
        return vrml97Node;
    }

    public org.cybergarage.x3d.node.Node createVRML97ShapeNode(Shape3D j3dNode) {
        Geometry3DNode geomNode;
        Geometry j3dGeom;
        int nGeom = j3dNode.numGeometries();
        if (1 < nGeom) {
            return this.createVRML97ShapeGroupNode(j3dNode);
        }
        this.setCapability((SceneGraphObject)j3dNode, 14);
        this.setCapability((SceneGraphObject)j3dNode, 12);
        ShapeNode vrml97Node = new ShapeNode();
        Appearance j3dApp = j3dNode.getAppearance();
        if (j3dApp != null) {
            vrml97Node.addChildNode(this.createVRML97AppearanceNode(j3dApp));
        }
        if ((j3dGeom = j3dNode.getGeometry()) != null && (geomNode = this.createVRML97Geometry3DNode(j3dGeom)) != null) {
            vrml97Node.addChildNode(geomNode);
        }
        return vrml97Node;
    }

    public GroupNode createVRML97ShapeGroupNode(Shape3D j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 14);
        this.setCapability((SceneGraphObject)j3dNode, 12);
        GroupNode vrml97Node = new GroupNode();
        Appearance j3dApp = j3dNode.getAppearance();
        int nGeom = j3dNode.numGeometries();
        for (int i = 0; i < nGeom; ++i) {
            Geometry3DNode geomNode;
            Geometry j3dGeom;
            ShapeNode shapeNode = new ShapeNode();
            vrml97Node.addChildNode(shapeNode);
            if (j3dApp != null) {
                shapeNode.addChildNode(this.createVRML97AppearanceNode(j3dApp));
            }
            if ((j3dGeom = j3dNode.getGeometry(i)) == null || (geomNode = this.createVRML97Geometry3DNode(j3dGeom)) == null) continue;
            shapeNode.addChildNode(geomNode);
        }
        return vrml97Node;
    }

    public AppearanceNode createVRML97AppearanceNode(Appearance j3dNode) {
        PixelTextureNode texNode;
        Texture j3dTexture;
        this.setCapability((SceneGraphObject)j3dNode, 0);
        this.setCapability((SceneGraphObject)j3dNode, 2);
        AppearanceNode vrml97Node = new AppearanceNode();
        Material j3dMaterial = j3dNode.getMaterial();
        TransparencyAttributes transparencyAtt = j3dNode.getTransparencyAttributes();
        if (j3dMaterial != null) {
            MaterialNode material = this.createVRML97MaterialNode(j3dMaterial);
            if (transparencyAtt != null) {
                material.setTransparency(transparencyAtt.getTransparency());
            }
            vrml97Node.addChildNode(material);
        }
        if ((j3dTexture = j3dNode.getTexture()) != null && j3dTexture instanceof Texture2D && (texNode = this.createVRML97PixelTextureNode((Texture2D)j3dTexture)) != null) {
            vrml97Node.addChildNode(texNode);
        }
        return vrml97Node;
    }

    public MaterialNode createVRML97MaterialNode(Material j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 0);
        MaterialNode vrml97Node = new MaterialNode();
        Color3f color = new Color3f();
        vrml97Node.setAmbientIntensity(0.2f);
        j3dNode.getDiffuseColor(color);
        vrml97Node.setDiffuseColor(color.x, color.y, color.z);
        j3dNode.getEmissiveColor(color);
        vrml97Node.setEmissiveColor(color.x, color.y, color.z);
        j3dNode.getSpecularColor(color);
        vrml97Node.setSpecularColor(color.x, color.y, color.z);
        vrml97Node.setShininess(j3dNode.getShininess());
        return vrml97Node;
    }

    public PixelTextureNode createVRML97PixelTextureNode(Texture2D j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 4);
        ImageComponent imgComp = j3dNode.getImage(0);
        if (imgComp == null) {
            return null;
        }
        if (!(imgComp instanceof ImageComponent2D)) {
            return null;
        }
        ImageComponent2D imgComp2D = (ImageComponent2D)imgComp;
        this.setCapability((SceneGraphObject)imgComp2D, 1);
        this.setCapability((SceneGraphObject)imgComp2D, 2);
        this.setCapability((SceneGraphObject)imgComp2D, 0);
        int compSize = 0;
        int format = imgComp2D.getFormat();
        if (format == 1) {
            compSize = 3;
        }
        if (format == 2) {
            compSize = 4;
        }
        if (compSize == 0) {
            return null;
        }
        BufferedImage bufImage = imgComp2D.getImage();
        if (bufImage == null) {
            return null;
        }
        int width = bufImage.getWidth();
        int height = bufImage.getHeight();
        PixelTextureNode vrml97Node = new PixelTextureNode();
        vrml97Node.addImage(width);
        vrml97Node.addImage(height);
        vrml97Node.addImage(compSize);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                vrml97Node.addImage(bufImage.getRGB(x, height - 1 - y));
            }
        }
        return vrml97Node;
    }

    public Geometry3DNode createVRML97Geometry3DNode(Geometry j3dNode) {
        Geometry3DNode vrml97Node = null;
        if (j3dNode instanceof Text3D) {
            vrml97Node = this.createVRML97TextNode((Text3D)j3dNode);
        }
        if (j3dNode instanceof PointArray) {
            vrml97Node = this.createVRML97PointSetNode((PointArray)j3dNode);
        }
        if (j3dNode instanceof LineArray) {
            vrml97Node = this.createVRML97LineSetNode((LineArray)j3dNode);
        }
        if (j3dNode instanceof LineStripArray) {
            vrml97Node = this.createVRML97LineSetNode((LineStripArray)j3dNode);
        }
        if (j3dNode instanceof TriangleArray) {
            vrml97Node = this.createVRML97IndexedFaceSetNode((TriangleArray)j3dNode);
        }
        if (j3dNode instanceof TriangleStripArray) {
            vrml97Node = this.createVRML97IndexedFaceSetNode((TriangleStripArray)j3dNode);
        }
        if (j3dNode instanceof TriangleFanArray) {
            vrml97Node = this.createVRML97IndexedFaceSetNode((TriangleFanArray)j3dNode);
        }
        if (j3dNode instanceof QuadArray) {
            vrml97Node = this.createVRML97IndexedFaceSetNode((QuadArray)j3dNode);
        }
        if (j3dNode instanceof IndexedTriangleArray) {
            vrml97Node = this.createVRML97IndexedFaceSetNode((IndexedTriangleArray)j3dNode);
        }
        if (j3dNode instanceof IndexedQuadArray) {
            vrml97Node = this.createVRML97IndexedFaceSetNode((IndexedQuadArray)j3dNode);
        }
        if (vrml97Node == null) {
            Debug.message("Couldn't convert the geometry node (" + j3dNode + ")");
        }
        return vrml97Node;
    }

    public TextNode createVRML97TextNode(Text3D j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 2);
        TextNode vrml97Node = new TextNode();
        String string = j3dNode.getString();
        if (string != null) {
            vrml97Node.addString(string);
        }
        return vrml97Node;
    }

    public PointSetNode createVRML97PointSetNode(PointArray j3dNode) {
        int vertexFormat;
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 0);
        this.setCapability((SceneGraphObject)j3dNode, 2);
        PointSetNode vrml97Node = new PointSetNode();
        int vertexCount = j3dNode.getVertexCount();
        if (vertexCount <= 0) {
            return vrml97Node;
        }
        if ((j3dNode.getVertexFormat() & 1) != 0) {
            CoordinateNode coordNode = new CoordinateNode();
            float[] coord = new float[3];
            for (int n = 0; n < vertexCount; ++n) {
                j3dNode.getCoordinate(n, coord);
                coordNode.addPoint(coord);
            }
            vrml97Node.addChildNode(coordNode);
        }
        if (((vertexFormat = j3dNode.getVertexFormat()) & 4) != 0 || (vertexFormat & 0xC) != 0) {
            ColorNode colorNode = new ColorNode();
            float[] color = new float[4];
            for (int n = 0; n < vertexCount; ++n) {
                j3dNode.getColor(n, color);
                colorNode.addColor(color);
            }
            vrml97Node.addChildNode(colorNode);
        }
        return vrml97Node;
    }

    public IndexedLineSetNode createVRML97LineSetNode(LineArray j3dNode) {
        int vertexFormat;
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 0);
        this.setCapability((SceneGraphObject)j3dNode, 2);
        IndexedLineSetNode vrml97Node = new IndexedLineSetNode();
        int vertexCount = j3dNode.getVertexCount();
        if (vertexCount <= 0) {
            return vrml97Node;
        }
        if ((j3dNode.getVertexFormat() & 1) != 0) {
            int n;
            CoordinateNode coordNode = new CoordinateNode();
            float[] coord = new float[3];
            for (n = 0; n < vertexCount; ++n) {
                j3dNode.getCoordinate(n, coord);
                coordNode.addPoint(coord);
            }
            vrml97Node.addChildNode(coordNode);
            for (n = 0; n < vertexCount; n += 2) {
                vrml97Node.addCoordIndex(n);
                vrml97Node.addCoordIndex(n + 1);
                vrml97Node.addCoordIndex(-1);
            }
        }
        if (((vertexFormat = j3dNode.getVertexFormat()) & 4) != 0 || (vertexFormat & 0xC) != 0) {
            ColorNode colorNode = new ColorNode();
            float[] color = new float[4];
            for (int n = 0; n < vertexCount; ++n) {
                j3dNode.getColor(n, color);
                colorNode.addColor(color);
            }
            vrml97Node.addChildNode(colorNode);
            vrml97Node.setColorPerVertex(true);
        }
        return vrml97Node;
    }

    public IndexedLineSetNode createVRML97LineSetNode(LineStripArray j3dNode) {
        int vertexFormat;
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 0);
        this.setCapability((SceneGraphObject)j3dNode, 2);
        IndexedLineSetNode vrml97Node = new IndexedLineSetNode();
        int vertexCount = j3dNode.getVertexCount();
        if (vertexCount <= 0) {
            return vrml97Node;
        }
        if ((j3dNode.getVertexFormat() & 1) != 0) {
            CoordinateNode coordNode = new CoordinateNode();
            float[] coord = new float[3];
            for (int n = 0; n < vertexCount; ++n) {
                j3dNode.getCoordinate(n, coord);
                coordNode.addPoint(coord);
            }
            vrml97Node.addChildNode(coordNode);
            int numStrips = j3dNode.getNumStrips();
            int[] stripVertexCounts = new int[numStrips];
            j3dNode.getStripVertexCounts(stripVertexCounts);
            int offset = 0;
            for (int i = 0; i < numStrips; ++i) {
                int stripVertexCount = stripVertexCounts[i];
                for (int n = 0; n < stripVertexCount - 1; ++n) {
                    vrml97Node.addCoordIndex(n + offset);
                    vrml97Node.addCoordIndex(n + 1 + offset);
                    vrml97Node.addCoordIndex(-1);
                }
                offset += stripVertexCount;
            }
        }
        if (((vertexFormat = j3dNode.getVertexFormat()) & 4) != 0 || (vertexFormat & 0xC) != 0) {
            ColorNode colorNode = new ColorNode();
            float[] color = new float[4];
            for (int n = 0; n < vertexCount; ++n) {
                j3dNode.getColor(n, color);
                colorNode.addColor(color);
            }
            vrml97Node.addChildNode(colorNode);
            vrml97Node.setColorPerVertex(true);
        }
        return vrml97Node;
    }

    public boolean addGeometryArrayCoordinateToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, GeometryArray j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 0);
        if ((j3dNode.getVertexFormat() & 1) == 0) {
            return false;
        }
        int vertexCount = j3dNode.getVertexCount();
        if (vertexCount <= 0) {
            return false;
        }
        CoordinateNode coordNode = new CoordinateNode();
        float[] coord = new float[3];
        for (int n = 0; n < vertexCount; ++n) {
            j3dNode.getCoordinate(n, coord);
            coordNode.addPoint(coord);
        }
        vrml97Node.addChildNode(coordNode);
        return true;
    }

    public boolean addGeometryArrayColorToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, GeometryArray j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 2);
        int vertexFormat = j3dNode.getVertexFormat();
        if ((vertexFormat & 4) == 0 && (vertexFormat & 0xC) == 0) {
            return false;
        }
        int vertexCount = j3dNode.getVertexCount();
        if (vertexCount <= 0) {
            return false;
        }
        ColorNode colorNode = new ColorNode();
        float[] color = new float[4];
        for (int n = 0; n < vertexCount; ++n) {
            j3dNode.getColor(n, color);
            colorNode.addColor(color);
        }
        vrml97Node.addChildNode(colorNode);
        return true;
    }

    public boolean addGeometryArrayNormalToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, GeometryArray j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 4);
        if ((j3dNode.getVertexFormat() & 2) == 0) {
            return false;
        }
        int vertexCount = j3dNode.getVertexCount();
        if (vertexCount <= 0) {
            return false;
        }
        NormalNode normalNode = new NormalNode();
        float[] normal = new float[3];
        for (int n = 0; n < vertexCount; ++n) {
            j3dNode.getNormal(n, normal);
            normalNode.addVector(normal);
        }
        vrml97Node.addChildNode(normalNode);
        return true;
    }

    public boolean addGeometryArrayTextureCoordinateToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, GeometryArray j3dNode) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 6);
        if ((j3dNode.getVertexFormat() & 0x20) == 0) {
            return false;
        }
        int vertexCount = j3dNode.getVertexCount();
        if (vertexCount <= 0) {
            return false;
        }
        TextureCoordinateNode texCoordNode = new TextureCoordinateNode();
        float[] texCoord = new float[2];
        for (int n = 0; n < vertexCount; ++n) {
            j3dNode.getTextureCoordinate(n, texCoord);
            texCoordNode.addPoint(texCoord);
        }
        vrml97Node.addChildNode(texCoordNode);
        return true;
    }

    public boolean addGeometryArrayCoordinateIndexToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, IndexedGeometryArray j3dNode, int type) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 9);
        if ((j3dNode.getVertexFormat() & 1) == 0) {
            return false;
        }
        int idxCount = j3dNode.getIndexCount();
        if (idxCount <= 0) {
            return false;
        }
        for (int i = 0; i < idxCount; i += type) {
            for (int j2 = 0; j2 < type; ++j2) {
                int index = j3dNode.getCoordinateIndex(i + j2);
                vrml97Node.addCoordIndex(index);
            }
            vrml97Node.addCoordIndex(-1);
        }
        return true;
    }

    public boolean addGeometryArrayColorIndexToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, IndexedGeometryArray j3dNode, int type) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 11);
        int vertexFormat = j3dNode.getVertexFormat();
        if ((vertexFormat & 4) == 0 && (vertexFormat & 0xC) == 0) {
            return false;
        }
        int idxCount = j3dNode.getIndexCount();
        if (idxCount <= 0) {
            return false;
        }
        for (int i = 0; i < idxCount; i += type) {
            for (int j2 = 0; j2 < type; ++j2) {
                int index = j3dNode.getColorIndex(i + j2);
                vrml97Node.addColorIndex(index);
            }
            vrml97Node.addColorIndex(-1);
        }
        return true;
    }

    public boolean addGeometryArrayNormalIndexToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, IndexedGeometryArray j3dNode, int type) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 13);
        if ((j3dNode.getVertexFormat() & 2) == 0) {
            return false;
        }
        int idxCount = j3dNode.getIndexCount();
        if (idxCount <= 0) {
            return false;
        }
        for (int i = 0; i < idxCount; i += type) {
            for (int j2 = 0; j2 < type; ++j2) {
                int index = j3dNode.getNormalIndex(i + j2);
                vrml97Node.addNormalIndex(index);
            }
            vrml97Node.addNormalIndex(-1);
        }
        return true;
    }

    public boolean addGeometryArrayTextureCoordinateIndexToIndexedFaceSetNode(IndexedFaceSetNode vrml97Node, IndexedGeometryArray j3dNode, int type) {
        this.setCapability((SceneGraphObject)j3dNode, 17);
        this.setCapability((SceneGraphObject)j3dNode, 15);
        if ((j3dNode.getVertexFormat() & 0x20) == 0) {
            return false;
        }
        int idxCount = j3dNode.getIndexCount();
        if (idxCount <= 0) {
            return false;
        }
        for (int i = 0; i < idxCount; i += type) {
            for (int j2 = 0; j2 < type; ++j2) {
                int index = j3dNode.getTextureCoordinateIndex(i + j2);
                vrml97Node.addTexCoordIndex(index);
            }
            vrml97Node.addTexCoordIndex(-1);
        }
        return true;
    }

    public IndexedFaceSetNode createVRML97IndexedFaceSetNode(TriangleArray j3dNode) {
        IndexedFaceSetNode vrml97Node = new IndexedFaceSetNode();
        vrml97Node.setSolid(this.solid);
        if (this.addGeometryArrayCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            int vertexCount = j3dNode.getVertexCount();
            for (int n = 0; n < vertexCount; n += 3) {
                vrml97Node.addCoordIndex(n);
                vrml97Node.addCoordIndex(n + 1);
                vrml97Node.addCoordIndex(n + 2);
                vrml97Node.addCoordIndex(-1);
            }
        }
        if (this.addGeometryArrayColorToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setColorPerVertex(true);
        }
        if (this.addGeometryArrayNormalToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setNormalPerVertex(true);
        }
        this.addGeometryArrayTextureCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode);
        return vrml97Node;
    }

    public IndexedFaceSetNode createVRML97IndexedFaceSetNode(TriangleStripArray j3dNode) {
        IndexedFaceSetNode vrml97Node = new IndexedFaceSetNode();
        vrml97Node.setSolid(this.solid);
        Debug.message("createVRML97IndexedFaceSetNode");
        if (this.addGeometryArrayCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            int numStrips = j3dNode.getNumStrips();
            int[] stripVertexCounts = new int[numStrips];
            j3dNode.getStripVertexCounts(stripVertexCounts);
            int offset = 0;
            for (int i = 0; i < numStrips; ++i) {
                int vertexCount = stripVertexCounts[i];
                for (int n = 0; n < vertexCount - 2; ++n) {
                    if (n % 2 == 0) {
                        vrml97Node.addCoordIndex(n + offset);
                        vrml97Node.addCoordIndex(n + 1 + offset);
                        vrml97Node.addCoordIndex(n + 2 + offset);
                        vrml97Node.addCoordIndex(-1);
                        continue;
                    }
                    vrml97Node.addCoordIndex(n + offset);
                    vrml97Node.addCoordIndex(n + 2 + offset);
                    vrml97Node.addCoordIndex(n + 1 + offset);
                    vrml97Node.addCoordIndex(-1);
                }
                offset += vertexCount;
            }
        }
        if (this.addGeometryArrayColorToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setColorPerVertex(true);
        }
        if (this.addGeometryArrayNormalToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setNormalPerVertex(true);
        }
        this.addGeometryArrayTextureCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode);
        return vrml97Node;
    }

    public IndexedFaceSetNode createVRML97IndexedFaceSetNode(TriangleFanArray j3dNode) {
        IndexedFaceSetNode vrml97Node = new IndexedFaceSetNode();
        vrml97Node.setSolid(this.solid);
        if (this.addGeometryArrayCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            int numStrips = j3dNode.getNumStrips();
            int[] stripVertexCounts = new int[numStrips];
            j3dNode.getStripVertexCounts(stripVertexCounts);
            int offset = 0;
            for (int i = 0; i < numStrips; ++i) {
                int vertexCount = stripVertexCounts[i];
                for (int n = 1; n < vertexCount - 2; ++n) {
                    vrml97Node.addCoordIndex(0);
                    vrml97Node.addCoordIndex(n + 1 + offset);
                    vrml97Node.addCoordIndex(n + offset);
                    vrml97Node.addCoordIndex(-1);
                }
                offset += vertexCount;
            }
        }
        if (this.addGeometryArrayColorToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setColorPerVertex(true);
        }
        if (this.addGeometryArrayNormalToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setNormalPerVertex(true);
        }
        this.addGeometryArrayTextureCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode);
        return vrml97Node;
    }

    public IndexedFaceSetNode createVRML97IndexedFaceSetNode(QuadArray j3dNode) {
        IndexedFaceSetNode vrml97Node = new IndexedFaceSetNode();
        vrml97Node.setSolid(this.solid);
        if (this.addGeometryArrayCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            int vertexCnt = j3dNode.getVertexCount();
            for (int n = 0; n < vertexCnt; n += 4) {
                vrml97Node.addCoordIndex(n);
                vrml97Node.addCoordIndex(n + 1);
                vrml97Node.addCoordIndex(n + 2);
                vrml97Node.addCoordIndex(n + 3);
                vrml97Node.addCoordIndex(-1);
            }
        }
        if (this.addGeometryArrayColorToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setColorPerVertex(true);
        }
        if (this.addGeometryArrayNormalToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            vrml97Node.setNormalPerVertex(true);
        }
        this.addGeometryArrayTextureCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode);
        return vrml97Node;
    }

    public IndexedFaceSetNode createVRML97IndexedFaceSetNode(IndexedTriangleArray j3dNode) {
        IndexedFaceSetNode vrml97Node = new IndexedFaceSetNode();
        vrml97Node.setSolid(this.solid);
        if (this.addGeometryArrayCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            this.addGeometryArrayCoordinateIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_TRIANGLE);
        }
        if (this.addGeometryArrayColorToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode) && this.addGeometryArrayColorIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_TRIANGLE)) {
            vrml97Node.setColorPerVertex(true);
        }
        if (this.addGeometryArrayNormalToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode) && this.addGeometryArrayNormalIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_TRIANGLE)) {
            vrml97Node.setNormalPerVertex(true);
        }
        this.addGeometryArrayTextureCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode);
        this.addGeometryArrayTextureCoordinateIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_TRIANGLE);
        return vrml97Node;
    }

    public IndexedFaceSetNode createVRML97IndexedFaceSetNode(IndexedQuadArray j3dNode) {
        IndexedFaceSetNode vrml97Node = new IndexedFaceSetNode();
        vrml97Node.setSolid(this.solid);
        if (this.addGeometryArrayCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode)) {
            this.addGeometryArrayCoordinateIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_QUAD);
        }
        if (this.addGeometryArrayColorToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode) && this.addGeometryArrayColorIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_QUAD)) {
            vrml97Node.setColorPerVertex(true);
        }
        if (this.addGeometryArrayNormalToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode) && this.addGeometryArrayNormalIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_QUAD)) {
            vrml97Node.setNormalPerVertex(true);
        }
        this.addGeometryArrayTextureCoordinateToIndexedFaceSetNode(vrml97Node, (GeometryArray)j3dNode);
        this.addGeometryArrayTextureCoordinateIndexToIndexedFaceSetNode(vrml97Node, (IndexedGeometryArray)j3dNode, IDXGEOMTYPE_QUAD);
        return vrml97Node;
    }
}

