/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import java.io.Serializable;
import org.cybergarage.x3d.field.FloatValue;
import org.cybergarage.x3d.field.Vec3fValue;

public class RotationValue
implements Serializable {
    private Vec3fValue mVector = new Vec3fValue(0.0f, 1.0f, 0.0f);
    private FloatValue mAngle = new FloatValue(0.0f);

    public RotationValue() {
        this.setValue(0.0f, 0.0f, 1.0f, 0.0f);
    }

    public RotationValue(float x, float y, float z, float rot) {
        this.setValue(x, y, z, rot);
    }

    public RotationValue(float[] value) {
        this.setValue(value);
    }

    public void setValue(float x, float y, float z, float rot) {
        this.mVector.setValue(x, y, z);
        this.mVector.normalize();
        this.setAngle(rot);
    }

    public void setValue(float[] value) {
        this.setValue(value[0], value[1], value[2], value[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAngle(float angle) {
        FloatValue floatValue = this.mAngle;
        synchronized (floatValue) {
            this.mAngle.setValue(angle);
        }
    }

    public void getValue(float[] value) {
        this.mVector.getValue(value);
        value[3] = this.getAngle();
    }

    public float[] getValue() {
        float[] value = new float[4];
        this.getValue(value);
        return value;
    }

    public void getVector(float[] vector) {
        this.mVector.getValue(vector);
    }

    public float[] getVector() {
        float[] vector = new float[3];
        this.mVector.getValue(vector);
        return vector;
    }

    float getX() {
        return this.mVector.getX();
    }

    float getY() {
        return this.mVector.getY();
    }

    float getZ() {
        return this.mVector.getZ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAngle() {
        float angle;
        FloatValue floatValue = this.mAngle;
        synchronized (floatValue) {
            angle = this.mAngle.getValue();
        }
        return angle;
    }
}

