/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.remotehostexecuter;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptWrapper;
import ciss.phase_viewer.scripting.scriptexecscripts.ExecScriptCreator;
import ciss.phase_viewer.scripting.scriptreplace.ScriptKeywordsReplacer;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.Execute;
import ciss.phase_viewer.ssh.SessionCreator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.remotehostexecuter.BatchFileTransferer;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class JobExecuter
implements SftpListener,
Serializable {
    private transient Logger logger = Logger.getLogger(JobExecuter.class.getName());
    private String projdir;
    private HostInfo hostinfo;
    private boolean islocalhost = false;
    private String script;
    private String targetdir;
    private BatchFileTransferer batchTransfer;
    private String subfile;
    private Document jobControlDocument;
    private ProjectInfo projectInfo;
    private String scriptType;
    private boolean isValid = true;
    private ScriptWrapper scriptExecScript;
    private String scriptExecScriptExecString;
    private boolean repbymail = false;
    private Vector execScripts = new Vector();
    private Vector otherScripts = new Vector();
    private Session session;

    public JobExecuter(ProjectInfo projectInfo, HostInfo hostinfo, BatchFileTransferer batchTransfer) {
        this.projectInfo = projectInfo;
        this.projdir = projectInfo.getProjectDirectory();
        this.hostinfo = hostinfo;
        this.batchTransfer = batchTransfer;
        this.jobControlDocument = projectInfo.getProjectPropertyDocument();
        if (!this.parseJobControlDocument()) {
            this.logger.error("invalid job-control document.");
            this.isValid = false;
        }
        if (!this.preProcessScript()) {
            this.logger.error("failed to preprocess script.");
            this.isValid = false;
        }
        batchTransfer.addSftpListener(this);
        this.targetdir = projectInfo.getTargetDirectory();
    }

    private boolean parseJobControlDocument() {
        if (this.jobControlDocument == null) {
            this.logger.error("jobcontrol document is null.");
            return false;
        }
        if (!this.jobControlDocument.hasRootElement()) {
            this.logger.error("jobcontrol document does not have a root element.");
            return false;
        }
        Element jobControlElement = this.jobControlDocument.getRootElement().getChild(JobController.JOBCONTROL);
        if (jobControlElement == null) {
            this.logger.error("could not find a job-control element");
            return false;
        }
        Element scriptElement = jobControlElement.getChild("script");
        if (scriptElement == null) {
            this.logger.error("no script element");
            return false;
        }
        this.scriptType = MyElement.decode(scriptElement.getChildTextTrim("script_type"));
        Element execElement = scriptElement.getChild("exec");
        if (execElement == null || execElement.getContentSize() == 0) {
            this.logger.error("no exec scripts.");
            return false;
        }
        List execList = execElement.getChildren("exec_script");
        for (int i = 0; i < execList.size(); ++i) {
            Element exe = (Element)execList.get(i);
            String type = MyElement.decode(exe.getChildTextTrim("script_type"));
            if (!type.equals(this.scriptType)) continue;
            this.execScripts.addElement(new ScriptWrapper(this.projectInfo.getProjectDirectory() + System.getProperty("file.separator") + MyElement.decode(exe.getChildTextTrim("script_path")), type));
        }
        return true;
    }

    private boolean preProcessScript() {
        String dir = this.projectInfo.getProjectDirectory();
        if (!dir.endsWith(System.getProperty("file.separator"))) {
            dir = dir + System.getProperty("file.separator");
        }
        ScriptKeywordsReplacer replacer = new ScriptKeywordsReplacer();
        for (int i = 0; i < this.execScripts.size(); ++i) {
            ScriptWrapper script = (ScriptWrapper)this.execScripts.get(i);
            replacer.replace(script, this.jobControlDocument);
            File file = new File(script.getPath());
            String replacedFile = file.getParent() + System.getProperty("file.separator") + "__" + file.getName();
            this.batchTransfer.registerFiles(replacedFile);
        }
        Object[] foo = new ScriptWrapper[this.execScripts.size()];
        this.execScripts.copyInto(foo);
        String foobar = ExecScriptCreator.getScriptExecScript(this.scriptType, (ScriptWrapper[])foo, this.hostinfo);
        ScriptWrapper tmpScriptExecScript = new ScriptWrapper(foobar, ScriptWrapper.getTypeFromFile(foobar));
        replacer.replace(tmpScriptExecScript, this.jobControlDocument, true);
        String scriptExecPath = dir + new File(tmpScriptExecScript.getPath()).getName();
        this.scriptExecScript = new ScriptWrapper(scriptExecPath, ScriptWrapper.getTypeFromFile(scriptExecPath));
        try {
            new File(this.scriptExecScript.getPath()).delete();
            ExternalProgramExecuter.copyBinary(tmpScriptExecScript.getPath(), this.scriptExecScript.getPath());
        }
        catch (Exception exc) {
            this.logger.error("failed to copy script-exec script.");
        }
        if (new File(dir + "report.bsh").exists() && new File(dir + "mail.xml").exists()) {
            this.repbymail = true;
            PrintWriter writer = Utils.getPrintWriter(this.scriptExecScript.getPath(), true);
            writer.print("\"__JAVA__\" -Dpviewer.home=\"__CHASEDIR__\" -jar \"__CHASEJAR__\" interpreter_mode report.bsh\n");
            if (!this.hostinfo.isLocalHost()) {
                writer.println("rm -f report.bsh");
                writer.println("rm -f mail.xml");
            }
            new File(dir + "report.bsh").deleteOnExit();
            new File(dir + "mail.xml").deleteOnExit();
            writer.flush();
            writer.close();
            replacer.replace(this.scriptExecScript, this.jobControlDocument, true);
            this.batchTransfer.registerFiles(dir + "report.bsh");
            this.batchTransfer.registerFiles(dir + "mail.xml");
        }
        this.scriptExecScriptExecString = ExecScriptCreator.getScriptExecScriptExecString(this.scriptType, this.scriptExecScript.getPath(), this.hostinfo);
        this.batchTransfer.registerFiles(this.scriptExecScript.getPath());
        return true;
    }

    public void uploadFinished(SftpEvent se) {
        this.submit();
    }

    public void downloadFinished(SftpEvent se) {
    }

    public void setScriptText(String script) {
        this.script = script;
    }

    public boolean execute() {
        if (!this.isValid) {
            return false;
        }
        this.transferFiles();
        return true;
    }

    private void transferFiles() {
        if (!this.hostinfo.isLocalHost()) {
            this.batchTransfer.upload();
        } else {
            this.uploadFinished(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit() {
        this.logger.info("submitting " + this.scriptExecScript.getPath() + " to host : " + this.hostinfo.getName());
        if (!this.hostinfo.isLocalHost()) {
            String filename = new File(this.scriptExecScript.getPath()).getName();
            String chmod = "chmod +x " + this.targetdir + "/" + filename;
            Session sess = null;
            try {
                sess = SessionCreator.getSession(this.hostinfo);
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
            Execute exe = new Execute(sess);
            String ret = exe.command(chmod);
            exe.disconnect();
            if (ret != null && ret.length() != 0) {
                this.logger.info("info from 'chmod' command:");
                this.logger.info("\n" + ret);
            }
            for (int i = 0; i < this.execScripts.size(); ++i) {
                String name = new File(((ScriptWrapper)this.execScripts.get(i)).getPath()).getName();
                new File(this.projdir + System.getProperty("file.separator") + "__" + name).delete();
            }
            new File(this.scriptExecScript.getPath()).delete();
            new Thread(new RemoteExecuterThread()).start();
        } else {
            boolean execDirectly;
            boolean bl = execDirectly = new Boolean(PropertiesManager.getGlobalProperties(0).getProperty("exec_bin_directly")) != false && !this.scriptType.equals("bsh") && !this.repbymail;
            if (!execDirectly) {
                try {
                    if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                        try {
                            Process p = Runtime.getRuntime().exec("chmod 755 " + this.scriptExecScript.getPath());
                            p.waitFor();
                        }
                        catch (Exception exc) {
                            this.logger.error("failed to chmod");
                            exc.printStackTrace();
                        }
                    }
                    MyThread thread = new MyThread(this.scriptExecScriptExecString);
                    this.logger.info("submitted job to: " + this.hostinfo.getName());
                }
                catch (Exception exc) {
                    this.logger.error("failed execution of script: " + this.scriptExecScript.getPath());
                }
            } else {
                for (int i = 0; i < this.execScripts.size(); ++i) {
                    ScriptWrapper sw = (ScriptWrapper)this.execScripts.get(i);
                    String newfile = this.projectInfo.getProjectDirectory() + "__" + new File(sw.getPath()).getName();
                    BufferedReader rd = Utils.getReader(newfile);
                    String line = "";
                    try {
                        while ((line = rd.readLine()) != null) {
                            new MyThread(line.trim(), "", new File(this.projectInfo.getProjectDirectory()));
                        }
                        continue;
                    }
                    catch (IOException e) {
                        continue;
                    }
                    finally {
                        try {
                            rd.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    class RemoteExecuterThread
    implements Runnable {
        private Logger logger = Logger.getLogger(RemoteExecuterThread.class.getName());
        private Execute exe;

        RemoteExecuterThread() {
        }

        public void run() {
            Session sess = null;
            try {
                sess = SessionCreator.getSession(JobExecuter.this.hostinfo);
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
            String filename = new File(JobExecuter.this.scriptExecScript.getPath()).getName();
            Execute exe = new Execute(sess);
            exe.isVerbose(false);
            exe.command(JobExecuter.this.targetdir + "/" + filename);
            this.logger.info("submitted job to: " + JobExecuter.this.hostinfo.getName());
            sess.disconnect();
        }
    }

    class LocalExecuterThread
    implements Runnable {
        LocalExecuterThread() {
        }

        public void run() {
        }
    }
}

