/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.remotehostexecuter;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.sftp.Sftp;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BatchFileTransferer
implements SftpListener,
Serializable {
    private static Logger logger = Logger.getLogger(BatchFileTransferer.class.getName());
    private HostInfo hostinfo;
    private String targetdir;
    private String localdir;
    private Sftp sftp;
    private ChannelSftp c;
    private Vector regfiles = new Vector();
    private Vector listeners = new Vector();
    private ProjectInfo projectInfo;
    private ChaseFile[] chaseFiles;

    public BatchFileTransferer(ProjectInfo projectInfo, HostInfo hostinfo) {
        this.localdir = projectInfo.getProjectDirectory();
        this.projectInfo = projectInfo;
        this.hostinfo = hostinfo;
        this.init();
    }

    public void disconnect() {
        if (this.sftp != null) {
            this.sftp.disconnect();
        }
    }

    public void registerFiles(String path) {
        this.regfiles.add(path);
    }

    public void uploadFinished(SftpEvent se) {
        logger.info("finished upload.");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SftpListener)this.listeners.elementAt(i)).uploadFinished(se);
        }
        this.sftp.disconnect();
    }

    public void downloadFinished(SftpEvent se) {
        logger.info("finished download.");
        this.sftp.disconnect();
    }

    public void addSftpListener(SftpListener list) {
        this.listeners.addElement(list);
    }

    private void init() {
        logger.debug("initializing....");
        this.targetdir = this.projectInfo.getTargetDirectory();
        ChaseFileManager cfmanager = this.projectInfo.getChaseFileManager();
        if (cfmanager == null) {
            logger.error("invalid ChaseFileManager.");
            return;
        }
        this.chaseFiles = cfmanager.getFiles();
        logger.debug("initialization finished...");
    }

    public String getTargetDir() {
        return this.targetdir;
    }

    public Session getSession() {
        if (this.sftp != null) {
            return this.sftp.getSession();
        }
        return null;
    }

    public boolean upload(File file) {
        RemoteFile[] rfs = new RemoteFile[]{new RemoteFile(file.getAbsolutePath())};
        this.sftp = new Sftp(this.hostinfo);
        this.sftp.addSftpListener(this);
        this.sftp.connect();
        this.c = this.sftp.getChannelSftp();
        this.sftp.upload(rfs, new RemoteFile(this.targetdir, this.c), this.projectInfo.getProjectDirectory());
        return true;
    }

    public boolean upload() {
        logger.debug("uploading .... host: " + this.hostinfo.getName());
        if (this.hostinfo == null) {
            logger.error("invalid hostinfo.");
            return false;
        }
        if (this.targetdir == null || this.targetdir.trim().length() == 0) {
            this.targetdir = "";
        }
        if (this.targetdir.startsWith("$HOME/")) {
            this.targetdir = this.targetdir.substring(6, this.targetdir.length());
        }
        logger.debug("uploading file to " + this.hostinfo.getName() + ", target dir: " + this.targetdir);
        RemoteFile[] rfs = this.chaseFile2RemoteFile("upload");
        if (rfs == null) {
            logger.debug("found no valid files...");
            return false;
        }
        for (int i = 0; i < rfs.length; ++i) {
            logger.debug("file no. " + i + ": " + rfs[i].toString());
        }
        this.sftp.upload(rfs, new RemoteFile(this.targetdir, this.c), this.projectInfo.getProjectDirectory());
        return true;
    }

    public boolean download() {
        if (this.hostinfo == null) {
            return false;
        }
        if (this.targetdir == null || this.targetdir.trim().length() == 0) {
            this.targetdir = "";
        }
        if (this.targetdir.startsWith("$HOME/")) {
            this.targetdir = this.targetdir.substring(6, this.targetdir.length());
        }
        logger.debug("downloading file to " + this.hostinfo.getName() + ", target dir: " + this.targetdir);
        RemoteFile[] rfs = this.chaseFile2RemoteFile("download");
        if (rfs == null) {
            return false;
        }
        this.sftp.download(rfs, new RemoteFile(this.projectInfo.getProjectDirectory()), false);
        return true;
    }

    private String replaceHOME(String dir) {
        if (dir.startsWith("$HOME/")) {
            return dir.substring(6, dir.length());
        }
        return dir;
    }

    private RemoteFile[] chaseFile2RemoteFile(String mode) {
        int i;
        if (this.chaseFiles == null) {
            logger.debug("invalid chaseFiles");
            return null;
        }
        int numfiles = this.chaseFiles.length;
        logger.debug("at chaseFile2RemoteFile, mode: " + mode + ", num. files: " + numfiles);
        this.sftp = new Sftp(this.hostinfo);
        this.sftp.addSftpListener(this);
        this.sftp.connect();
        this.c = this.sftp.getChannelSftp();
        if (this.c == null) {
            return null;
        }
        Vector filevector = new Vector();
        ChannelSftp ctmp = null;
        if (mode.equals("download")) {
            ctmp = this.c;
        }
        Vector<RemoteFile> remfiles = new Vector<RemoteFile>();
        for (i = 0; i < numfiles; ++i) {
            ChaseFile file = this.chaseFiles[i];
            logger.debug("processing file: " + file);
            if (!file.upload_or_download(mode)) continue;
            if (file == null) {
                logger.error("element is null!");
                return null;
            }
            String directory = "";
            String filesep = System.getProperty("file.separator");
            if (mode.equals("upload")) {
                directory = this.replaceHOME(this.projectInfo.getProjectDirectory());
                if (!directory.endsWith(System.getProperty("file.separator"))) {
                    directory = directory + System.getProperty("file.separator");
                }
            } else if (mode.equals("download")) {
                filesep = "/";
                directory = this.replaceHOME(this.projectInfo.getTargetDirectory());
                if (!directory.endsWith(filesep)) {
                    directory = directory + filesep;
                }
            }
            String transfer = file.getTransfer();
            Vector fnamevec = new Vector();
            logger.debug("directory, transfer: " + directory + ", " + transfer);
            if (!file.getDefaultName().hasRegExp()) {
                fnamevec.add(file.getFileName());
            } else if (transfer.equals(ChaseFile.ALL)) {
                String rname = file.getDefaultName().getValue();
                fnamevec = this.getFileNamesFromRegExpEntry(directory, rname, ctmp);
            } else {
                String rname = file.getDefaultName().getValue();
                String foo = this.getFileNameFromRegExpEntry(directory, rname, ctmp);
                fnamevec.addElement(foo);
            }
            if (fnamevec.size() == 0) continue;
            for (int j2 = 0; j2 < fnamevec.size(); ++j2) {
                String filepath = directory + file.getRelativePath() + filesep + (String)fnamevec.get(j2);
                RemoteFile rf = new RemoteFile(filepath, ctmp);
                if (!rf.exists()) continue;
                rf.setChaseFile(file);
                if (file.getDuplicateFile().equals(ChaseFile.OVERWRITE)) {
                    rf.overwrite(true);
                } else {
                    rf.overwrite(false);
                }
                remfiles.addElement(rf);
            }
            logger.debug("ok done with " + file.getFileName());
        }
        for (i = 0; i < this.regfiles.size(); ++i) {
            remfiles.add(new RemoteFile((String)this.regfiles.elementAt(i), ctmp));
        }
        if (remfiles.size() == 0) {
            return null;
        }
        Object[] ret = new RemoteFile[remfiles.size()];
        remfiles.copyInto(ret);
        return ret;
    }

    private String getFileNameFromRegExpEntry(String target, String name, ChannelSftp c2) {
        String ret = "";
        logger.debug("targetdir: " + target);
        RemoteFile rf = new RemoteFile(target, c2);
        RemoteFile[] rfs = (RemoteFile[])rf.listFiles();
        if (rfs == null || rfs.length == 0) {
            logger.debug("remote file list was null.");
            return ret;
        }
        long newest = 0L;
        boolean inew = false;
        for (int i = 0; i < rfs.length; ++i) {
            if (rfs[i].getName().matches(name)) {
                logger.debug("caught: " + rfs[i].getName());
                long last = rfs[i].lastModified();
                if (last <= newest) continue;
                ret = rfs[i].getName();
                continue;
            }
            logger.debug(rfs[i].getName() + " does not match " + name + ".");
        }
        logger.debug("newest file: " + ret);
        return ret;
    }

    private Vector getFileNamesFromRegExpEntry(String target, String name, ChannelSftp c2) {
        logger.debug("targetdir: " + target);
        Vector<String> ret = new Vector<String>();
        RemoteFile rf = new RemoteFile(target, c2);
        RemoteFile[] rfs = (RemoteFile[])rf.listFiles();
        if (rfs == null || rfs.length == 0) {
            logger.debug("remote file list was null.");
            return ret;
        }
        for (int i = 0; i < rfs.length; ++i) {
            if (rfs[i].getName().matches(name)) {
                logger.debug("caught: " + rfs[i].getName());
                ret.addElement(rfs[i].getName());
                continue;
            }
            logger.debug(rfs[i].getName() + " does not match " + name + ".");
        }
        return ret;
    }
}

