/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.settings;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropConfigGUI;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class PropConfigTextField
extends JTextField
implements PropConfigGUI {
    private Logger logger = Logger.getLogger(PropConfigTextField.class.getName());
    public static int FLOAT = 0;
    public static int INT = 1;
    public static int STR = 2;
    private int valtype = FLOAT;
    private String key;
    private GlobalProperties properties;

    public PropConfigTextField(int col, int valtype, String key, GlobalProperties properties) {
        super(col);
        this.valtype = valtype;
        this.key = key;
        this.properties = properties;
        this.init();
    }

    public PropConfigTextField(String initText, int valtype, String key, GlobalProperties properties) {
        super(initText);
        this.valtype = valtype;
        this.key = key;
        this.properties = properties;
        this.init();
    }

    private void init() {
        this.load();
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                PropConfigTextField.this.save();
            }
        });
    }

    public void save() {
        String str = this.getText();
        if (str == null || str.trim().length() == 0) {
            return;
        }
        str = str.trim();
        if (this.valtype == FLOAT) {
            try {
                Float.parseFloat(str);
                this.properties.setProperty(this.key, str);
            }
            catch (Exception exc) {}
        } else if (this.valtype == INT) {
            try {
                Integer.parseInt(str);
                this.properties.setProperty(this.key, str);
            }
            catch (Exception exception) {}
        } else {
            this.properties.setProperty(this.key, str);
        }
    }

    public void load() {
        String str = this.properties.getProperty(this.key);
        if (str == null || str.trim().length() == 0) {
            return;
        }
        str = str.trim();
        if (this.valtype == FLOAT) {
            try {
                Float.parseFloat(str);
                this.setText(str);
            }
            catch (Exception exc) {}
        } else if (this.valtype == INT) {
            try {
                Integer.parseInt(str);
                this.setText(str);
            }
            catch (Exception exception) {}
        } else {
            this.setText(str);
        }
    }
}

