/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptreplace;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.scripting.ScriptWrapper;
import ciss.phase_viewer.scripting.scriptreplace.ScriptReplaceRules;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;

public class ScriptKeywordsReplacer {
    public static final String REPLACED_FILE_PREFIX = "__";
    private final String props = "/ciss/phase_viewer/scripting/scriptreplace/rules.properties";
    private Vector rules;
    private Logger logger = Logger.getLogger(ScriptKeywordsReplacer.class.getName());

    public ScriptKeywordsReplacer() {
        this.rules = new Vector();
        Properties properties = Utils.getPropertiesFrom("/ciss/phase_viewer/scripting/scriptreplace/rules.properties");
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String loadClass = properties.getProperty(enumeration.nextElement().toString());
                ScriptReplaceRules rule = (ScriptReplaceRules)PluginLoader.instantiate(loadClass, null);
                this.rules.addElement(rule);
            }
        }
    }

    public boolean replace(ScriptWrapper script, Document document) {
        return this.replace(script, document, false);
    }

    public boolean replace(ScriptWrapper script, Document document, boolean overwrite2) {
        if (this.rules.size() == 0) {
            return false;
        }
        String scriptText = Utils.getStringFromFile(script.getPath());
        for (int i = 0; i < this.rules.size(); ++i) {
            scriptText = ((ScriptReplaceRules)this.rules.get(i)).replace(scriptText, document, overwrite2);
            this.logger.debug("applying replace rule: " + this.rules.get(i).getClass().getName());
            if (scriptText != null) continue;
            return false;
        }
        this.createNewScript(script.getPath(), scriptText, overwrite2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNewScript(String file, String script, boolean overwrite2) {
        String dir = new File(file).getParent();
        File newfile = new File(file);
        if (!overwrite2) {
            newfile = new File(dir + System.getProperty("file.separator") + REPLACED_FILE_PREFIX + new File(file).getName());
        }
        newfile.delete();
        if (ScriptWrapper.getTypeFromFile(newfile.getName()).equals(ScriptWrapper.BSH)) {
            script = script.replaceAll("\\\\", "\\\\\\\\");
        }
        BufferedWriter bwriter = null;
        try {
            bwriter = new BufferedWriter(new FileWriter(newfile));
            bwriter.write(script, 0, script.length());
            bwriter.flush();
        }
        catch (IOException ioe) {
            this.logger.error("failed to create new script");
            ioe.printStackTrace();
        }
        finally {
            try {
                bwriter.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

