/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.jobcontrol;

import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.Monitorable;
import ciss.phase_viewer.jobcontrol.MonitorPanelInterface;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.SessionCreator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;

public class MonitorPanelPanel
extends JPanel
implements ChartProgressListener,
MonitorPanelInterface {
    private boolean drawingChart = false;
    private HostInfo targetHost;
    private Logger logger = Logger.getLogger(MonitorPanelPanel.class.getName());
    private ProjectInfo projectInfo;
    private ChaseFile[] chaseFile;
    private Session session;
    private JComboBox fileSelector;
    private JTextArea monitorTextArea;
    private Monitorable monitorable;
    private JToggleButton monitorButton;
    private JToggleButton graphButton;
    private HashMap monitorCache = new HashMap();

    public void chartProgress(ChartProgressEvent arg0) {
        if (arg0.getType() == 1) {
            this.drawingChart = true;
        } else if (arg0.getType() == 2) {
            this.drawingChart = false;
        }
    }

    public MonitorPanelPanel(ProjectInfo projectInfo, HostInfo targetHost) {
        this.projectInfo = projectInfo;
        this.targetHost = targetHost;
        this.init();
    }

    public void reset() {
        try {
            this.monitorTextArea.setText("");
            this.monitorButton.setSelected(false);
            this.graphButton.setSelected(false);
            this.monitorable.destroyGraph();
            this.monitorable.stopMonitor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.monitorButton.setSelected(true);
        this.monitorButtonToggled();
    }

    public void monitorButtonToggled() {
        if (this.targetHost.isLocalHost()) {
            this.session = null;
        } else {
            if (this.session != null) {
                this.session.disconnect();
            }
            try {
                this.session = SessionCreator.getSession(this.targetHost);
                try {
                    this.session.sendKeepAliveMsg();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
        }
        if (this.monitorable != null && this.monitorButton.isSelected()) {
            if (this.monitorable != null) {
                this.monitorable.stopMonitor();
            }
            this.monitorable.monitor(this.session, this.monitorTextArea);
            this.graphButton.setEnabled(this.monitorable.isGraphCreatable(this.monitorTextArea));
        } else if (this.monitorable != null && !this.monitorButton.isSelected()) {
            this.monitorable.stopMonitor();
            this.graphButton.setEnabled(false);
            this.graphButton.setSelected(false);
            this.monitorable.destroyGraph();
        }
    }

    public void setTargetHost(HostInfo targetHost) {
        if (!this.targetHost.getName().equals(targetHost.getName())) {
            this.monitorTextArea.setText("");
            this.monitorButton.setSelected(false);
            this.graphButton.setSelected(false);
        }
        this.targetHost = targetHost;
    }

    private void init() {
        ChaseFile[] cfs = this.projectInfo.getChaseFileManager().getFiles();
        if (cfs == null || cfs.length == 0) {
            this.logger.error("invalid files!");
            return;
        }
        Vector<ChaseFile> validFiles = new Vector<ChaseFile>();
        for (int i = 0; i < cfs.length; ++i) {
            this.logger.debug("cfs: " + cfs[i]);
            if (!cfs[i].isMonitorable()) continue;
            validFiles.addElement(cfs[i]);
        }
        if (validFiles.size() == 0) {
            this.logger.error("no monitorable files.");
            return;
        }
        this.chaseFile = new ChaseFile[validFiles.size()];
        validFiles.copyInto(this.chaseFile);
        JPanel fileMonitor = this.getFileMonitorPanel();
        JButton btnclose = new JButton("close");
        this.setLayout(new BoxLayout(this, 1));
        this.add(fileMonitor);
    }

    public void setGraphButtonSelected(boolean sel) {
        if (this.graphButton != null) {
            int i;
            this.logger.debug("calling graphButton.setSelected(" + sel + ")");
            ActionListener[] al = this.graphButton.getActionListeners();
            if (al != null) {
                for (i = 0; i < al.length; ++i) {
                    this.graphButton.removeActionListener(al[i]);
                }
            }
            this.graphButton.setSelected(sel);
            if (al != null) {
                for (i = 0; i < al.length; ++i) {
                    this.graphButton.addActionListener(al[i]);
                }
            }
        }
    }

    private JPanel getFileMonitorPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        String[] idents = new String[this.chaseFile.length];
        for (int i = 0; i < idents.length; ++i) {
            idents[i] = this.chaseFile[i].getIdentifier().getValue();
        }
        this.fileSelector = new JComboBox<String>(idents);
        this.monitorButton = new JToggleButton(Resources.getIcon("/org/javalobby/icons/20x20/VCRPlay.gif"));
        this.monitorButton.setToolTipText("toggle monitor");
        this.graphButton = new JToggleButton(Resources.getIcon("/org/javalobby/icons/20x20/LineGraph.gif"));
        this.graphButton.setEnabled(false);
        JPanel psele = new JPanel();
        psele.setBorder(new TitledBorder("select file to monitor"));
        psele.setLayout(new BoxLayout(psele, 0));
        psele.add(this.fileSelector);
        pbtns.add(psele);
        pbtns.add(this.monitorButton);
        pbtns.add(this.graphButton);
        p.add((Component)pbtns, "North");
        this.monitorTextArea = new JTextArea();
        this.monitorTextArea.setEditable(false);
        JScrollPane scrpane = new JScrollPane(this.monitorTextArea);
        p.add((Component)scrpane, "Center");
        this.fileSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MonitorPanelPanel.this.fileSelected();
            }
        });
        this.monitorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MonitorPanelPanel.this.monitorButtonToggled();
            }
        });
        this.graphButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (MonitorPanelPanel.this.monitorable != null) {
                    if (MonitorPanelPanel.this.graphButton.isSelected()) {
                        MonitorPanelPanel.this.monitorable.createGraphFrom(MonitorPanelPanel.this.monitorTextArea);
                    } else {
                        MonitorPanelPanel.this.logger.debug("destroying graph");
                        MonitorPanelPanel.this.monitorable.destroyGraph();
                    }
                }
            }
        });
        this.monitorTextArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                if (MonitorPanelPanel.this.monitorable != null) {
                    MonitorPanelPanel.this.graphButton.setEnabled(MonitorPanelPanel.this.monitorable.isGraphCreatable(MonitorPanelPanel.this.monitorTextArea));
                } else {
                    MonitorPanelPanel.this.graphButton.setEnabled(false);
                }
            }
        });
        this.fileSelector.setSelectedIndex(0);
        return p;
    }

    private void fileSelected() {
        this.monitorButton.setSelected(false);
        this.setGraphButtonSelected(false);
        this.graphButton.setEnabled(false);
        if (this.monitorable != null) {
            this.monitorable.stopMonitor();
            this.monitorable.destroyGraph();
        }
        this.monitorTextArea.setText("");
        ChaseFile selectedFile = this.chaseFile[this.fileSelector.getSelectedIndex()];
        Object obj = this.monitorCache.get(selectedFile.getIdentifier().getValue());
        if (obj == null) {
            String path = selectedFile.getMonitorPath();
            this.monitorable = (Monitorable)PluginLoader.instantiate(path, new Object[]{this.projectInfo});
            this.monitorable.setMonitorPanel(this);
            this.monitorCache.put(selectedFile.getIdentifier().getValue(), this.monitorable);
        } else {
            this.monitorable = (Monitorable)obj;
        }
    }

    private void stopAll() {
        Set keySet = this.monitorCache.keySet();
        if (keySet == null) {
            return;
        }
        Object[] foo = keySet.toArray();
        if (foo == null || foo.length == 0) {
            return;
        }
        for (int i = 0; i < foo.length; ++i) {
            Monitorable mon = (Monitorable)this.monitorCache.get(foo[i]);
            if (mon == null) continue;
            mon.stopMonitor();
        }
    }

    protected void finalize() throws Throwable {
        this.stopAll();
        if (this.session != null) {
            this.session.disconnect();
        }
    }
}

