/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface.inputinterfacetable;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import ciss.phase_viewer.jdom.XMLUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class InputInterfaceTableSpecManager
implements Serializable {
    private Logger logger = Logger.getLogger(InputInterfaceTableSpecManager.class.getName());
    private InputInterface parent;
    private InputInterfaceTableSpec[] tableSpecs;

    public InputInterfaceTableSpecManager(URL url, InputInterface parent) {
        this.parent = parent;
        this.tableSpecs = this.createTableSpecFrom(url);
    }

    public void setInputInterface(InputInterface parent) {
        this.parent = parent;
        this.logger.debug("parent: " + parent);
    }

    public InputInterface getInputInterface() {
        return this.parent;
    }

    public InputInterfaceTableSpec[] getTableSpecs() {
        return this.tableSpecs;
    }

    public InputInterfaceTableSpec getTableSpec(String ID) {
        if (this.tableSpecs == null) {
            return null;
        }
        for (int i = 0; i < this.tableSpecs.length; ++i) {
            if (!this.tableSpecs[i].getID().equalsIgnoreCase(ID)) continue;
            return this.tableSpecs[i];
        }
        return null;
    }

    public InputInterfaceTableSpec getTableSpec(String ID, int index) {
        if (this.tableSpecs == null) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < this.tableSpecs.length; ++i) {
            if (!this.tableSpecs[i].getID().equalsIgnoreCase(ID)) continue;
            if (count == index) {
                return this.tableSpecs[i];
            }
            ++count;
        }
        return null;
    }

    private InputInterfaceTableSpec[] createTableSpecFrom(URL url) {
        Document doc = XMLUtils.getDocumentFromURL(url);
        Element root = doc.getRootElement();
        List columns = root.getChildren();
        if (columns == null) {
            this.logger.error("invalid specification for table spec.");
            return null;
        }
        InputInterfaceTableSpec[] ret = new InputInterfaceTableSpec[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            ret[i] = this.createTableSpec((Element)columns.get(i));
        }
        return ret;
    }

    private InputInterfaceTableSpec createTableSpec(Element element) {
        InputInterfaceTableSpec spec = new InputInterfaceTableSpec(element, this);
        return spec;
    }
}

