/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.input;

import ciss.phase_viewer.input.InputChecker;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class PhaseInputChecker
implements InputChecker,
InputInterfaceEntryChangeListener {
    private Logger logger = Logger.getLogger(PhaseInputChecker.class.getName());
    protected InputInterface inputInterface;
    protected String fileNamesData;
    protected String candidate = "";
    protected String message = "";
    protected String LS = System.getProperty("line.separator");
    protected int state = 0;
    protected String projDir;

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
    }

    public void inputInterfaceInitialized() {
    }

    public void inputInterfaceInitializing() {
    }

    public int getCurrentState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    protected void fixPrimitiveEntry(String blockTag, String entryTag, String value, String unit) {
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock(blockTag);
        InputInterfacePrimitiveEntry prim = this.inputInterface.getPrimitiveEntry(entryTag);
        prim.setValue(value);
        prim.setUnit(unit);
        this.inputInterface.replaceEntry(prim, this);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFilePath(String ident) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.fileNamesData));
            String line = "";
            while ((line = reader.readLine()) != null) {
                String tmp;
                if ((line = line.trim()).startsWith("&") || line.startsWith("/") || !line.startsWith(ident)) continue;
                String[] ar = line.split("=");
                String path = ar[1].trim().replaceAll("'", "");
                File file = new File(path);
                if (file.isAbsolute()) {
                    String string = path;
                    return string;
                }
                String string = tmp = new File(this.inputInterface.getFileName()).getParent() + System.getProperty("file.separator") + path;
                return string;
            }
        }
        catch (Exception exc) {
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exc) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getAllFilePath(String ident) {
        BufferedReader reader = null;
        Vector<String> retvec = new Vector<String>();
        try {
            reader = new BufferedReader(new FileReader(this.fileNamesData));
            String line = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("&") || line.startsWith("/") || !line.startsWith(ident)) continue;
                String[] ar = line.split("=");
                String path = ar[1].trim().replaceAll("'", "");
                File file = new File(path);
                if (file.isAbsolute()) {
                    retvec.addElement(path);
                }
                String tmp = new File(this.inputInterface.getFileName()).getParent() + System.getProperty("file.separator") + path;
                retvec.addElement(tmp);
            }
        }
        catch (Exception exc) {
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exc) {}
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] ret = new String[retvec.size()];
        retvec.copyInto(ret);
        return ret;
    }

    public void setInput(Input input) {
        if (!(input instanceof InputInterface)) {
            this.logger.error("invalid input ...");
            return;
        }
        this.inputInterface = (InputInterface)input;
        this.projDir = new File(this.inputInterface.getFileName()).getParent();
        this.fileNamesData = this.projDir + System.getProperty("file.separator") + "file_names.data";
    }
}

