/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.input;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorCaller;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorPanel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public abstract class InputWizardScript
implements InputWizard,
ScriptEditorCaller {
    private Logger logger = Logger.getLogger(InputWizardScript.class.getName());
    private ScriptEditorPanel panel;
    protected String FS = System.getProperty("file.separator");
    protected String phaseJobControl = System.getProperty("user.home") + this.FS + ".phase-viewer" + this.FS + "scripts" + this.FS + "jobcontrol" + this.FS + "phase";
    protected String projDir;
    protected String chaseXML;
    protected Input input;
    protected InputWizardController parent;
    protected ProjectInfo projectInfo;

    public JPanel getGUI() {
        this.panel = new ScriptEditorPanel(this, false, false);
        return this.panel;
    }

    protected abstract String[] getScripts();

    protected abstract String getScriptDir();

    public String process() {
        String[] scrs = this.getScripts();
        for (int i = 0; i < scrs.length; ++i) {
            ScriptUtils.copyNecessaryFiles(this.projDir + System.getProperty("file.separator") + scrs[i], this.projDir);
        }
        this.panel.save();
        this.doChaseXML();
        return "done initialization of " + this.getScriptPath();
    }

    public String getName() {
        return "script input";
    }

    public String getDescription() {
        return "configure script input";
    }

    public void setInput(Input input) {
        this.input = input;
        this.projDir = new File(input.getFileName()).getParent();
        this.chaseXML = this.projDir + this.FS + "phase-viewer.xml";
        String[] scripts = this.getScripts();
        String scriptDir = this.getScriptDir();
        try {
            for (int i = 0; i < scripts.length; ++i) {
                ExternalProgramExecuter.copyBinary(scriptDir + this.FS + scripts[i], this.projDir + this.FS + scripts[i]);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setParent(InputWizardController parent) {
        this.parent = parent;
        this.projectInfo = parent.getProjectInfo();
    }

    public void setProperties(HashMap properties) {
    }

    protected void doChaseXML() {
        Element script;
        Document document = this.projectInfo.getProjectPropertyDocument();
        Element rootElement = document.getRootElement();
        Element jobcontrol = rootElement.getChild("jobcontrol");
        if (jobcontrol == null) {
            jobcontrol = new Element("jobcontrol");
            rootElement.addContent(jobcontrol);
        }
        if ((script = jobcontrol.getChild("script")) == null) {
            script = new Element("script");
            jobcontrol.addContent(script);
        }
        Element scrtype = new Element("script_type");
        scrtype.setText("bsh");
        Element exec = new Element("exec");
        script.addContent(scrtype);
        script.addContent(exec);
        String execpath = MyElement.encode(this.projDir + this.FS + "script_exec.bsh");
        exec.addContent(new Element("bsh").addContent(new Element("script_exec_script").setText(execpath)));
        String[] scripts = this.getScripts();
        for (int i = 0; i < scripts.length; ++i) {
            Element exec_script = new Element("exec_script").addContent(new Element("script_type").setText("bsh"));
            exec_script.addContent(new Element("script_path").setText(scripts[i]));
            exec.addContent(exec_script);
        }
        this.parent.getProjectInfo().saveProjectPropertyDocument();
    }

    public boolean hasFinished() {
        return true;
    }

    public boolean hasNext() {
        return true;
    }

    public boolean hasPrevious() {
        return true;
    }

    public HashMap getObjects() {
        return null;
    }
}

