/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.input;

import ciss.phase_viewer.input.InputChecker;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.pub.primitivegui.JMultiLineToolTip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class InputCheckerGUI
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(InputCheckerGUI.class.getName());
    private Properties props;
    private Input input;
    private InputCheckerGUIsub[] guis;

    public InputCheckerGUI(Properties props, Input input) {
        super("check inputfile : " + input.getFileName(), true, true, true, true, new Dimension(550, 400));
        this.props = props;
        this.input = input;
        this.init();
    }

    private void init() {
        Object foo;
        JPanel pp = new JPanel();
        pp.setLayout(new BorderLayout());
        Vector<Object> vec = new Vector<Object>();
        Set<Object> keySet = this.props.keySet();
        Object[] arg = new Object[]{this.input};
        Object[] keys = keySet.toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            foo = (InputChecker)PluginLoader.instantiate(this.props.getProperty(keys[i].toString()), null);
            foo.setInput(this.input);
            vec.addElement(foo);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        foo = new Vector();
        for (int i = 0; i < vec.size(); ++i) {
            InputChecker ic = (InputChecker)vec.get(i);
            InputCheckerGUIsub icg = new InputCheckerGUIsub(ic);
            p.add(icg);
            ((Vector)foo).add(icg);
        }
        this.guis = new InputCheckerGUIsub[((Vector)foo).size()];
        ((Vector)foo).copyInto(this.guis);
        JScrollPane pane = new JScrollPane(p);
        Dimension siz = this.getSize();
        pane.setPreferredSize(new Dimension((int)((double)siz.width * 0.8), (int)((double)siz.height * 0.8)));
        pp.add(pane);
        this.getContentPane().add((Component)pp, "North");
        JPanel btns = this.getBtns();
        this.getContentPane().add((Component)btns, "South");
    }

    private JPanel getBtns() {
        JPanel panel = new JPanel();
        JButton check = new JButton("check");
        JButton dismiss = new JButton("dismiss");
        panel.add(check);
        panel.add(dismiss);
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InputCheckerGUI.this.doCheck();
            }
        });
        dismiss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InputCheckerGUI.this.dispose();
            }
        });
        return panel;
    }

    private void doCheck() {
        this.updateGUI();
    }

    private void updateGUI() {
        for (int i = 0; i < this.guis.length; ++i) {
            InputCheckerGUIsub gui = this.guis[i];
            gui.update();
        }
    }

    class FixButton
    extends JButton {
        public FixButton(String text) {
            super(text);
        }

        public JToolTip createToolTip() {
            return new JMultiLineToolTip();
        }
    }

    class InputCheckerGUIsub
    extends JPanel {
        private InputChecker checker;
        private Dimension dim = new Dimension(150, 50);
        private JLabel stateLabel;
        private JTextArea messageTextArea;
        private JButton fixButton;

        InputCheckerGUIsub(InputChecker checker) {
            this.checker = checker;
            this.init();
        }

        InputChecker getAssociatedInputChecker() {
            return this.checker;
        }

        private void init() {
            GridBagConstraints gc = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            this.setBorder(new TitledBorder(this.checker.getName()));
            JPanel statePanel = this.getStatePanel();
            JPanel descriptPanel = this.getDescriptionPanel();
            JPanel msgPanel = this.getMessagePanel();
            JPanel fixbtnPanel = this.getFixBtn();
            gc.gridwidth = 1;
            gc.gridheight = 1;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.fill = 1;
            this.add((Component)statePanel, gc);
            gc.gridheight = 2;
            gc.gridwidth = 2;
            this.add((Component)descriptPanel, gc);
            gc.gridwidth = 2;
            gc.gridheight = 2;
            this.add((Component)msgPanel, gc);
            gc.gridheight = 1;
            gc.gridwidth = 1;
            this.add((Component)fixbtnPanel, gc);
        }

        private JPanel getStatePanel() {
            JPanel p = new JPanel();
            p.setBorder(new TitledBorder("state"));
            this.stateLabel = new JLabel("UNCHECKED");
            this.stateLabel.setFont(new Font("Monospaced", 0, 12));
            p.add(this.stateLabel);
            return p;
        }

        private JPanel getDescriptionPanel() {
            JPanel descript = new JPanel();
            descript.setBorder(new TitledBorder("description"));
            JTextArea area = new JTextArea();
            area.setEditable(false);
            area.setText(this.checker.getDescription());
            area.setCaretPosition(0);
            JScrollPane pane = new JScrollPane();
            pane.setPreferredSize(this.dim);
            pane.getViewport().setView(area);
            descript.add(pane);
            return descript;
        }

        private JPanel getMessagePanel() {
            JPanel ret = new JPanel();
            ret.setBorder(new TitledBorder("message"));
            this.messageTextArea = new JTextArea();
            this.messageTextArea.setEditable(false);
            JScrollPane pane = new JScrollPane();
            pane.setPreferredSize(this.dim);
            pane.getViewport().setView(this.messageTextArea);
            ret.add(pane);
            return ret;
        }

        private JPanel getFixBtn() {
            JPanel ret = new JPanel();
            this.fixButton = new FixButton("fix it");
            this.fixButton.setEnabled(false);
            ret.add(this.fixButton);
            this.fixButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    InputCheckerGUIsub.this.checker.fixInput();
                    InputCheckerGUIsub.this.update();
                }
            });
            return ret;
        }

        void update() {
            try {
                int state = this.checker.doCheck();
                this.messageTextArea.setText(this.checker.getMessage());
                this.messageTextArea.setCaretPosition(0);
                if (state == 0) {
                    this.stateLabel.setText("    OK   ");
                    this.stateLabel.setForeground(Color.BLUE);
                } else if (state == -2) {
                    this.stateLabel.setText("  ERROR  ");
                    this.stateLabel.setForeground(Color.RED);
                } else if (state == -1) {
                    this.stateLabel.setText(" WARNING ");
                    this.stateLabel.setForeground(Color.GREEN);
                }
                boolean fix = (state == -2 || state == -1) && this.checker.isFixable();
                this.fixButton.setEnabled(fix);
                if (fix) {
                    this.fixButton.setToolTipText(this.checker.getCandidate());
                } else {
                    this.fixButton.setToolTipText("");
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

