/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.plotattributes;

import ciss.phase_viewer.graph.plotattributes.PlotShapesAndLines;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.apache.log4j.Logger;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class SeriesInfo {
    private Logger logger = Logger.getLogger(SeriesInfo.class.getName());
    public static int LINE = 0;
    public static int SHAPE = 1;
    public static int LINE_AND_SHAPE = 2;
    private XYPlot xyplot;
    private Color color;
    private int plottype = 0;
    private int linetype = 0;
    private int shapetype = 0;
    private int index;
    private float linewidth = -1.0f;
    private double shapesize = -1.0;

    public SeriesInfo(XYPlot xyplot, int index) {
        this.xyplot = xyplot;
        this.index = index;
        this.init();
    }

    public SeriesInfo(SeriesInfo info) {
        this.copy(info);
    }

    private void init() {
        XYItemRenderer renderer = this.xyplot.getRenderer();
        this.color = (Color)renderer.getSeriesPaint(this.index);
        Stroke stroke = renderer.getBaseStroke();
        if (stroke instanceof BasicStroke) {
            this.linewidth = ((BasicStroke)stroke).getLineWidth();
        }
        this.shapesize = renderer.getBaseShape().getBounds().width;
    }

    public void setPlotType(int plottype) {
        this.plottype = plottype;
    }

    public void setLineType(int linetype) {
        this.linetype = linetype;
    }

    public void setShapeType(int shapetype) {
        this.shapetype = shapetype;
    }

    public void setLineWidth(float linewidth) {
        this.linewidth = linewidth;
    }

    public void setShapeSize(double shapesize) {
        this.shapesize = shapesize;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public int getPlotType() {
        return this.plottype;
    }

    public int getLineType() {
        return this.linetype;
    }

    public int getShapeType() {
        return this.shapetype;
    }

    public float getLineWidth() {
        return this.linewidth;
    }

    public double getShapeSize() {
        return this.shapesize;
    }

    public String toString() {
        return "index: " + this.index + " color: " + this.color + " plottype: " + this.plottype + " linetype: " + this.linetype + " shapetype: " + this.shapetype + " linewidth: " + this.linewidth + " shapesize: " + this.shapesize;
    }

    public void copy(SeriesInfo info) {
        this.color = info.getColor();
        this.linetype = info.getLineType();
        this.linewidth = info.getLineWidth();
        this.plottype = info.getPlotType();
        this.shapesize = info.getShapeSize();
        this.shapetype = info.getShapeType();
    }

    public boolean update(int rendererIndex) {
        return this.update(this.xyplot, rendererIndex, this.index);
    }

    public boolean update(XYPlot xyPlot) {
        return this.update(xyPlot, 0, 0);
    }

    public boolean update(XYPlot xyPlot, int rendererIndex) {
        return this.update(xyPlot, rendererIndex, this.index);
    }

    public boolean update(XYPlot xyPlot, int rendererIndex, int seriesIndex) {
        StandardXYItemRenderer srenderer = null;
        if (!(this.xyplot.getRenderer(rendererIndex) instanceof StandardXYItemRenderer)) {
            this.logger.error("invalid renderer.");
            return false;
        }
        this.logger.debug("rendererIndex: " + rendererIndex);
        srenderer = (StandardXYItemRenderer)this.xyplot.getRenderer(rendererIndex);
        this.logger.debug(this);
        float linewidth = this.getLineWidth();
        double shapesize = this.getShapeSize();
        srenderer.setDrawSeriesLineAsPath(true);
        if (this.getPlotType() == LINE) {
            shapesize = 0.0;
            srenderer.setBaseShapesVisible(false);
            srenderer.setPlotLines(true);
        } else if (this.getPlotType() == SHAPE) {
            linewidth = -1.0f;
            srenderer.setBaseShapesVisible(true);
            srenderer.setPlotLines(false);
        } else if (this.getPlotType() == LINE_AND_SHAPE) {
            srenderer.setBaseShapesVisible(true);
            srenderer.setPlotLines(true);
        }
        this.logger.debug("line width, shape size: " + linewidth + ", " + shapesize);
        PlotShapesAndLines psal = new PlotShapesAndLines();
        srenderer.setShapesFilled(true);
        srenderer.setSeriesPaint(seriesIndex, this.getColor());
        srenderer.setSeriesShape(seriesIndex, psal.getShape(this.getShapeType(), shapesize));
        srenderer.setSeriesStroke(seriesIndex, psal.getLine(this.getLineType(), linewidth));
        this.xyplot.setRenderer(rendererIndex, srenderer);
        return true;
    }
}

