/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.plotattributes;

import java.awt.BasicStroke;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class PlotShapesAndLines {
    private int shapetype;
    private int linetype;
    private double shapesize;
    private float width;

    public Shape getShape(int shapetype, double shapesize) {
        this.shapetype = shapetype;
        this.shapesize = shapesize;
        return this.createShape(0.0, 0.0);
    }

    public Shape getShape(int shapetype, double x, double y, double shapesize) {
        this.shapetype = shapetype;
        this.shapesize = shapesize;
        return this.createShape(x, y);
    }

    public BasicStroke getLine(int linetype, float width) {
        this.linetype = linetype;
        this.width = width;
        if (width <= 0.0f) {
            this.linetype = -1;
            this.width = 0.0f;
        }
        return this.createLine();
    }

    private Shape createShape(double x, double y) {
        Shape shape;
        double size = this.shapesize;
        double delta = size / 2.0;
        int[] xpoints = null;
        int[] ypoints = null;
        if (this.shapetype == 0) {
            shape = new Rectangle2D.Double(x - delta, y - delta, size, size);
        } else if (this.shapetype == 1) {
            shape = new Ellipse2D.Double(x - delta, y - delta, size, size);
        } else if (this.shapetype == 2) {
            xpoints = this.intArray(x, x + delta, x - delta);
            ypoints = this.intArray(y - delta, y + delta, y + delta);
            shape = new Polygon(xpoints, ypoints, 3);
        } else if (this.shapetype == 3) {
            xpoints = PlotShapesAndLines.intArray(x, x + delta, x, x - delta);
            ypoints = PlotShapesAndLines.intArray(y - delta, y, y + delta, y);
            shape = new Polygon(xpoints, ypoints, 4);
        } else if (this.shapetype == 4) {
            shape = new Rectangle2D.Double(x - delta, y - delta / 2.0, size, size / 2.0);
        } else if (this.shapetype == 5) {
            xpoints = this.intArray(x - delta, x + delta, x);
            ypoints = this.intArray(y - delta, y - delta, y + delta);
            shape = new Polygon(xpoints, ypoints, 3);
        } else if (this.shapetype == 6) {
            shape = new Ellipse2D.Double(x - delta, y - delta / 2.0, size, size / 2.0);
        } else if (this.shapetype == 7) {
            xpoints = this.intArray(x - delta, x + delta, x - delta);
            ypoints = this.intArray(y - delta, y, y + delta);
            shape = new Polygon(xpoints, ypoints, 3);
        } else if (this.shapetype == 8) {
            shape = new Rectangle2D.Double(x - delta / 2.0, y - delta, size / 2.0, size);
        } else if (this.shapetype == 9) {
            xpoints = this.intArray(x - delta, x + delta, x + delta);
            ypoints = this.intArray(y, y - delta, y + delta);
            shape = new Polygon(xpoints, ypoints, 3);
        } else {
            shape = new Rectangle2D.Double(x - delta, y - delta, size, size);
        }
        return shape;
    }

    public int getNumLines() {
        return 10;
    }

    public int getNumShapes() {
        return 10;
    }

    private BasicStroke createLine() {
        float[] dash = this.linetype == 0 ? new float[]{10.0f, 0.0f} : (this.linetype == 1 ? new float[]{10.0f, 10.0f} : (this.linetype == 2 ? new float[]{5.0f, 5.0f} : (this.linetype == 3 ? new float[]{10.0f, 5.0f} : (this.linetype == 4 ? new float[]{5.0f, 10.0f} : (this.linetype == 5 ? new float[]{1.0f, 8.0f} : (this.linetype == 6 ? new float[]{1.0f, 3.0f, 2.0f} : (this.linetype == 7 ? new float[]{2.0f, 6.0f, 4.0f} : (this.linetype == 8 ? new float[]{1.0f, 3.0f, 4.0f, 5.0f} : (this.linetype == 9 ? new float[]{3.0f, 6.0f, 3.0f} : (this.linetype == -1 ? new float[]{0.0f, 10.0f} : new float[]{10.0f, 0.0f}))))))))));
        BasicStroke line = new BasicStroke(this.width, 1, 1, 1.0f, dash, 0.0f);
        return line;
    }

    private int[] intArray(double a, double b, double c) {
        return new int[]{(int)a, (int)b, (int)c};
    }

    private static int[] intArray(double a, double b, double c, double d) {
        return new int[]{(int)a, (int)b, (int)c, (int)d};
    }
}

