/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.dataset;

import ciss.phase_viewer.graph.dataset.DataSet;
import ciss.phase_viewer.graph.dataset.DataSetElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DataSetImporter {
    private Logger logger = Logger.getLogger(DataSetImporter.class.getName());
    private DataSet dset;
    private String fileName;
    private String HASH = "#";
    private Vector dataVector = new Vector();

    public DataSetImporter(String fileName) {
        this.fileName = fileName;
        this.dset = new DataSet(new File(fileName).getName());
        this.dset.setFileName(fileName);
        this.doImport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImport() {
        BufferedReader reader = null;
        try {
            int i;
            reader = new BufferedReader(new FileReader(this.fileName));
            String firstLine = reader.readLine().trim();
            String[] idents = null;
            if (firstLine.startsWith(this.HASH) && firstLine.length() > 1) {
                String hoge = firstLine.trim().substring(1, firstLine.length());
                String[] foo = firstLine.split(this.HASH);
                if (foo != null && foo.length != 0) {
                    idents = hoge.trim().split("\\s+");
                }
            }
            if (idents == null) {
                this.logger.debug("null identifier");
                reader = new BufferedReader(new FileReader(this.fileName));
            }
            String line = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                this.parseLine(line);
            }
            if (this.dataVector.size() == 0) {
                return;
            }
            if (idents == null) {
                int ncol = ((String[])this.dataVector.elementAt(0)).length;
                idents = new String[ncol];
                String elem = "element";
                for (int i2 = 0; i2 < ncol; ++i2) {
                    idents[i2] = elem + String.valueOf(i2);
                }
            }
            String[][] data = new String[idents.length][this.dataVector.size()];
            for (i = 0; i < this.dataVector.size(); ++i) {
                String[] row = (String[])this.dataVector.elementAt(i);
                int numcol = row.length;
                if (numcol > idents.length) {
                    numcol = idents.length;
                }
                for (int j = 0; j < numcol; ++j) {
                    data[j][i] = row[j];
                }
            }
            for (i = 0; i < idents.length; ++i) {
                DataSetElement dse = new DataSetElement(data[i], idents[i], this.dset);
                this.dset.addData(dse);
            }
            this.logger.info("finishied import of dataset from file: " + this.fileName);
        }
        catch (IOException ioe) {
            this.logger.error("encountered error during import of file: " + this.fileName);
            ioe.printStackTrace();
            this.dset = null;
            return;
        }
        catch (ArrayIndexOutOfBoundsException aoi) {
            this.dset = null;
            this.logger.error("inconsistent data");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void parseLine(String line) {
        String[] array = line.split("\\s+");
        if (array == null || array.length == 0) {
            array = line.split(",");
        }
        if (array == null || array.length == 0) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            try {
                Double.parseDouble(array[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                return;
            }
        }
        this.dataVector.addElement(array);
    }

    public DataSet getDataSet() {
        return this.dset;
    }
}

