/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.pmodel;

import ciss.phase_viewer.atomcoord.pmodel.Fraction;
import ciss.phase_viewer.atomcoord.pmodel.FractionVector;
import ciss.phase_viewer.atomcoord.pmodel.Generator;
import ciss.phase_viewer.atomcoord.pmodel.GeneratorList;
import ciss.phase_viewer.atomcoord.pmodel.PmodelException;
import ciss.phase_viewer.atomcoord.pmodel.PmodelRuntimeException;
import ciss.phase_viewer.atomcoord.pmodel.PointGroupOperation;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceGroup {
    static final boolean DEBUG = false;
    private static Fraction Zero = new Fraction(0, 1);
    private static Fraction Half = new Fraction(1, 2);
    private static FractionVector[] vecTrigo = new FractionVector[]{new FractionVector(new Fraction(2, 3), new Fraction(1, 3), new Fraction(1, 3)), new FractionVector(new Fraction(1, 3), new Fraction(2, 3), new Fraction(2, 3))};
    private static FractionVector[] vecFace = new FractionVector[]{new FractionVector(Zero, Half, Half), new FractionVector(Half, Zero, Half), new FractionVector(Half, Half, Zero)};
    private static FractionVector[] vecBody = new FractionVector[]{new FractionVector(Half, Half, Half)};
    private static FractionVector[] vecBaseC = new FractionVector[]{new FractionVector(Half, Half, Zero)};
    private static FractionVector[] vecBaseB = new FractionVector[]{new FractionVector(Half, Zero, Half)};
    private static FractionVector[] vecBaseA = new FractionVector[]{new FractionVector(Zero, Half, Half)};
    Generator generator;
    PointGroupOperation pointGroupOperation;
    FractionVector[][] transVec;
    private int[] isActive;
    private LatticeType latticeType;

    public static void main(String[] args) throws PmodelException {
        SpaceGroup sg = new SpaceGroup(227, 1);
        System.out.println(sg);
    }

    SpaceGroup(PointGroupOperation.PointGroup pg, ArrayList<String> symmetryEquivPos) throws PmodelException {
        this.initialize(pg);
        String[] gene = symmetryEquivPos.toArray(new String[0]);
        for (int i = 0; i < gene.length; ++i) {
            this.parseOperation(gene[i]);
        }
        if (this.isActive[0] == 0) {
            System.out.println("Warning : No identical operator exist in the '_symmetry_equiv_pos_as_xyz' loop.");
            this.parseOperation("x,y,z");
        }
        if (this.expand()) {
            System.out.println("Warning : Operations involved in the '_symmetry_equiv_pos_as_xyz' loop are not complete.");
        }
    }

    SpaceGroup(int spcGrpNum, int choice) throws PmodelException {
        this.generator = GeneratorList.getGenerator(spcGrpNum);
        PointGroupOperation.PointGroup pg = PointGroupOperation.getPointGroup(spcGrpNum);
        this.initialize(pg);
        int numOfChoice = this.generator.getNumOfChoice();
        if (choice > numOfChoice - 1) {
            System.out.println(choice + " " + numOfChoice);
            PmodelException ex = new PmodelException();
            ex.message = "Too large choice number.";
            throw ex;
        }
        this.setLatticeType(this.generator.getHM());
        this.generate(choice);
        this.addPrimitiveTranslation();
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.pointGroupOperation.getNg0(); ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.transVec[i][j] == null) continue;
                str = str + i + " " + this.isActive[i] + " " + this.transVec[i][j] + "\n";
            }
        }
        return str;
    }

    public static int getMaxChoice(int spcGrpNum) {
        Generator g = GeneratorList.getGenerator(spcGrpNum);
        return g.getNumOfChoice();
    }

    void setGenerator(int spcGrpNum) {
        this.generator = GeneratorList.getGenerator(spcGrpNum);
    }

    private void initialize(PointGroupOperation.PointGroup pg) {
        switch (pg) {
            case Oh: 
            case D6h: {
                this.pointGroupOperation = new PointGroupOperation(pg);
                break;
            }
            default: {
                PmodelRuntimeException ex = new PmodelRuntimeException();
                ex.message = "Illigal point group.";
                throw ex;
            }
        }
        int maxOpe = this.pointGroupOperation.getNg0();
        this.transVec = new FractionVector[maxOpe][4];
        this.isActive = new int[maxOpe];
        for (int i = 0; i < maxOpe; ++i) {
            this.isActive[i] = 0;
        }
    }

    private void generate(int choice) throws PmodelException {
        String[] gene = this.generator.getGenerator(choice);
        this.parseOperation("x,y,z");
        for (int i = 0; i < gene.length; ++i) {
            this.parseOperation(gene[i]);
        }
        this.expand();
    }

    private boolean expand() {
        boolean isExpanded = false;
        int maxOpe = this.pointGroupOperation.getNg0();
        boolean flag = true;
        while (flag) {
            flag = false;
            for (int i = 0; i < maxOpe; ++i) {
                for (int j = 0; j < maxOpe; ++j) {
                    int ixj;
                    if (this.isActive[i] == 0 || this.isActive[j] == 0 || this.isActive(ixj = this.pointGroupOperation.table[i][j])) continue;
                    flag = true;
                    isExpanded = true;
                    this.isActive[ixj] = 1;
                    this.transVec[ixj][0] = this.transVec[i][0].rotate(this.pointGroupOperation.opMat[j]).add(this.transVec[j][0]);
                }
            }
        }
        return isExpanded;
    }

    private void parseOperation(String str) throws PmodelException {
        int[][] opMat_ = new int[3][3];
        FractionVector transVec_ = new FractionVector();
        String[] regex = new String[]{"'(.*)'", "((-)?\\d/\\d)", "((\\+|-)?[xyzXYZ])"};
        Pattern p1 = Pattern.compile(regex[0]);
        Pattern p2 = Pattern.compile(regex[1]);
        Pattern p3 = Pattern.compile(regex[2]);
        Matcher m1 = p1.matcher(str);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                opMat_[i][j] = 0;
            }
        }
        String temp = "";
        temp = m1.find() ? m1.group(1) : str;
        StringTokenizer st = new StringTokenizer(temp, ",");
        block21: for (int j = 0; j < 3; ++j) {
            String strXYZ = st.nextToken();
            Matcher m2 = p2.matcher(strXYZ);
            if (m2.find()) {
                StringTokenizer st2 = new StringTokenizer(m2.group(1), "/");
                String strNume = st2.nextToken();
                String strDeno = st2.nextToken();
                int nume = Integer.parseInt(strNume);
                int deno = Integer.parseInt(strDeno);
                transVec_.element[j] = new Fraction(nume, deno);
            } else {
                transVec_.element[j] = new Fraction(0, 1);
            }
            Matcher m3 = p3.matcher(strXYZ);
            int flag = 0;
            int delta = 9999;
            while (m3.find()) {
                boolean isMinus = false;
                String rotStr = m3.group(1);
                switch (rotStr.charAt(0)) {
                    case '+': {
                        break;
                    }
                    case '-': {
                        isMinus = true;
                        break;
                    }
                }
                switch (rotStr.charAt(rotStr.length() - 1)) {
                    case 'X': 
                    case 'x': {
                        delta = 1;
                        break;
                    }
                    case 'Y': 
                    case 'y': {
                        delta = -2;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        delta = 4;
                        break;
                    }
                    default: {
                        PmodelException ex = new PmodelException();
                        ex.message = "ERROR : Invalid Operator(s).";
                        throw ex;
                    }
                }
                if (isMinus) {
                    flag -= delta;
                    continue;
                }
                flag += delta;
            }
            switch (flag) {
                case 1: {
                    opMat_[j][0] = 1;
                    continue block21;
                }
                case -1: {
                    opMat_[j][0] = -1;
                    continue block21;
                }
                case 2: {
                    opMat_[j][1] = -1;
                    continue block21;
                }
                case -2: {
                    opMat_[j][1] = 1;
                    continue block21;
                }
                case 3: {
                    opMat_[j][0] = 1;
                    opMat_[j][1] = -1;
                    continue block21;
                }
                case -3: {
                    opMat_[j][0] = -1;
                    opMat_[j][1] = 1;
                    continue block21;
                }
                case 4: {
                    opMat_[j][2] = 1;
                    continue block21;
                }
                case -4: {
                    opMat_[j][2] = -1;
                    continue block21;
                }
                default: {
                    PmodelException ex = new PmodelException();
                    throw ex;
                }
            }
        }
        int num = -1;
        block23: for (int k = 0; k < this.pointGroupOperation.getNg0(); ++k) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.pointGroupOperation.opMat[k][i][j] != opMat_[i][j]) continue block23;
                }
            }
            num = k;
            break;
        }
        if (num == -1) {
            PmodelException ex = new PmodelException();
            ex.message = "ERROR : Invalid Operator(s).";
            throw ex;
        }
        this.transVec[num][this.isActive[num]] = transVec_;
        int n = num;
        this.isActive[n] = this.isActive[n] + 1;
    }

    boolean isActive(int i) {
        return this.isActive[i] != 0;
    }

    private void addPrimitiveTranslation() throws PmodelException {
        block9: for (int j = 0; j < this.pointGroupOperation.getNg0(); ++j) {
            if (!this.isActive(j)) continue;
            switch (this.latticeType) {
                case TRIGONAL: {
                    int i;
                    for (i = 0; i < vecTrigo.length; ++i) {
                        this.transVec[j][i + 1] = this.transVec[j][0].add(vecTrigo[i]);
                        int n = j;
                        this.isActive[n] = this.isActive[n] + 1;
                    }
                    continue block9;
                }
                case PRIMITIVE: {
                    continue block9;
                }
                case FACE: {
                    int i;
                    for (i = 0; i < vecFace.length; ++i) {
                        this.transVec[j][i + 1] = this.transVec[j][0].add(vecFace[i]);
                        int n = j;
                        this.isActive[n] = this.isActive[n] + 1;
                    }
                    continue block9;
                }
                case BODY: {
                    this.transVec[j][1] = this.transVec[j][0].add(vecBody[0]);
                    int n = j;
                    this.isActive[n] = this.isActive[n] + 1;
                    continue block9;
                }
                case BASE_C: {
                    this.transVec[j][1] = this.transVec[j][0].add(vecBaseC[0]);
                    int n = j;
                    this.isActive[n] = this.isActive[n] + 1;
                    continue block9;
                }
                case BASE_B: {
                    this.transVec[j][1] = this.transVec[j][0].add(vecBaseB[0]);
                    int n = j;
                    this.isActive[n] = this.isActive[n] + 1;
                    continue block9;
                }
                case BASE_A: {
                    this.transVec[j][1] = this.transVec[j][0].add(vecBaseC[0]);
                    int n = j;
                    this.isActive[n] = this.isActive[n] + 1;
                    continue block9;
                }
                default: {
                    PmodelException ex = new PmodelException();
                    ex.message = "Error: Illegal lattice type.";
                    throw ex;
                }
            }
        }
    }

    private void setLatticeType(String HM) throws PmodelException {
        switch (this.pointGroupOperation.pointGroup) {
            case D6h: {
                switch (HM.charAt(0)) {
                    case 'P': {
                        this.latticeType = LatticeType.PRIMITIVE;
                        return;
                    }
                    case 'R': {
                        this.latticeType = LatticeType.TRIGONAL;
                        return;
                    }
                }
                PmodelException ex = new PmodelException();
                ex.message = "The first character of H-M symbol is " + HM.charAt(0);
                throw ex;
            }
            case Oh: {
                switch (HM.charAt(0)) {
                    case 'P': {
                        this.latticeType = LatticeType.PRIMITIVE;
                        return;
                    }
                    case 'F': {
                        this.latticeType = LatticeType.FACE;
                        return;
                    }
                    case 'I': {
                        this.latticeType = LatticeType.BODY;
                        return;
                    }
                    case 'C': {
                        this.latticeType = LatticeType.BASE_C;
                        return;
                    }
                    case 'B': {
                        this.latticeType = LatticeType.BASE_B;
                        return;
                    }
                    case 'A': {
                        this.latticeType = LatticeType.BASE_A;
                        return;
                    }
                }
                PmodelException ex = new PmodelException();
                ex.message = "Error.";
                throw ex;
            }
        }
        PmodelRuntimeException ex = new PmodelRuntimeException();
        throw ex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LatticeType {
        TRIGONAL,
        PRIMITIVE,
        FACE,
        BODY,
        BASE_C,
        BASE_B,
        BASE_A;

    }
}

