/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.atomcoord.io.CubeFileFilter;
import ciss.phase_viewer.atomcoord.io.Exporter;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.Utils;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CubeExporter
implements Exporter {
    private Logger logger = Logger.getLogger(CubeExporter.class.getName());
    private double ang2bohr = ConstParameters.ANG_2_BOHR;

    public boolean writeAtomCoordsTo(AtomCoords[] coords, String fileName) {
        int i;
        int i2;
        AtomCoords coord = coords[0];
        coord.convert(6, 9);
        PrintWriter writer = Utils.getPrintWriter(fileName);
        writer.println("Gaussian cube file created by the PHASE-Viewer");
        writer.println("volumetric data");
        writer.println(String.valueOf(coord.getNumAt()) + " 0.0 0.0 0.0");
        VolumetricData vdata = coord.getChargeDensity();
        vdata.stripPBC();
        int[] ndiv = vdata.getNumDiv();
        float[][] delta = vdata.getDelta();
        float[] density = vdata.getDensity();
        ElementInfo info = new ElementInfo();
        try {
            for (i2 = 0; i2 < 3; ++i2) {
                writer.println(ndiv[i2] + " " + (double)delta[i2][0] * this.ang2bohr + " " + (double)delta[i2][1] * this.ang2bohr + " " + (double)delta[i2][2] * this.ang2bohr);
            }
        }
        catch (ArrayIndexOutOfBoundsException aobe) {
            this.logger.error("invalid ndiv and/or delta.");
            return false;
        }
        for (i2 = 0; i2 < coord.getNumAt(); ++i2) {
            Atom atom = coord.getAtomList().getAtomAt(i2);
            if (atom.getDouble() == null || atom.getDouble().length < 3) {
                this.logger.error("invalid atom pos ");
                return false;
            }
            writer.println(info.getNumberFromSymbol(atom.getElementName()) + " " + atom.getNumValenceElectrons() + " " + atom.getDouble()[0] + " " + atom.getDouble()[1] + " " + atom.getDouble()[2]);
        }
        int numRow = density.length / 6;
        for (i = 0; i < numRow; ++i) {
            for (int j = 0; j < 6; ++j) {
                writer.print(" " + density[i * 6 + j]);
            }
            writer.print(System.getProperty("line.separator"));
        }
        for (i = numRow * 6; i < density.length; ++i) {
            writer.print(" " + density[i]);
        }
        writer.print(System.getProperty("line.separator"));
        writer.flush();
        writer.close();
        vdata.doPBC(density, ndiv);
        return true;
    }

    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    public FileFilter getFileFilter() {
        return new CubeFileFilter();
    }

    public String getType() {
        return "Gaussian Cube";
    }

    public boolean hasOptions() {
        return false;
    }

    public void setOptions(HashMap options) {
    }
}

