/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import Jama.Matrix;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.AtomStateList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.common.VectorOperations;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceDefaults;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class AtomCoords
implements Cloneable,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger(AtomCoords.class.getName());
    public static final int DEFAULT = 0;
    public static final int BOHR = 1;
    public static final int ANGSTROM = 2;
    public static final int NM = 3;
    public static final int BOHR2ANG = 4;
    public static final int ANG2BOHR = 5;
    public static final int TO_CART = 6;
    public static final int TO_INTERNAL = 7;
    public static final int TO_ANG = 8;
    public static final int TO_BOHR = 9;
    public static final int TO_NM = 10;
    private final double bohr_2_ang = 0.529177;
    private final double ang_2_bohr = 1.8897268777743552;
    private AtomList atomList = new AtomList(this);
    private Cell[] cell = new Cell[2];
    private boolean iscart = true;
    private int unit;
    private DecimalFormat formater = ConstParameters.formater;
    private TableModel modelAt;
    private TableModel[] modelCe;
    private static String elems = "element";
    private static String rx = "rx";
    private static String ry = "ry";
    private static String rz = "rz";
    private VolumetricData chargeDensity;
    private Vector chargeDensities;
    private AtomStateList atomState;
    private Vector primChargeDensities;
    private double eps = 1.0E-5;
    private BravaisLattice blat;

    public AtomCoords() {
    }

    public void nullify() {
        if (this.atomList != null) {
            this.atomList.nullify();
        }
        if (this.cell != null) {
            this.cell = null;
        }
        if (this.atomState != null) {
            this.atomState = null;
        }
    }

    public void saveState() {
        this.atomState = new AtomStateList(this.getNumAt());
        this.atomList.setState(this.atomState);
    }

    public AtomStateList getAtomState() {
        return this.atomState;
    }

    public void finalizeState() {
        this.atomState = null;
    }

    public AtomCoords(Atom[] atom) {
        for (int i = 0; i < atom.length; ++i) {
            this.atomList.addAtom(atom[i]);
        }
    }

    public AtomCoords(Atom[] atom, Cell[] cell) {
        for (int i = 0; i < atom.length; ++i) {
            this.atomList.addAtom(atom[i]);
        }
        this.cell = cell;
    }

    public void setBasicIdentifiers(String elems, String rx, String ry, String rz) {
        AtomCoords.elems = elems;
        AtomCoords.rx = rx;
        AtomCoords.ry = ry;
        AtomCoords.rz = rz;
    }

    public AtomList getAtomList() {
        return this.atomList;
    }

    public void atomCoords2InputInterface_cell(int from_cell) {
        if (from_cell == 1) {
            this.convertCell(0);
        } else if (from_cell == 0) {
            this.convertCell(1);
        }
    }

    private void atomCoords2InputInterface(InputInterface inputInterface, InputInterfaceTableColumns[] columns, String tag, Atom atom, int rowIndex) {
        String elem = atom.getElementName().trim();
        String[] pos = atom.getPos();
        TaggedString[] aux = atom.getAuxil();
        int numaux = 0;
        if (aux != null) {
            numaux = aux.length;
        }
        String[] str = new String[columns.length];
        String[] idents = new String[columns.length];
        for (int j = 0; j < columns.length; ++j) {
            idents[j] = columns[j].getName();
            str[j] = "";
            if (columns[j].ignoreOnSave()) continue;
            if (columns[j].getName().equalsIgnoreCase(elems)) {
                str[j] = elem;
            } else if (columns[j].getName().equalsIgnoreCase(rx)) {
                str[j] = pos[0];
            } else if (columns[j].getName().equalsIgnoreCase(ry)) {
                str[j] = pos[1];
            } else if (columns[j].getName().equalsIgnoreCase(rz)) {
                str[j] = pos[2];
            } else {
                for (int k = 0; k < numaux; ++k) {
                    if (!aux[k].getTag().trim().equalsIgnoreCase(columns[j].getName().trim())) continue;
                    str[j] = aux[k].getValue();
                }
            }
            logger.debug("processing column: " + columns[j].getName() + " whose value is: " + str[j]);
        }
        InputInterfaceDefaults defs = inputInterface.getDefaults();
        if (defs != null) {
            HashMap map = defs.getDefaultValues();
            Object[] keys = map.keySet().toArray();
            for (int j = 0; j < columns.length; ++j) {
                if (str[j].length() != 0) continue;
                for (int i = 0; i < keys.length; ++i) {
                    if (!columns[j].getName().equalsIgnoreCase(keys[i].toString())) continue;
                    str[j] = map.get(keys[i]).toString();
                }
            }
        }
        InputInterfaceTable itable = inputInterface.getInputInterfaceTable(tag);
        itable.setWillChangeRow(rowIndex, InputInterfaceTable.REPLACE);
        itable.saveState();
        itable.replaceTableDataRow(idents, str, rowIndex);
    }

    public void atomCoords2InputInterface(InputInterface inputInterface, String tag) {
        this.atomCoords2InputInterface_InitTable(inputInterface, tag, this.atomList, 0);
    }

    public void atomCoords2InputInterface_InitTable(InputInterface inputInterface, String tag, AtomList list, int offset) {
        inputInterface.selectRoot();
        InputInterfaceTableColumns[] columns = inputInterface.getInputInterfaceTableSpecManager().getTableSpec(tag).getTableColumns();
        InputInterfaceTable itable = inputInterface.getInputInterfaceTable(tag);
        logger.debug("init table: from 0 to " + itable.getTableData().size());
        itable.removeAll();
        for (int i = 0; i < list.size(); ++i) {
            Atom atom = list.getAtomAt(i);
            this.atomCoords2InputInterface(inputInterface, columns, tag, atom, i + offset);
        }
        inputInterface.replaceEntry(itable, this);
        if (this.blat != null) {
            this.blat.saveToInputInterface(inputInterface);
        }
        inputInterface.selectRoot();
    }

    public void setBravaisLattice(BravaisLattice blat) {
        this.blat = blat;
    }

    public void atomCoords2InputInterface(InputInterface inputInterface, String tag, AtomList list, int offset) {
        inputInterface.selectRoot();
        InputInterfaceTableColumns[] columns = inputInterface.getInputInterfaceTableSpecManager().getTableSpec(tag).getTableColumns();
        InputInterfaceTable itable = inputInterface.getInputInterfaceTable(tag);
        for (int i = 0; i < list.size(); ++i) {
            Atom atom = list.getAtomAt(i);
            this.atomCoords2InputInterface(inputInterface, columns, tag, atom, i + offset);
        }
        inputInterface.replaceEntry(itable, this);
        inputInterface.selectRoot();
    }

    public void cell2InputInterface(InputInterface inputInterface) {
        Cell cell = this.getCell(0);
        if (cell == null) {
            cell = this.getCell(1);
        }
        if (cell == null) {
            return;
        }
        String[][] cel = cell.getCell();
        if (cel.length == 3) {
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.a_vector").setValue(cel[0][0] + " " + cel[0][1] + " " + cel[0][2]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.b_vector").setValue(cel[1][0] + " " + cel[1][1] + " " + cel[1][2]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.c_vector").setValue(cel[2][0] + " " + cel[2][1] + " " + cel[2][2]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.a").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.b").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.c").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.alpha").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.beta").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.gamma").setValue("");
        } else {
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.a_vector").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.b_vector").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.c_vector").setValue("");
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.a").setValue(cel[0][0]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.b").setValue(cel[0][1]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.c").setValue(cel[0][2]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.alpha").setValue(cel[1][0]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.beta").setValue(cel[1][1]);
            inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.gamma").setValue(cel[1][2]);
        }
    }

    public void inputInterface2AtomCoords(InputInterface inputInterface, String tag) {
        inputInterface.selectRoot();
        InputInterfaceTableColumns[] columns = inputInterface.getInputInterfaceTableSpecManager().getTableSpec(tag).getTableColumns();
        InputInterfaceTable itable = inputInterface.getInputInterfaceTable(tag);
        String[] idents = itable.getColumnIdentifiers();
        inputInterface.selectRoot();
        Vector atoms = itable.getTableData();
        if (atoms.size() > this.atomList.size()) {
            // empty if block
        }
        int nat = atoms.size();
        this.atomList.clear();
        for (int i = 0; i < nat; ++i) {
            String[] atomData = (String[])atoms.elementAt(i);
            String elementName = "";
            String[] pos = new String[3];
            Vector<TaggedString> auvec = new Vector<TaggedString>();
            for (int j = 0; j < idents.length; ++j) {
                String dat = atomData[j];
                logger.debug("processing atom no. " + i + ", ident: " + idents[j] + " value: " + dat);
                if (idents[j].trim().equalsIgnoreCase(elems)) {
                    elementName = dat = Utils.firstLetterCaps(dat);
                    continue;
                }
                if (idents[j].trim().equalsIgnoreCase(rx)) {
                    pos[0] = dat;
                    continue;
                }
                if (idents[j].trim().equalsIgnoreCase(ry)) {
                    pos[1] = dat;
                    continue;
                }
                if (idents[j].trim().equalsIgnoreCase(rz)) {
                    pos[2] = dat;
                    continue;
                }
                auvec.addElement(new TaggedString(idents[j].trim(), dat));
            }
            this.atomList.addAtom(elementName, pos, auvec);
        }
        logger.debug("at inputInterface2AtomCoords: ");
        logger.debug(this.atomList);
    }

    public void correctCellOffset() {
        try {
            int i;
            Cell ce = this.getCell(0);
            double[] off = ce.getCellOffset();
            boolean shifted = false;
            for (i = 0; i < off.length; ++i) {
                if (off[i] == 0.0) continue;
                shifted = true;
            }
            if (!shifted) {
                return;
            }
            for (i = 0; i < this.atomList.size(); ++i) {
                Atom at = this.atomList.getAtomAt(i);
                double[] pos = at.getDouble();
                for (int j = 0; j < pos.length; ++j) {
                    int n = j;
                    pos[n] = pos[n] + off[j];
                }
                at.setPos(pos);
            }
        }
        catch (Exception exc) {
            logger.error("invalid cell");
        }
    }

    public Atom inputInterface2Atom(InputInterface inputInterface, String tag, int index) {
        InputInterfaceTableColumns[] columns = inputInterface.getInputInterfaceTableSpecManager().getTableSpec(tag).getTableColumns();
        InputInterfaceTable itable = inputInterface.getInputInterfaceTable(tag);
        String[] idents = itable.getColumnIdentifiers();
        Vector atoms = itable.getTableData();
        if (atoms.size() <= index) {
            index = atoms.size() - 1;
        }
        if (index < 0) {
            index = 0;
        }
        String[] atomData = (String[])atoms.elementAt(index);
        return AtomCoords.createAtomFrom(idents, atomData);
    }

    public static Atom createAtomFrom(String[] id, String[] data) {
        String elementName = "";
        String[] pos = new String[3];
        Vector<TaggedString> auvec = new Vector<TaggedString>();
        for (int i = 0; i < id.length; ++i) {
            String dat = data[i];
            if (id[i].trim().equalsIgnoreCase(elems)) {
                elementName = dat;
                continue;
            }
            if (id[i].trim().equalsIgnoreCase(rx)) {
                pos[0] = dat;
                continue;
            }
            if (id[i].trim().equalsIgnoreCase(ry)) {
                pos[1] = dat;
                continue;
            }
            if (id[i].trim().equalsIgnoreCase(rz)) {
                pos[2] = dat;
                continue;
            }
            auvec.addElement(new TaggedString(id[i].trim(), dat));
        }
        return new Atom(elementName, pos, auvec);
    }

    public static String getValueFrom(Atom atom, String id) {
        String val = "";
        if (id.equalsIgnoreCase(elems)) {
            val = atom.getElementName();
        } else if (id.equalsIgnoreCase(rx)) {
            val = atom.getPos()[0];
        } else if (id.equalsIgnoreCase(ry)) {
            val = atom.getPos()[1];
        } else if (id.equalsIgnoreCase(rz)) {
            val = atom.getPos()[2];
        } else {
            TaggedString[] au = atom.getAuxil();
            if (au != null && au.length != 0) {
                for (int k = 0; k < au.length; ++k) {
                    if (!au[k].getTag().trim().equalsIgnoreCase(id)) continue;
                    val = au[k].getValue();
                    break;
                }
            }
        }
        return val;
    }

    public void inputInterfaceInitializing() {
        this.atomList.clear();
    }

    public void inputInterfaceInitialized() {
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
    }

    public void setChargeDensity(VolumetricData chargeDensity) {
        this.chargeDensity = chargeDensity;
        if (this.chargeDensities == null) {
            this.chargeDensities = new Vector();
        }
        this.chargeDensities.add(chargeDensity);
    }

    public void setChargeDensity(float[] density, int[] ndiv, float[][] delta, float[] origin) {
        this.chargeDensity = new VolumetricData(density, ndiv, delta, origin);
        if (this.chargeDensities == null) {
            this.chargeDensities = new Vector();
        }
        this.chargeDensities.add(this.chargeDensity);
    }

    public void addChargeDensity(float[] density, int[] ndiv, float[][] delta, float[] origin) {
        VolumetricData vdata = new VolumetricData(density, ndiv, delta, origin);
        this.addChargeDensity(vdata);
    }

    public void addChargeDensity(VolumetricData vdata) {
        if (this.chargeDensities == null) {
            this.chargeDensities = new Vector();
        }
        this.chargeDensities.add(vdata);
    }

    public void setChargeDensities(VolumetricData[] vdata) {
        if (vdata == null || vdata.length == 0) {
            return;
        }
        if (this.chargeDensities == null) {
            this.chargeDensities = new Vector();
        }
        this.chargeDensities.clear();
        for (int i = 0; i < vdata.length; ++i) {
            this.chargeDensities.add(vdata[i]);
        }
    }

    public void setChargeDensitiesPrimitiveCell(VolumetricData[] vdata) {
        if (vdata == null || vdata.length == 0) {
            return;
        }
        if (this.primChargeDensities == null) {
            this.primChargeDensities = new Vector();
        }
        this.primChargeDensities.clear();
        for (int i = 0; i < vdata.length; ++i) {
            this.primChargeDensities.add(vdata[i]);
        }
    }

    public VolumetricData[] getChargeDensitiesPrimitiveCell() {
        if (this.primChargeDensities == null) {
            return null;
        }
        Object[] vdata = new VolumetricData[this.primChargeDensities.size()];
        this.primChargeDensities.copyInto(vdata);
        return vdata;
    }

    public VolumetricData[] getChargeDensities() {
        if (this.chargeDensities == null) {
            return null;
        }
        Object[] vdata = new VolumetricData[this.chargeDensities.size()];
        this.chargeDensities.copyInto(vdata);
        return vdata;
    }

    public VolumetricData getChargeDensity() {
        return this.chargeDensity;
    }

    public boolean checkDupli(Atom atom) {
        boolean ret = false;
        for (int i = 0; i < this.atomList.size(); ++i) {
            Atom check = this.atomList.getAtomAt(i);
            double[] dcheck = check.getDouble();
            double[] datom = atom.getDouble();
            double[] dArray = new double[]{dcheck[0] - datom[0], dcheck[1] - datom[1], dcheck[2] - datom[2]};
            double[] diff = dArray;
            if (!(VectorOperations.norm(diff) < this.eps)) continue;
            ret = true;
        }
        return ret;
    }

    public void removeDuplicateAtoms() {
        Vector<Integer> dupli = new Vector<Integer>();
        for (int i = this.atomList.size() - 1; i >= 1; --i) {
            for (int j = i - 1; j >= 0; --j) {
                if (j >= this.atomList.size()) continue;
                Atom atomi = this.atomList.getAtomAt(i);
                Atom atomj = this.atomList.getAtomAt(j);
                double[] posi = atomi.getDouble();
                double[] posj = atomj.getDouble();
                double[] dArray = new double[]{posi[0] - posj[0], posi[1] - posj[1], posi[2] - posj[2]};
                double[] posdiff = dArray;
                double norm = VectorOperations.norm(posdiff);
                if (!(norm < this.eps)) continue;
                dupli.addElement(new Integer(i));
            }
        }
        if (dupli.size() == 0) {
            return;
        }
        Object[] idupli = new Integer[dupli.size()];
        dupli.copyInto(idupli);
        Arrays.sort(idupli);
        for (int i = idupli.length - 1; i >= 0; --i) {
            this.atomList.removeAtomAt(i);
        }
    }

    public void removeDupliCell() {
        if (!this.isCellValid(0)) {
            return;
        }
        Cell cell = this.getCell(0);
        double[][] dcell = cell.getDouble();
        Vector dupli = new Vector();
        for (int i = this.atomList.size() - 1; i >= 0; --i) {
            Atom atom = this.atomList.getAtomAt(i);
            double[] dpos = atom.getDouble();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    for (int c = -1; c <= 1; ++c) {
                        if (a == 0 && b == 0 && c == 0) continue;
                        double[] tmppos = new double[3];
                        for (int j = 0; j < 3; ++j) {
                            tmppos[j] = dpos[j] + dcell[0][j] * (double)a + dcell[1][j] * (double)b + dcell[2][j] * (double)c;
                        }
                        if (!this.checkDupli(new Atom(atom.getElementName(), tmppos, atom.getAuxil()))) continue;
                        logger.info("removed duplicate atom, No. " + i);
                        this.atomList.removeAtom(atom);
                    }
                }
            }
        }
    }

    public void removeBoundaryAtoms() {
        for (int i = this.atomList.size() - 1; i >= 0; --i) {
            Atom at = this.atomList.getAtomAt(i);
            if (!at.isBoundaryAtom()) continue;
            this.atomList.removeAtomAt(i);
        }
    }

    public void removeSubLatticeAtoms() {
        for (int i = this.atomList.size() - 1; i >= 0; --i) {
            Atom at = this.atomList.getAtomAt(i);
            if (!at.isSubLatticeAtom()) continue;
            this.atomList.removeAtomAt(i);
        }
    }

    public void removeVirtualAtoms() {
        for (int i = this.atomList.size() - 1; i >= 0; --i) {
            Atom a = this.atomList.getAtomAt(i);
            if (!a.isVirtualAtom()) continue;
            this.atomList.removeAtomAt(i);
        }
    }

    public void removeIgnoreOnSaveAtoms() {
        for (int i = this.atomList.size() - 1; i >= 0; --i) {
            Atom a = this.atomList.getAtomAt(i);
            if (a.isSubLatticeAtom() && a.saveSubLatticeAtom()) continue;
            if (a.isVirtualAtom()) {
                this.atomList.removeAtomAt(i);
                continue;
            }
            if (!a.isInvSymAtom()) continue;
            this.atomList.removeAtomAt(i);
        }
    }

    public AtomCoords getCopy() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("clone failed");
            return null;
        }
        return (AtomCoords)o;
    }

    public Cell[] getCell() {
        return this.cell;
    }

    public void setCell(Cell[] cell) {
        this.cell = cell;
    }

    public void setCell(Cell cell_, boolean updateStack) {
        int cellscheme = cell_.getCellScheme();
        if (updateStack) {
            this.atomList.getUndoRedoObject().addEntry(this.getCell(cellscheme));
        }
        if (cellscheme == 0 || cellscheme == 1) {
            this.cell[cellscheme] = cell_;
        } else {
            logger.warn("invalid cell scheme");
        }
        boolean b0 = this.isCellValid(0);
        boolean b1 = this.isCellValid(1);
        if (b1 && !b0) {
            if (!this.convertCell(0)) {
                logger.warn("failed conversion of cell");
            }
        } else if (!b1 && b0 && !this.convertCell(1)) {
            logger.warn("failed conversion of cell");
        }
    }

    public void setCell(Cell cell_) {
        this.setCell(cell_, true);
    }

    public Cell getCell(int i) {
        Cell cell = null;
        if (i == 0 || i == 1) {
            cell = this.cell[i];
        }
        return cell;
    }

    public double[][] getCellDouble(int i) {
        Cell cell = this.cell[i];
        String[][] cellString = cell.getCell();
        int irow = 2;
        if (i == 0) {
            irow = 3;
        }
        double[][] cellDouble = new double[irow][3];
        try {
            for (int ir = 0; ir < irow; ++ir) {
                for (int j = 0; j < 3; ++j) {
                    cellDouble[ir][j] = Double.valueOf(cellString[ir][j]);
                }
            }
        }
        catch (NumberFormatException nfe) {
            cellDouble = null;
        }
        catch (NullPointerException npe) {
            cellDouble = null;
        }
        return cellDouble;
    }

    public int getNumAt() {
        return this.atomList.size();
    }

    public String[] getDistinctElements() {
        return this.distinctElements();
    }

    public void isCart(boolean iscart) {
        this.iscart = iscart;
    }

    public void setUnit(int unit) {
        this.unit = unit;
        logger.debug("set unit: " + unit);
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean isCart() {
        return this.iscart;
    }

    public boolean isInternal() {
        return !this.iscart;
    }

    public boolean isCellValid(int cellscheme) {
        if (cellscheme < 0 || cellscheme > 1) {
            return false;
        }
        return this.checkCell(cellscheme);
    }

    private double[][] toCart(double[][] pos) {
        Cell validCell = null;
        int NumAt = pos.length;
        double[][] Dpos = new double[NumAt][3];
        if (this.isCellValid(0)) {
            validCell = this.cell[0];
        } else if (this.isCellValid(1)) {
            if (!this.convertCell(0)) {
                logger.warn("failed conversion of cell");
                return null;
            }
            validCell = this.cell[0];
        } else {
            logger.warn("you must specify a valid cell for 'internal' coord scheme");
            return null;
        }
        String[][] cellString = validCell.getCell();
        try {
            for (int i = 0; i < NumAt; ++i) {
                int j;
                double[] vec = new double[3];
                for (j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        int n = k;
                        vec[n] = vec[n] + pos[i][j] * Double.parseDouble(cellString[j][k]);
                    }
                }
                for (j = 0; j < 3; ++j) {
                    Dpos[i][j] = vec[j];
                }
            }
        }
        catch (NumberFormatException ne) {
            logger.warn("couldn't convet to 'cart'");
            return null;
        }
        return Dpos;
    }

    private double[][] toCart() {
        Cell validCell = null;
        int NumAt = this.getNumAt();
        double[][] Dpos = new double[NumAt][3];
        if (this.isCellValid(0)) {
            validCell = this.cell[0];
        } else if (this.isCellValid(1)) {
            if (!this.convertCell(0)) {
                logger.warn("failed conversion of cell");
                return null;
            }
            validCell = this.cell[0];
        } else {
            logger.warn("you must specify a valid cell");
            return null;
        }
        String[][] cellString = validCell.getCell();
        try {
            for (int i = 0; i < this.atomList.size(); ++i) {
                int j;
                Atom atom = this.atomList.getAtomAt(i);
                String[] p = atom.getPos();
                double[] vec = new double[3];
                for (j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        int n = k;
                        vec[n] = vec[n] + Double.parseDouble(p[j]) * Double.parseDouble(cellString[j][k]);
                    }
                }
                for (j = 0; j < 3; ++j) {
                    Dpos[i][j] = vec[j];
                }
            }
        }
        catch (NumberFormatException ne) {
            logger.warn("couldn't convet to 'cart'");
            return null;
        }
        return Dpos;
    }

    private double[][] toInternal(double[][] pos) {
        double[][] ret = null;
        if (!this.isCellValid(0) && !this.abcToVec()) {
            logger.warn("failed to get cell info ...");
            return ret;
        }
        double[][] ce = this.cell[0].getDouble();
        double[][] cet = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                cet[i][j] = ce[j][i];
            }
        }
        double tmp = 0.0;
        int numat = pos.length;
        ret = new double[numat][3];
        for (int i = 0; i < numat; ++i) {
            double[] Dpos = pos[i];
            double[][] bvec = new double[3][1];
            for (int i1 = 0; i1 < 3; ++i1) {
                bvec[i1][0] = Dpos[i1];
            }
            Matrix A = new Matrix(cet);
            Matrix b = new Matrix(bvec);
            Matrix x = A.solve(b);
            for (int i1 = 0; i1 < 3; ++i1) {
                ret[i][i1] = x.get(i1, 0);
                logger.debug("retret,i,i1: " + i + " " + i1 + " " + ret[i][i1]);
            }
        }
        return ret;
    }

    private double[][] toInternal() {
        double[][] ret = null;
        if (!this.isCellValid(0) && !this.abcToVec()) {
            logger.warn("failed to get cell info ...");
            return ret;
        }
        double[][] ce = this.cell[0].getDouble();
        double[][] cet = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                cet[i][j] = ce[j][i];
            }
        }
        int numat = this.atomList.size();
        double tmp = 0.0;
        ret = new double[numat][3];
        for (int i = 0; i < numat; ++i) {
            Atom atom = this.atomList.getAtomAt(i);
            double[] Dpos = atom.getDouble();
            double[][] bvec = new double[3][1];
            for (int i1 = 0; i1 < 3; ++i1) {
                bvec[i1][0] = Dpos[i1];
            }
            Matrix A = new Matrix(cet);
            Matrix b = new Matrix(bvec);
            Matrix x = A.solve(b);
            for (int i1 = 0; i1 < 3; ++i1) {
                ret[i][i1] = x.get(i1, 0);
            }
        }
        return ret;
    }

    private double[][] toDouble() {
        int NumAt = this.getNumAt();
        double[][] Dpos = new double[NumAt][3];
        String[][] pos = new String[NumAt][3];
        for (int i = 0; i < NumAt; ++i) {
            Atom atom = this.atomList.getAtomAt(i);
            String[] p = atom.getPos();
            for (int j = 0; j < 3; ++j) {
                try {
                    Dpos[i][j] = Double.parseDouble(p[j]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    logger.warn("non-numeric coordinates found for atom " + i + ", " + j + "-th coordinate");
                    return null;
                }
            }
        }
        return Dpos;
    }

    public double[][] getPosDouble() {
        double[][] ret = null;
        ret = !this.iscart ? this.toCart() : this.toDouble();
        return ret;
    }

    public double[][] getForceDouble() {
        double[][] ret = new double[this.getNumAt()][3];
        for (int i = 0; i < this.getNumAt(); ++i) {
            String[] tmp = this.atomList.getAtomAt(i).getForce();
            try {
                for (int j = 0; j < 3; ++j) {
                    ret[i][j] = Double.parseDouble(tmp[j]);
                }
                continue;
            }
            catch (Exception ex) {
                return ret;
            }
        }
        return ret;
    }

    public void setPosDouble(double[][] pos) {
        this.setPosDouble(pos, this.iscart);
    }

    private double convertLength(double value, int from_length) {
        double ret = value;
        double scale = 1.0;
        if (from_length == 8 && this.unit != 2) {
            if (this.unit == 1 || this.unit == 0) {
                scale = 1.8897268777743552;
            } else if (this.unit == 3) {
                scale = 0.1;
            }
        } else if (from_length == 9 && (this.unit != 1 || this.unit != 0)) {
            if (this.unit == 2) {
                scale = 0.529177;
            } else if (this.unit == 3) {
                scale = 0.052917700000000005;
            }
        } else if (from_length == 10 && this.unit != 3) {
            if (this.unit == 2) {
                scale = 10.0;
            } else if (this.unit == 1 || this.unit == 0) {
                scale = 5.29177;
            }
        } else {
            return ret;
        }
        return ret *= scale;
    }

    public void replaceAtomAt(int index, Atom atom) {
        if (index >= this.atomList.size() || index < 0) {
            this.atomList.addAtom(atom);
            return;
        }
        this.atomList.replaceAtomAt(index, atom);
    }

    public void setPosDouble(double[][] pos, boolean cart) {
        if (pos == null) {
            logger.error("'pos' is null... ");
            return;
        }
        double[][] tmp = this.getTransformedPos(pos, cart);
        int n = tmp.length;
        int numAt = this.atomList.size();
        if (numAt < n) {
            logger.warn("numAt < pos.length; using numAt.");
            n = numAt;
        }
        for (int i = 0; i < n; ++i) {
            Atom at = this.atomList.getAtomAt(i);
            at.setPos(tmp[i]);
            this.atomList.replaceAtomAt(i, at);
        }
    }

    private double[][] getTransformedPos(double[][] pos, boolean cart) {
        double[][] tpos = new double[pos.length][3];
        double[][] tmp = new double[pos.length][3];
        tpos = pos;
        if (this.unit != 2 && cart) {
            for (int i = 0; i < pos.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    tpos[i][j] = this.convertLength(pos[i][j], 8);
                }
            }
        }
        tmp = cart ? (this.iscart ? tpos : this.toInternal(tpos)) : (!this.iscart ? tpos : this.toCart(tpos));
        return tmp;
    }

    public String[] getElements() {
        int NumAt = this.getNumAt();
        String[] elements = new String[NumAt];
        for (int i = 0; i < NumAt; ++i) {
            Atom atom = this.atomList.getAtomAt(i);
            elements[i] = atom.getElementName();
        }
        return elements;
    }

    public TaggedString[][] getAuxils() {
        TaggedString[] ts;
        int NumAt = this.getNumAt();
        Vector<TaggedString[]> auxvec = new Vector<TaggedString[]>();
        int numauxs = 0;
        for (int i = 0; i < NumAt; ++i) {
            Atom atom = this.atomList.getAtomAt(i);
            ts = atom.getAuxil();
            if (ts == null || ts.length == 0) continue;
            if (numauxs < ts.length) {
                numauxs = ts.length;
            }
            auxvec.addElement(ts);
        }
        if (numauxs == 0) {
            logger.debug("auxiliary info not available");
            return null;
        }
        TaggedString[][] auxils = new TaggedString[NumAt][numauxs];
        for (int i = 0; i < auxvec.size(); ++i) {
            ts = (TaggedString[])auxvec.get(i);
            for (int j = 0; j < ts.length; ++j) {
                auxils[i][j] = ts[j];
            }
        }
        return auxils;
    }

    public void convert(int to_coordsys, int to_length) {
        this.convertCoordSys(to_coordsys);
        this.convertLength(to_length);
        logger.debug(this.atomList);
        if (to_length == 9) {
            this.unit = 1;
        }
        if (to_length == 8) {
            this.unit = 2;
        }
        if (to_coordsys == 7) {
            this.iscart = false;
        }
        if (to_coordsys == 6) {
            this.iscart = true;
        }
    }

    private void convertCoordSys(int to_coordsys) {
        double[][] tmp = null;
        if (to_coordsys == 6 && !this.isCart()) {
            tmp = this.toCart();
            this.iscart = true;
        } else if (to_coordsys == 7 && this.isCart()) {
            tmp = this.toInternal();
            this.iscart = false;
        } else {
            return;
        }
        if (tmp == null) {
            return;
        }
        int numat = tmp.length;
        if (numat == this.atomList.size()) {
            for (int i = 0; i < numat; ++i) {
                this.atomList.getAtomAt(i).setPos(tmp[i]);
            }
        } else {
            logger.warn("number of atoms & atom list inconsistent!");
        }
        this.vecToABC();
    }

    private void convertLength(int to_length) {
        double[][] dcell2;
        int i;
        double[][] scell;
        double[][] dcell;
        int numat = this.atomList.size();
        if (numat == 0) {
            return;
        }
        double scale = 1.0;
        if (to_length == 8 && this.unit != 2) {
            if (this.unit == 1 || this.unit == 0) {
                scale = 0.529177;
            } else if (this.unit == 3) {
                scale = 10.0;
            }
            this.unit = 2;
        } else if (to_length == 9 && (this.unit != 1 || this.unit != 0)) {
            if (this.unit == 2) {
                scale = 1.8897268777743552;
            } else if (this.unit == 3) {
                scale = 18.89726877774355;
            }
            this.unit = 1;
        } else if (to_length == 10 && this.unit != 3) {
            if (this.unit == 2) {
                scale = 0.1;
            } else if (this.unit == 1 || this.unit == 0) {
                scale = 0.052917700000000005;
            }
            this.unit = 3;
        } else {
            return;
        }
        if (this.cell[0] != null && (dcell = this.cell[0].getDouble()) != null) {
            scell = new double[3][3];
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    scell[i][j] = dcell[i][j] * scale;
                }
            }
            this.cell[0] = new Cell(scell[0], scell[1], scell[2]);
        }
        if (this.cell[1] != null && (dcell2 = this.cell[1].getDouble()) != null) {
            scell = new double[2][3];
            for (i = 0; i < 3; ++i) {
                scell[0][i] = dcell2[0][i] * scale;
                scell[1][i] = dcell2[1][i];
            }
            this.cell[1] = new Cell(scell[0][0], scell[0][1], scell[0][2], scell[1][0], scell[1][1], scell[1][2]);
        }
        if (this.isCart()) {
            for (int i2 = 0; i2 < this.atomList.size(); ++i2) {
                Atom atom = this.atomList.getAtomAt(i2);
                String[] pos = atom.getPos();
                double[] tmp = new double[3];
                try {
                    for (int j = 0; j < 3; ++j) {
                        tmp[j] = Double.parseDouble(pos[j]) * scale;
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.warn("failed conversion of units for atom no. " + i2);
                    return;
                }
                atom.setPos(tmp);
            }
        }
    }

    public void setModels(TableModel modelAt, TableModel[] modelCe) {
        this.modelAt = modelAt;
        this.modelCe = modelCe;
    }

    public void createCellFromTableModel(TableModel modelCell) {
        if (modelCell == null) {
            logger.warn("invalid atom table.");
            return;
        }
        boolean cellsc = false;
        TableModel model1 = modelCell;
        if (model1.getRowCount() == 1) {
            cellsc = true;
        }
        if (!cellsc) {
            String[] avec = new String[]{(String)model1.getValueAt(0, 1), (String)model1.getValueAt(0, 2), (String)model1.getValueAt(0, 3)};
            String[] bvec = new String[]{(String)model1.getValueAt(1, 1), (String)model1.getValueAt(1, 2), (String)model1.getValueAt(1, 3)};
            String[] cvec = new String[]{(String)model1.getValueAt(2, 1), (String)model1.getValueAt(2, 2), (String)model1.getValueAt(2, 3)};
            this.cell[0] = new Cell(avec, bvec, cvec);
        } else {
            this.cell[1] = new Cell((String)model1.getValueAt(0, 1), (String)model1.getValueAt(0, 2), (String)model1.getValueAt(0, 3), (String)model1.getValueAt(0, 4), (String)model1.getValueAt(0, 5), (String)model1.getValueAt(0, 6));
        }
        this.setCell(this.cell);
        if (this.isCellValid(1) && !this.isCellValid(0)) {
            if (!this.convertCell(0)) {
                logger.warn("failed conversion of cell");
            }
        } else if (!this.isCellValid(1) && this.isCellValid(0) && !this.convertCell(1)) {
            logger.warn("failed conversion of cell");
        }
    }

    public void createCellFromTableModel(TableModel[] modelCell) {
        if (modelCell == null) {
            logger.warn("invalid atom table.");
            return;
        }
        if (modelCell.length != 2 || modelCell[0] == null || modelCell[1] == null) {
            logger.warn("invalid cell table.");
            return;
        }
        TableModel model1 = modelCell[0];
        TableModel model2 = modelCell[1];
        String[] avec = new String[]{(String)model1.getValueAt(0, 1), (String)model1.getValueAt(0, 2), (String)model1.getValueAt(0, 3)};
        String[] bvec = new String[]{(String)model1.getValueAt(1, 1), (String)model1.getValueAt(1, 2), (String)model1.getValueAt(1, 3)};
        String[] cvec = new String[]{(String)model1.getValueAt(2, 1), (String)model1.getValueAt(2, 2), (String)model1.getValueAt(2, 3)};
        Cell[] cell = new Cell[]{new Cell(avec, bvec, cvec), new Cell((String)model2.getValueAt(0, 1), (String)model2.getValueAt(0, 2), (String)model2.getValueAt(0, 3), (String)model2.getValueAt(0, 4), (String)model2.getValueAt(0, 5), (String)model2.getValueAt(0, 6))};
        this.setCell(cell);
        if (this.isCellValid(1) && !this.isCellValid(0)) {
            if (!this.convertCell(0)) {
                logger.warn("failed conversion of cell");
            }
        } else if (!this.isCellValid(1) && this.isCellValid(0) && !this.convertCell(1)) {
            logger.warn("failed conversion of cell");
        }
    }

    public void updateTable() {
        this.updateTable(this.modelAt, this.modelCe);
    }

    public String getUnitString(int u) {
        if (u == 1) {
            return "bohr";
        }
        if (u == 2) {
            return "angstrom";
        }
        if (u == 3) {
            return "nm";
        }
        return "bohr";
    }

    public int getUnitInt(String u) {
        if (u == null || u.length() == 0 || u.equalsIgnoreCase("bohr")) {
            return 1;
        }
        if (u.equalsIgnoreCase("angstrom")) {
            return 2;
        }
        if (u.equalsIgnoreCase("nm")) {
            return 3;
        }
        return 1;
    }

    public Element getXMLElement(int numFrame) {
        Element element = new Element("frame");
        element.setAttribute(new Attribute("framenum", String.valueOf(numFrame)));
        element.setAttribute(new Attribute("iscart", String.valueOf(this.iscart)));
        String strunit = this.getUnitString(this.unit);
        element.setAttribute(new Attribute("lengthunit", strunit));
        Element elemList = this.atomList.getXMLElement();
        element.addContent(elemList);
        if (this.cell[0] != null) {
            element.addContent(this.cell[0].getXMLElement());
        }
        if (this.cell[1] != null) {
            element.addContent(this.cell[1].getXMLElement());
        }
        return element;
    }

    private void updateTableCell() {
        String form;
        int j;
        int i;
        if (this.modelCe == null) {
            return;
        }
        if (this.modelCe.length != 2 || this.modelCe[0] == null || this.modelCe[1] == null) {
            return;
        }
        String[][] cell1 = this.getCell()[0].getCell();
        String[][] cell2 = this.getCell()[1].getCell();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                form = "";
                try {
                    form = this.formater.format(Double.parseDouble(cell1[i][j]));
                }
                catch (Exception ex) {
                    form = cell1[i][j];
                }
                this.modelCe[0].setValueAt(form, i, j + 1);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 3; ++j) {
                form = "";
                try {
                    form = this.formater.format(Double.parseDouble(cell2[i][j]));
                }
                catch (Exception ex) {
                    form = cell2[i][j];
                }
                this.modelCe[1].setValueAt(form, 0, 1 + j + i * 3);
            }
        }
    }

    public void updateTable(TableModel model, TableModel[] modelCell) {
        if (model != null) {
            int i;
            int row = model.getRowCount();
            int column = model.getColumnCount();
            Utils.clearTableModel(model);
            String[] columnName = new String[column];
            for (i = 0; i < column; ++i) {
                columnName[i] = model.getColumnName(i);
            }
            if (column < 4) {
                logger.warn("not a valid table model.");
                return;
            }
            if (row < this.atomList.size()) {
                logger.warn("not enough table size...");
                return;
            }
            logger.debug("updating table... atomList: " + this.atomList);
            for (i = 0; i < this.atomList.size(); ++i) {
                model.setValueAt(new Integer(i + 1), i, 0);
            }
            for (i = 0; i < this.atomList.size(); ++i) {
                logger.debug("setting info for atom " + i);
                Atom atom = this.atomList.getAtomAt(i);
                String name = atom.getElementName();
                String[] pos = atom.getPos();
                logger.debug("setting element name ..." + name);
                model.setValueAt(name, i, 1);
                logger.debug("pos for atom " + i + " is " + pos[0] + " " + pos[1] + " " + pos[2]);
                for (int j = 0; j < 3; ++j) {
                    model.setValueAt(pos[j], i, j + 2);
                }
                TaggedString[] auxil = atom.getAuxil();
                if (auxil == null) continue;
                for (int j = 0; j < auxil.length; ++j) {
                    String ident = auxil[j].getTag();
                    int ia = -1;
                    for (int k = 0; k < column; ++k) {
                        if (!ident.trim().equalsIgnoreCase(columnName[k].trim())) continue;
                        ia = k;
                        break;
                    }
                    if (ia == -1) continue;
                    model.setValueAt(auxil[j].getValue(), i, ia);
                }
            }
        }
        if (modelCell != null) {
            for (int i = 0; i < 2; ++i) {
                if (this.cell[i] == null) continue;
                String[][] cellData = this.cell[i].getCell();
                int roww = 0;
                if (i == 0) {
                    roww = 3;
                } else if (i == 1) {
                    roww = 2;
                }
                int getaCol = 1;
                if (i == 1) {
                    int icount = 0;
                    for (int j = 0; j < 2; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            String ce = new String();
                            ce = j == 0 ? cellData[0][k] : cellData[1][k];
                            if (ce != null) {
                                try {
                                    modelCell[i].setValueAt(this.formater.format(Double.parseDouble(ce)), 0, icount + getaCol);
                                }
                                catch (NumberFormatException nfe) {
                                    logger.debug("invalid cell");
                                    continue;
                                }
                            }
                            ++icount;
                        }
                    }
                    continue;
                }
                if (i != 0) continue;
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        String ce = cellData[j][k];
                        if (ce == null) continue;
                        try {
                            modelCell[i].setValueAt(this.formater.format(Double.parseDouble(ce)), j, k + getaCol);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            logger.debug("invalid cell");
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return this.atomList.toString();
    }

    public void debug() {
        int i;
        for (i = 0; i < this.atomList.size(); ++i) {
            Atom atom = this.atomList.getAtomAt(i);
            String[] pos = atom.getPos();
            logger.debug("atom no. " + i + ": ");
            logger.debug("element name: " + atom.getElementName() + " x: " + pos[0] + " y: " + pos[1] + " z: " + pos[2]);
            TaggedString[] auxil = atom.getAuxil();
            if (auxil == null) continue;
            for (int j = 0; j < auxil.length; ++j) {
                logger.debug("auxil info no " + j + ", ident: " + auxil[j].getTag() + ", value: " + auxil[j].getValue());
            }
        }
        for (i = 0; i < 2; ++i) {
            Cell cell = this.cell[i];
            if (cell != null) {
                String[][] cc;
                int cs = cell.getCellScheme();
                if (cs == 0) {
                    cc = cell.getCell();
                    if (cc == null) continue;
                    logger.debug("cell scheme is CELL_VEC");
                    logger.debug("a-vec: " + cc[0][0] + " " + cc[0][1] + " " + cc[0][2]);
                    logger.debug("b-vec: " + cc[1][0] + " " + cc[1][1] + " " + cc[1][2]);
                    logger.debug("c-vec: " + cc[2][0] + " " + cc[2][1] + " " + cc[2][2]);
                    continue;
                }
                if (cs != 1 || (cc = cell.getCell()) == null) continue;
                logger.debug("cell scheme is CELL_ABC");
                logger.debug("a: " + cc[0][0]);
                logger.debug("b: " + cc[0][1]);
                logger.debug("c: " + cc[0][2]);
                logger.debug("alpha: " + cc[1][0]);
                logger.debug("beta: " + cc[1][1]);
                logger.debug("gamma: " + cc[1][2]);
                continue;
            }
            logger.debug("cell scheme no. " + i + " has not been defined yet.");
        }
    }

    public boolean convertCell(int conv) {
        boolean ret = true;
        if (conv == 0) {
            ret = this.abcToVec();
        } else if (conv == 1) {
            ret = this.vecToABC();
        }
        this.updateTableCell();
        return ret;
    }

    public void createBravaisLattice(InputInterface inputInterface, boolean primitive) {
        logger.debug("creating blat");
        if (this.cell == null && this.cell[0] == null && this.cell[1] == null) {
            logger.debug("cell is null.");
            return;
        }
        if (!primitive) {
            if (this.cell[1] == null) {
                this.convertCell(1);
            }
            Cell cellabc = this.getCell(1);
            double[][] dcell = cellabc.getDouble();
            this.blat = BravaisLattice.getBravaisLattice(dcell[0][0], dcell[0][1], dcell[0][2], dcell[1][0], dcell[1][1], dcell[1][2], BravaisLattice.getLatticeSystemFrom(inputInterface));
            logger.debug("created blat.");
        } else {
            Cell vec = this.getCell(0);
            double[][] celvec = vec.getDouble();
            this.blat = BravaisLattice.getBravaisLattice(celvec[0], celvec[1], celvec[2]);
            this.blat.isBravais(false);
        }
    }

    public double[][] getReciprocalLattice(InputInterface inputInterface) {
        if (this.cell == null && this.cell[0] == null && this.cell[1] == null) {
            return null;
        }
        double[][] rlat = null;
        this.createBravaisLattice(inputInterface, false);
        if (BravaisLattice.isBravais(inputInterface) && this.blat != null) {
            double[][] primlat = this.blat.getPrimitiveLatticeVector();
            Cell primcel = new Cell(primlat[0], primlat[1], primlat[2]);
            rlat = primcel.getReciprocalLattice();
        } else {
            Cell cell = this.cell[0];
            if (cell == null) {
                cell = this.cell[1];
            }
            rlat = cell.getReciprocalLattice();
        }
        return rlat;
    }

    public BravaisLattice getBravaisLattice() {
        return this.blat;
    }

    private double getAngstrom(double d) {
        if (this.unit == 2) {
            return d;
        }
        if (this.unit == 1 || this.unit == 0) {
            return d * 0.529177;
        }
        if (this.unit == 3) {
            return d * 10.0;
        }
        logger.warn("wrong specification of unit!");
        return d;
    }

    private double getBohr(double d) {
        if (this.unit == 2) {
            return d / 0.529177;
        }
        if (this.unit == 1 || this.unit == 0) {
            return d;
        }
        if (this.unit == 3) {
            return d / 0.529177 * 10.0;
        }
        logger.warn("wrong specification of unit!");
        return d;
    }

    private String[] distinctElements() {
        Vector<String> elemReposit = new Vector<String>();
        for (int i = 0; i < this.atomList.size(); ++i) {
            boolean found = false;
            Atom atom = this.atomList.getAtomAt(i);
            String elem = atom.getElementName();
            for (int j = 0; j < elemReposit.size(); ++j) {
                String compElem = (String)elemReposit.get(i);
                if (!elem.equalsIgnoreCase(compElem)) continue;
                found = true;
            }
            if (found) continue;
            elemReposit.addElement(elem);
        }
        String[] ret = new String[elemReposit.size()];
        for (int i = 0; i < elemReposit.size(); ++i) {
            ret[i] = (String)elemReposit.get(i);
        }
        return ret;
    }

    private boolean checkCell(int cellScheme) {
        if (this.cell == null || this.cell[cellScheme] == null || this.cell[cellScheme].getCell() == null) {
            return false;
        }
        String[][] cellString = this.cell[cellScheme].getCell();
        int numRows = cellScheme == 0 ? 3 : 2;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < 3; ++j) {
                try {
                    if (cellString[i][j] == null || cellString[i][j].trim().length() == 0) {
                        return false;
                    }
                    Double.parseDouble(cellString[i][j]);
                    continue;
                }
                catch (NumberFormatException ne) {
                    logger.warn("not a valid cell.");
                    return false;
                }
                catch (NullPointerException nle) {
                    nle.printStackTrace();
                    logger.warn("cell not allocated");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean abcToVec() {
        String[][] cellData;
        double[] cellLength = new double[3];
        double[] cellAng = new double[3];
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        try {
            cellData = this.cell[1].getCell();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.warn("cell not allocated");
            return false;
        }
        try {
            for (int i = 0; i < 3; ++i) {
                cellLength[i] = Double.parseDouble(cellData[0][i]);
            }
            alpha = Double.parseDouble(cellData[1][0]) * (Math.PI / 180);
            beta = Double.parseDouble(cellData[1][1]) * (Math.PI / 180);
            gamma = Double.parseDouble(cellData[1][2]) * (Math.PI / 180);
        }
        catch (Exception ex) {
            return false;
        }
        double[][] cellVec = new double[3][3];
        double temp = 0.0;
        try {
            int j;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    cellVec[i][j] = 0.0;
                }
            }
            cellVec[0][0] = 1.0;
            cellVec[1][0] = Math.cos(gamma);
            cellVec[2][0] = Math.cos(beta);
            cellVec[1][1] = Math.sin(gamma);
            cellVec[2][1] = temp = (Math.cos(alpha) - Math.cos(beta) * Math.cos(gamma)) / Math.sin(gamma);
            cellVec[2][2] = Math.sqrt(Math.sin(beta) * Math.sin(beta) - temp * temp);
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    double[] dArray = cellVec[j];
                    int n = i;
                    dArray[n] = dArray[n] * cellLength[j];
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        String[] avec = new String[3];
        String[] bvec = new String[3];
        String[] cvec = new String[3];
        try {
            for (int i = 0; i < 3; ++i) {
                avec[i] = Double.toString(cellVec[0][i]);
                bvec[i] = Double.toString(cellVec[1][i]);
                cvec[i] = Double.toString(cellVec[2][i]);
            }
        }
        catch (Exception ex) {
            return false;
        }
        this.cell[0] = new Cell(avec, bvec, cvec);
        return true;
    }

    private boolean vecToABC() {
        String[][] cellData;
        boolean ret = true;
        try {
            cellData = this.cell[0].getCell();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.warn("cell not allocated");
            return false;
        }
        String[] avec_out = cellData[0];
        String[] bvec_out = cellData[1];
        String[] cvec_out = cellData[2];
        double[] avec_double = new double[3];
        double[] bvec_double = new double[3];
        double[] cvec_double = new double[3];
        logger.debug("a_vec: " + avec_out[0] + " " + avec_out[1] + " " + avec_out[2]);
        logger.debug("b_vec: " + bvec_out[0] + " " + bvec_out[1] + " " + bvec_out[2]);
        logger.debug("c_vec: " + cvec_out[0] + " " + cvec_out[1] + " " + cvec_out[2]);
        try {
            for (int i = 0; i < 3; ++i) {
                avec_double[i] = Double.parseDouble(avec_out[i]);
                bvec_double[i] = Double.parseDouble(bvec_out[i]);
                cvec_double[i] = Double.parseDouble(cvec_out[i]);
            }
        }
        catch (Exception ex) {
            return false;
        }
        double ar = 0.0;
        double br = 0.0;
        double cr = 0.0;
        for (int i = 0; i < 3; ++i) {
            ar += Math.pow(avec_double[i], 2.0);
            br += Math.pow(bvec_double[i], 2.0);
            cr += Math.pow(cvec_double[i], 2.0);
        }
        ar = Math.sqrt(ar);
        br = Math.sqrt(br);
        cr = Math.sqrt(cr);
        double cda = 0.0;
        double cdb = 0.0;
        double adb = 0.0;
        for (int i = 0; i < 3; ++i) {
            cda += cvec_double[i] * avec_double[i];
            cdb += cvec_double[i] * bvec_double[i];
            adb += avec_double[i] * bvec_double[i];
        }
        double cosbeta = 0.0;
        double cosalph = 0.0;
        double cosgamm = 0.0;
        double beta = 0.0;
        double alph = 0.0;
        double gamm = 0.0;
        try {
            cosbeta = cda / (cr * ar);
            cosalph = cdb / (cr * br);
            cosgamm = adb / (ar * br);
            beta = Math.acos(cosbeta) * 57.29577951308232;
            alph = Math.acos(cosalph) * 57.29577951308232;
            gamm = Math.acos(cosgamm) * 57.29577951308232;
        }
        catch (Exception e) {
            return false;
        }
        try {
            String astr = Double.toString(ar);
            String bstr = Double.toString(br);
            String cstr = Double.toString(cr);
            String alstr = Double.toString(alph);
            String bestr = Double.toString(beta);
            String gastr = Double.toString(gamm);
            this.cell[1] = new Cell(astr, bstr, cstr, alstr, bestr, gastr);
            logger.debug("finished conversion. values of a,b,c,alpha,beta and gamma:");
            logger.debug(astr + " " + bstr + " " + cstr + " " + alstr + " " + bestr + " " + gastr);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

