/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.measure.MeasureBranchGroup;
import ciss.phase_viewer.acviewer.measure.MeasureListener;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseRotate;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseTranslate;
import ciss.phase_viewer.acviewer.operations.BasicOperations;
import ciss.phase_viewer.acviewer.scenegraphelements.CellObject;
import ciss.phase_viewer.acviewer.scenegraphelements.DynamicallyEditable;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementBG;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObjectBG;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomPicker;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomSelectionCanvas;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondCalculator;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondInfo;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondObject;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomState;
import ciss.phase_viewer.atomcoord.AtomStateList;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.common.VectorOperations;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class TGAtom
extends ChaseTransformGroup
implements AtomSelectionCanvas,
Measurable,
ConfigData {
    private static Logger logger = Logger.getLogger(TGAtom.class.getName());
    private SceneGraphElementCreator creator;
    private MainPanel mp;
    private double lenmax;
    private double[] jusin;
    private Measure measure;
    private boolean measureAtWork = false;
    private Stack selectedAtoms = new Stack();
    private ConfigDataManager mCD;
    private J3DDataManager mACVD;
    private double[][] Dpos;
    private double[][] Dforce;
    private int NumAt;
    private double[][] cellvec;
    private BondCalculator clcbnd;
    private BondCalculator hbondCalculator;
    private boolean rescaleOnUpdate = true;
    private Transform3D buffer = new Transform3D();
    private Vector measures;
    private Vector measureListeners;
    private GlobalProperties props = PropertiesManager.getGlobalProperties(1);
    public static int ANIM = 0;
    public static int GENERIC = 1;
    private int updateMode = GENERIC;
    private BranchGroup atomBranchGroup;
    private TransformGroup atomTransformGroup;
    private Vector3d zero;
    private Vector3d atomOffset = this.zero = new Vector3d(0.0, 0.0, 0.0);
    private Vector atomSelectionCanvas;
    private BasicOperations basicOperations;
    private Vector3d offset;
    private double[] cellOffset = new double[]{0.0, 0.0, 0.0};
    private String[] elements;
    private TaggedString[][] auxils;
    private Vector bonds;
    private Vector Hbonds;
    private SceneGraphElementBG cellObject;

    public void setParentFrame(MainPanel mp) {
        this.mp = mp;
    }

    public BasicOperations getBasicOperations() {
        if (this.basicOperations == null) {
            this.basicOperations = new BasicOperations(this.mp);
        }
        return this.basicOperations;
    }

    public MainPanel getParentFrame() {
        return this.mp;
    }

    public void setPicker(AtomPicker picker) {
        picker.setParent(this);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)picker);
        this.addChild((Node)bg);
    }

    public void addAtomSelectionCanvas(AtomSelectionCanvas foo) {
        if (this.atomSelectionCanvas == null) {
            this.atomSelectionCanvas = new Vector();
        }
        this.atomSelectionCanvas.addElement(foo);
    }

    public void removeAtomSelectionCanvas(AtomSelectionCanvas foo) {
        if (this.atomSelectionCanvas == null) {
            return;
        }
        this.atomSelectionCanvas.remove(foo);
    }

    public void setUpdateMode(int updateMode) {
        this.updateMode = updateMode;
    }

    public void addMeasureListener(MeasureListener list) {
        if (this.measureListeners == null) {
            this.measureListeners = new Vector();
        }
        this.measureListeners.addElement(list);
    }

    public void removeMeasureListener(MeasureListener list) {
        if (this.measureListeners == null) {
            return;
        }
        this.measureListeners.remove(list);
    }

    public void setAtomOffset(Vector3d off) {
        if (Math.abs(off.x) > 0.5 || Math.abs(off.y) > 0.5 || Math.abs(off.z) > 0.5) {
            return;
        }
        this.atomOffset = off;
    }

    public void setOffset(Vector3d offset) {
        this.offset = offset;
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public double[] getJusin() {
        double[] jusin_buff = this.getConfigData().getCellOriginVector();
        double[] celloff = this.getCellOffset();
        for (int i = 0; i < 3; ++i) {
            jusin_buff[i] = -(jusin_buff[i] + celloff[i] * this.lenmax);
        }
        return jusin_buff;
    }

    public Vector3d getAtomOffset() {
        return this.atomOffset;
    }

    public float[][] getEffectiveBounds() {
        double[][] ce = this.mCD.getCell();
        double len = this.mCD.getLenMax();
        logger.debug("lenmax: " + len);
        if (ce == null) {
            return null;
        }
        float[][] ret = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ret[i][j] = (float)(ce[i][j] / len);
            }
        }
        return ret;
    }

    public void registerMeasure(Measure measure) {
        this.registerMeasure(measure, true);
    }

    public void registerMeasure(Measure measure, boolean deselctAll) {
        if (this.measure != null && measure != null && this.measure.getClass().getName().equals(measure.getClass().getName())) {
            this.endMeasure();
        }
        this.measure = measure;
        if (this.measures == null) {
            this.measures = new Vector();
        }
        this.measures.add(measure);
        this.startMeasure(deselctAll);
    }

    public MeasureBranchGroup[] getExistingMeasures() {
        Node[] bgroups = this.getChildren(MeasureBranchGroup.class);
        if (bgroups == null || bgroups.length == 0) {
            return null;
        }
        MeasureBranchGroup[] ret = new MeasureBranchGroup[bgroups.length];
        for (int i = 0; i < bgroups.length; ++i) {
            ret[i] = (MeasureBranchGroup)bgroups[i];
        }
        return ret;
    }

    public void toggleMeasure() {
        if (this.measureAtWork && this.measure != null) {
            this.endMeasure();
        } else {
            this.startMeasure();
        }
    }

    public void startMeasure() {
        this.startMeasure(true);
    }

    public void startMeasure(boolean deselectAll) {
        if (deselectAll) {
            this.deselectAll();
        }
        this.measureAtWork = true;
        logger.debug("start measure");
    }

    public void endMeasure() {
        this.deselectAll();
        this.measureAtWork = false;
        this.measure = null;
        logger.debug("end measure");
    }

    public void stopMeasure() {
        this.measureAtWork = false;
    }

    public void restartMeasure() {
        this.measureAtWork = true;
    }

    public void selected(AtomObject obj) {
        int i;
        if (this.atomSelectionCanvas != null) {
            for (i = 0; i < this.atomSelectionCanvas.size(); ++i) {
                ((AtomSelectionCanvas)this.atomSelectionCanvas.get(i)).selected(obj);
            }
        }
        this.selectedAtoms.push(obj);
        if (this.measure == null || this.measure.getNumberOfNecessaryAtoms() < 0) {
            return;
        }
        if (this.measureAtWork && this.selectedAtoms.size() >= this.measure.getNumberOfNecessaryAtoms()) {
            this.measure.measure(this.selectedAtoms);
            this.measure.draw();
            this.deselectAll();
            if (this.measureListeners != null) {
                for (i = 0; i < this.measureListeners.size(); ++i) {
                    MeasureListener list = (MeasureListener)this.measureListeners.get(i);
                    list.measured(this.measure);
                }
            }
        }
    }

    private void doBond() {
    }

    public void removeMeasureObjects() {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof MeasureBranchGroup)) continue;
            ((MeasureBranchGroup)((Object)obj)).detach();
        }
        if (this.measures != null) {
            for (int i = this.measures.size() - 1; i <= 0; --i) {
                Object obj = this.measures.get(i);
                this.measures.remove(i);
                Object var3_4 = null;
            }
        }
    }

    public void updateMeasureObjects() {
        if (this.measures == null) {
            return;
        }
        for (int i = 0; i < this.measures.size(); ++i) {
            ((Measure)this.measures.get(i)).update(this.getAtomObjects());
            if (this.measureListeners == null) continue;
            for (int j = 0; j < this.measureListeners.size(); ++j) {
                ((MeasureListener)this.measureListeners.get(j)).measureUpdated((Measure)this.measures.get(i));
            }
        }
    }

    public void addShape(BranchGroup shape) {
        this.addChild((Node)shape);
    }

    public SceneGraphElementCreator getCreator() {
        return this.creator;
    }

    public void deselected(AtomObject obj) {
        if (this.selectedAtoms.remove(obj)) {
            logger.debug("removed atom " + obj.getID() + " from 'selected' list");
        }
        if (this.atomSelectionCanvas != null) {
            for (int i = 0; i < this.atomSelectionCanvas.size(); ++i) {
                ((AtomSelectionCanvas)this.atomSelectionCanvas.get(i)).deselected(obj);
            }
        }
    }

    public void deselectAll() {
        AtomObject[] selected = this.getSelectedAtoms();
        if (selected == null) {
            return;
        }
        logger.debug("removing all atoms.");
        int n = selected.length;
        for (int i = 0; i < n; ++i) {
            selected[i].unSelect();
            if (this.atomSelectionCanvas == null) continue;
            for (int j = 0; j < this.atomSelectionCanvas.size(); ++j) {
                ((AtomSelectionCanvas)this.atomSelectionCanvas.get(j)).deselected(selected[i]);
            }
        }
        BranchGroup root = this.mp.getRootBranch();
        Enumeration enu = root.getAllChildren();
        this.selectedAtoms = new Stack();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MyMouseTranslate)) continue;
            ((MyMouseTranslate)((Object)object)).clear();
            ((Behavior)object).setEnable(true);
        }
    }

    public void setRotationEnabled(boolean enable) {
        BranchGroup root = this.mp.getRootBranch();
        Enumeration enu = root.getAllChildren();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MyMouseRotate)) continue;
            ((MyMouseRotate)((Object)object)).init();
            ((Behavior)object).setEnable(enable);
        }
    }

    public double getLenMax() {
        return this.mCD.getLenMax();
    }

    public double[] getCOM() {
        return this.mCD.getCOM();
    }

    public void cleanUp() {
        if (this.bonds != null) {
            for (int i = 0; i < this.bonds.size(); ++i) {
                ((BondInfo)this.bonds.get(i)).nullify();
            }
            this.bonds.clear();
            this.bonds = null;
        }
        if (this.mCD != null && this.mCD.getAtomCoords() != null) {
            this.mCD.getAtomCoords().nullify();
        }
        this.Dpos = null;
        if (this.mp != null && this.mp.getFramesAC() != null) {
            Vector vec = this.mp.getFramesAC();
            for (int i = 0; i < vec.size(); ++i) {
                AtomCoords co = (AtomCoords)vec.get(i);
                co.nullify();
                Object var3_4 = null;
            }
            vec.clear();
        }
    }

    public void setSceneGraphElementCreator(SceneGraphElementCreator creator) {
        this.creator = creator;
        this.mCD = creator.getConfigData();
        this.mACVD = creator.getACVData();
        this.mCD.register(this);
    }

    public ConfigDataManager getConfigData() {
        return this.creator.getConfigData();
    }

    public J3DDataManager getACVData() {
        return this.creator.getACVData();
    }

    public void create() {
        this.prepare(true);
        this.addAtoms();
        this.addBond();
        this.addHbonds();
        this.addCell();
    }

    public void restoreSelection(int last, int[] selectedBuffer) {
        logger.debug("restoreing selection...");
        logger.debug("numat now: " + this.mCD.getNumAt() + ", previous numat: " + last);
        if (selectedBuffer == null || selectedBuffer.length == 0) {
            return;
        }
        logger.debug("size of 'selected' buffer: " + selectedBuffer.length);
        if (this.mCD.getNumAt() == last) {
            AtomObject[] atoms = this.getAtomObjects();
            if (atoms == null || selectedBuffer == null) {
                return;
            }
            for (int i = 0; i < atoms.length; ++i) {
                for (int j = 0; j < selectedBuffer.length; ++j) {
                    if (Integer.parseInt(atoms[i].getID()) - 1 != selectedBuffer[j]) continue;
                    atoms[i].setSelected();
                }
            }
        }
    }

    private void prepare() {
        this.prepare(false);
    }

    public void prepare(boolean rescaleOnUpdate) {
        this.NumAt = this.mCD.getNumAt();
        double[][] DposOrig = this.mCD.getPos();
        if (DposOrig == null) {
            return;
        }
        this.Dpos = new double[this.NumAt][3];
        for (int i = 0; i < this.NumAt; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.Dpos[i][j] = DposOrig[i][j];
            }
        }
        if (rescaleOnUpdate) {
            this.mCD.doShiftScale();
        }
        double lenmax = this.mCD.getLenMax();
        double[] COM = this.mCD.getCOM();
        for (int i = 0; i < this.NumAt; ++i) {
            for (int j = 0; j < 3; ++j) {
                double foo = this.Dpos[i][j];
                foo -= COM[j];
                this.Dpos[i][j] = foo /= lenmax;
            }
        }
        this.Dforce = this.mCD.getForce();
    }

    public double[] getCellOffset() {
        return this.cellOffset;
    }

    private boolean[] applyPBC(double[][] coords) {
        int i;
        float[][] ce = this.getEffectiveBounds();
        double[][] ced = new double[3][3];
        double[][] sced = new double[3][3];
        double[][] plane01 = new double[2][3];
        double[][] plane02 = new double[2][3];
        double[][] plane12 = new double[2][3];
        this.lenmax = this.mCD.getLenMax();
        double[] foo = this.mCD.getCOM();
        double[] orig = new double[3];
        double[] coff = this.getCellOffset();
        double[] corig = this.mCD.getCellOriginVector();
        for (i = 0; i < foo.length; ++i) {
            orig[i] = corig[i] + coff[i] * this.lenmax;
            logger.debug("cell offset, cell origin, jusin: " + coff[i] + ", " + corig[i] / this.lenmax + ", " + foo[i] / this.lenmax);
        }
        for (i = 0; i < 3; ++i) {
            ced[0][i] = (double)ce[0][i] * this.lenmax;
            ced[1][i] = (double)ce[1][i] * this.lenmax;
            ced[2][i] = (double)ce[2][i] * this.lenmax;
            sced[0][i] = ced[0][i] + orig[i];
            sced[1][i] = ced[1][i] + orig[i];
            sced[2][i] = ced[2][i] + orig[i];
            plane01[0][i] = ced[0][i];
            plane01[1][i] = ced[1][i];
            plane02[0][i] = ced[2][i];
            plane02[1][i] = ced[0][i];
            plane12[0][i] = ced[1][i];
            plane12[1][i] = ced[2][i];
        }
        int shifted = 0;
        boolean[] bshifted = new boolean[coords.length];
        for (int i2 = 0; i2 < coords.length; ++i2) {
            int j;
            double[] pos = coords[i2];
            for (int j2 = 0; j2 < 3; ++j2) {
                int n = j2;
                pos[n] = pos[n] - foo[j2];
            }
            double r01 = VectorOperations.getDistanceFromPlane(pos, plane01[0], plane01[1], orig, true);
            double r10 = VectorOperations.getDistanceFromPlane(pos, plane01[1], plane01[0], sced[2], true);
            double r02 = VectorOperations.getDistanceFromPlane(pos, plane02[0], plane02[1], orig, true);
            double r20 = VectorOperations.getDistanceFromPlane(pos, plane02[1], plane02[0], sced[1], true);
            double r12 = VectorOperations.getDistanceFromPlane(pos, plane12[0], plane12[1], orig, true);
            double r21 = VectorOperations.getDistanceFromPlane(pos, plane12[1], plane12[0], sced[0], true);
            if (r01 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] + ced[2][j];
                }
            } else if (r10 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] - ced[2][j];
                }
            }
            if (r02 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] + ced[1][j];
                }
            } else if (r20 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] - ced[1][j];
                }
            }
            if (r12 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] + ced[0][j];
                }
            } else if (r21 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] - ced[0][j];
                }
            }
            for (j = 0; j < 3; ++j) {
                int n = j;
                pos[n] = pos[n] + foo[j];
            }
            coords[i2] = pos;
        }
        logger.debug("shifted atoms count: " + shifted);
        return bshifted;
    }

    private boolean[] doShift() {
        float[][] ce = this.getEffectiveBounds();
        if (ce == null) {
            return null;
        }
        VolumetricData[] vdata = this.mp.getAssociatedVolumetricData();
        if (vdata != null) {
            logger.debug("vdata update start");
            int n1 = (int)((double)vdata[0].getNumDiv()[0] * this.atomOffset.x);
            int n2 = (int)((double)vdata[0].getNumDiv()[1] * this.atomOffset.y);
            int n3 = (int)((double)vdata[0].getNumDiv()[2] * this.atomOffset.z);
            this.atomOffset.x = (double)n1 / ((double)vdata[0].getNumDiv()[0] - 1.0);
            this.atomOffset.y = (double)n2 / ((double)vdata[0].getNumDiv()[1] - 1.0);
            this.atomOffset.z = (double)n3 / ((double)vdata[0].getNumDiv()[2] - 1.0);
            logger.debug("vdata update end");
        }
        double xoff = this.atomOffset.x * (double)ce[0][0] + this.atomOffset.y * (double)ce[1][0] + this.atomOffset.z * (double)ce[2][0];
        double yoff = this.atomOffset.x * (double)ce[0][1] + this.atomOffset.y * (double)ce[1][1] + this.atomOffset.z * (double)ce[2][1];
        double zoff = this.atomOffset.x * (double)ce[0][2] + this.atomOffset.y * (double)ce[1][2] + this.atomOffset.z * (double)ce[2][2];
        logger.debug("offset: " + xoff + ", " + yoff + ", " + zoff);
        Transform3D currtrans = new Transform3D();
        this.getTransform(currtrans);
        Vector3d tra = new Vector3d();
        currtrans.get(tra);
        Matrix3d rot = new Matrix3d();
        currtrans.get(rot);
        rot.invert();
        rot.transform((Tuple3d)tra);
        tra.add((Tuple3d)new Vector3d(xoff, yoff, zoff));
        rot.invert();
        rot.transform((Tuple3d)tra);
        currtrans.setTranslation(new Vector3d(tra));
        this.setTransform(currtrans);
        CellObject co = this.getCellObject();
        if (co != null) {
            logger.debug("shifting cell back.");
            TransformGroup[] cs = co.getTransforms();
            co.detach();
            this.addChild((Node)co);
            for (int i = 0; i < cs.length; ++i) {
                cs[i].getTransform(currtrans);
                currtrans.get(tra);
                tra.sub((Tuple3d)new Vector3d(xoff, yoff, zoff));
                currtrans.setTranslation(tra);
                cs[i].setTransform(currtrans);
            }
        }
        this.cellOffset[0] = this.cellOffset[0] - xoff;
        this.cellOffset[1] = this.cellOffset[1] - yoff;
        this.cellOffset[2] = this.cellOffset[2] - zoff;
        AtomObject[] as = this.getAtomObjects();
        double[] com = this.mCD.getCOM();
        double len = this.mCD.getLenMax();
        double[][] newcoords = this.mCD.getPos();
        boolean[] valid = this.applyPBC(newcoords);
        this.getConfigData().getAtomCoords().setPosDouble(newcoords);
        this.atomOffset = this.zero;
        return valid;
    }

    public void atomUpdate() {
        int i;
        logger.debug("updating atom...");
        boolean[] valid = new boolean[this.getAtomObjects().length];
        for (int i2 = 0; i2 < valid.length; ++i2) {
            valid[i2] = true;
        }
        if (!this.atomOffset.epsilonEquals((Tuple3d)this.zero, 0.0) && (valid = this.doShift()) == null) {
            logger.error("invalid cell...");
            return;
        }
        AtomStateList state = this.getConfigData().getAtomCoords().getAtomState();
        if (state == null) {
            if (this.mCD.forceUpdate()) {
                this.mCD.setScaleAtom(this.mACVD.getScaleAtom());
            }
            AtomObject[] aobj = this.getAtomObjects();
            for (int i3 = 0; i3 < aobj.length; ++i3) {
                if (!valid[i3]) continue;
                aobj[i3].configDataUpdate();
            }
            logger.debug("done atom update");
            return;
        }
        logger.debug("num. atoms may have changed...");
        AtomObjectBG[] obj = this.getAtomObjectBGs();
        this.elements = this.mCD.getAtomCoords().getElements();
        this.auxils = this.mCD.getAtomCoords().getAuxils();
        AtomState[] res = state.getResults();
        for (i = 0; i < res.length; ++i) {
            if (res[i].origIndex >= obj.length) continue;
            if (res[i].mode == AtomState.REMOVED) {
                obj[res[i].origIndex].detach();
                obj[res[i].origIndex] = null;
            }
            if (res[i].mode == AtomState.MODIFIED) {
                obj[res[i].origIndex].getAssociatedAtomObject().setID(res[i].index + 1);
                obj[res[i].origIndex].getAssociatedAtomObject().configDataUpdate();
            }
            if (res[i].mode != AtomState.UNCHANGED) continue;
            obj[res[i].origIndex].getAssociatedAtomObject().setID(res[i].index + 1);
        }
        for (i = 0; i < res.length; ++i) {
            if (res[i].mode != AtomState.ADDED) continue;
            int ind = res[i].index;
            logger.debug("adding atom : " + ind);
            BranchGroup bg = this.createAtom(ind);
            if (bg == null) {
                logger.debug("null atom at : " + ind);
                continue;
            }
            if (ind >= this.atomBranchGroup.numChildren()) {
                this.atomBranchGroup.addChild((Node)bg);
                continue;
            }
            this.atomBranchGroup.insertChild((Node)bg, ind);
        }
        int[] map = state.getIndexMap();
        for (int i4 = 0; i4 < this.bonds.size(); ++i4) {
            BondInfo inf = (BondInfo)this.bonds.get(i4);
            int[] pair = inf.getIndexPair();
            logger.debug("old index pair & new index pair: " + pair[0] + ", " + pair[1] + "  :  " + map[pair[0]] + ", " + map[pair[1]]);
            pair[0] = map[pair[0]];
            pair[1] = map[pair[1]];
            inf.setIndexPair(pair[0], pair[1]);
        }
        logger.debug("done atom update");
    }

    private BranchGroup createAtom(int i) {
        int atomicNumber = 1;
        if (i >= this.elements.length || this.elements[i] == null || this.elements[i].length() == 0) {
            return null;
        }
        for (int j = 0; j < this.mACVD.getNumEl(); ++j) {
            if (!this.elements[i].equals(this.mACVD.getElement()[j])) continue;
            atomicNumber = j;
        }
        int[] mw = TGAtom.getMobileAndWeight(this.auxils, i);
        int mobile = mw[0];
        int weight = mw[1];
        String ID = new Integer(i + 1).toString();
        BranchGroup at = this.creator.getSceneGraphElement(ID, atomicNumber, this.Dpos[i], this.Dforce[i], mobile, weight);
        ((AtomObjectBG)at).getAssociatedAtomObject().register(this.mCD, this.mACVD, this);
        return at;
    }

    public static int[] getMobileAndWeight(TaggedString[][] auxs, int i) {
        int mobile = 0;
        int weight = 1;
        try {
            for (int au = 0; au < auxs[0].length; ++au) {
                TaggedString ts = auxs[i][au];
                if (ts.getTag().trim().equalsIgnoreCase("mobile")) {
                    try {
                        mobile = Integer.parseInt(ts.getValue());
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (!ts.getTag().trim().equalsIgnoreCase("weight")) continue;
                try {
                    weight = Integer.parseInt(ts.getValue());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException npe) {
            mobile = 0;
            weight = 1;
        }
        return new int[]{mobile, weight};
    }

    private void addAtoms() {
        this.atomBranchGroup = new BranchGroup();
        this.atomBranchGroup.setCapability(12);
        this.atomBranchGroup.setCapability(13);
        this.atomBranchGroup.setCapability(14);
        this.atomTransformGroup = new TransformGroup();
        this.atomTransformGroup.setCapability(17);
        this.atomTransformGroup.setCapability(18);
        this.atomTransformGroup.addChild((Node)this.atomBranchGroup);
        this.elements = this.mCD.getElements();
        this.auxils = this.mCD.getAuxils();
        this.mCD.setScaleAtom(this.mACVD.getScaleAtom());
        for (int i = 0; i < this.NumAt; ++i) {
            BranchGroup bg = this.createAtom(i);
            if (bg == null) continue;
            this.atomBranchGroup.addChild((Node)bg);
        }
        this.addChild((Node)this.atomTransformGroup);
    }

    private void HbondUpdate() {
        if (!new Boolean(this.props.getProperty("hbond_draw_hbonds")).booleanValue()) {
            if (this.Hbonds != null) {
                for (int i = this.Hbonds.size() - 1; i >= 0; --i) {
                    BondInfo binf = (BondInfo)this.Hbonds.get(i);
                    int[] indpair = binf.getIndexPair();
                    double crtdst = binf.getCriticalDistanceSquared();
                    double[] at1 = this.Dpos[indpair[0]];
                    double[] at2 = this.Dpos[indpair[1]];
                    BondObject oj = binf.getBond();
                    binf.getBond().detach();
                    this.Hbonds.removeElementAt(i);
                    oj = null;
                    binf = null;
                }
                this.Hbonds = null;
            }
            return;
        }
        if (this.Hbonds == null) {
            this.addHbonds();
            return;
        }
        boolean[][] ignore = new boolean[this.NumAt][this.NumAt];
        double[][] postmp = this.getScaledPos();
        for (int i = this.Hbonds.size() - 1; i >= 0; --i) {
            double[] at2;
            double[] at1;
            BondInfo binf = (BondInfo)this.Hbonds.get(i);
            int[] indpair = binf.getIndexPair();
            if (indpair[0] >= postmp.length || indpair[1] >= postmp.length || indpair[0] < 0 || indpair[1] < 0) {
                this.remBond(binf, i);
                continue;
            }
            double crtdst = binf.getCriticalDistanceSquared();
            if (crtdst < Math.pow((at1 = postmp[indpair[0]])[0] - (at2 = postmp[indpair[1]])[0], 2.0) + Math.pow(at1[1] - at2[1], 2.0) + Math.pow(at1[2] - at2[2], 2.0)) {
                BondObject oj = binf.getBond();
                binf.getBond().detach();
                this.Hbonds.removeElementAt(i);
                oj = null;
                binf = null;
            } else {
                binf.getBond().recreate(new double[]{at1[0], at1[1], at1[2], at2[0], at2[1], at2[2]});
            }
            ignore[indpair[0]][indpair[1]] = true;
        }
        this.hbondCalculator.setIgnore(ignore);
        this.hbondCalculator.doHbond(postmp);
        Vector foo = this.hbondCalculator.getBonds();
        for (int i = 0; i < foo.size(); ++i) {
            BondInfo binf = (BondInfo)foo.get(i);
            double[] NearestNeighbor_ = binf.getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_, BondObject.HBOND);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
            this.Hbonds.addElement(binf);
        }
    }

    private void remBond(BondInfo binf, int i) {
        BondObject obj = binf.getBond();
        binf.getBond().detach();
        if (i < this.bonds.size()) {
            this.bonds.removeElementAt(i);
        }
        obj = null;
        binf = null;
    }

    private void bondUpdate() {
        if (this.bonds == null) {
            return;
        }
        boolean[][] ignore = new boolean[this.NumAt][this.NumAt];
        AtomObject[] atomObjects = this.getAtomObjects();
        if (this.mCD.forceUpdate()) {
            for (int i = this.bonds.size() - 1; i >= 0; --i) {
                BondInfo binf = (BondInfo)this.bonds.get(i);
                this.remBond(binf, i);
            }
        }
        double[][] postmp = this.getScaledPos();
        for (int i = this.bonds.size() - 1; i >= 0; --i) {
            BondInfo binf = (BondInfo)this.bonds.get(i);
            int[] indpair = binf.getIndexPair();
            double crtdst = binf.getCriticalDistanceSquared();
            if (indpair[0] >= postmp.length || indpair[1] >= postmp.length || indpair[0] < 0 || indpair[1] < 0) {
                this.remBond(binf, i);
                continue;
            }
            double[] at1 = postmp[indpair[0]];
            double[] at2 = postmp[indpair[1]];
            if (this.updateMode == GENERIC) {
                int atnum1 = this.mCD.getAtomicNumber(indpair[0]) - 1;
                int atnum2 = this.mCD.getAtomicNumber(indpair[1]) - 1;
                if (atnum1 < 0 || atnum2 < 0) {
                    this.remBond(binf, i);
                    continue;
                }
                crtdst = Math.pow(this.mACVD.getBondFactor() * (this.mACVD.getCovRad()[atnum1] + this.mACVD.getCovRad()[atnum2]) / this.mCD.getLenMax(), 2.0);
            }
            if (crtdst < Math.pow(at1[0] - at2[0], 2.0) + Math.pow(at1[1] - at2[1], 2.0) + Math.pow(at1[2] - at2[2], 2.0)) {
                this.remBond(binf, i);
                continue;
            }
            binf.getBond().recreate(new double[]{at1[0], at1[1], at1[2], at2[0], at2[1], at2[2]});
            ignore[indpair[0]][indpair[1]] = true;
        }
        this.clcbnd.setIgnore(ignore);
        this.clcbnd.doIt(postmp);
        Vector foo = this.clcbnd.getBonds();
        for (int i = 0; i < foo.size(); ++i) {
            BondInfo binf = (BondInfo)foo.get(i);
            double[] NearestNeighbor_ = binf.getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
            this.bonds.addElement(binf);
        }
    }

    private void addBond() {
        this.clcbnd = new BondCalculator(this.mACVD, this.mCD);
        double[][] dp = this.mCD.getPos();
        double[][] postmp = this.getScaledPos();
        this.clcbnd.doIt(postmp);
        this.bonds = this.clcbnd.getBonds();
        for (int i = 0; i < this.bonds.size(); ++i) {
            BondInfo binf = (BondInfo)this.bonds.get(i);
            double[] NearestNeighbor_ = binf.getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
        }
    }

    private double[][] getScaledPos() {
        double[][] dp = this.mCD.getPos();
        double[][] postmp = new double[dp.length][3];
        for (int i = 0; i < postmp.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                postmp[i][j] = (dp[i][j] - this.mCD.getCOM()[j]) / this.mCD.getLenMax();
            }
        }
        return postmp;
    }

    private void addHbonds() {
        if (!new Boolean(this.props.getProperty("hbond_draw_hbonds")).booleanValue()) {
            return;
        }
        this.hbondCalculator = new BondCalculator(this.mACVD, this.mCD);
        this.hbondCalculator.doHbond(this.Dpos);
        this.Hbonds = this.hbondCalculator.getBonds();
        if (this.Hbonds == null) {
            return;
        }
        logger.debug("num hbonds: " + this.Hbonds.size());
        for (int i = 0; i < this.Hbonds.size(); ++i) {
            BondInfo binf = (BondInfo)this.Hbonds.get(i);
            logger.debug("bond info; bondlength: " + binf.getBondLength() * this.mCD.getLenMax());
            double[] NearestNeighbor_ = binf.getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_, BondObject.HBOND);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
        }
    }

    private void addCell() {
        logger.debug("at addCell()");
        if (this.cellObject != null) {
            this.cellObject.detach();
        }
        if (this.mACVD.getDrawCell()) {
            this.cellObject = this.creator.getSceneGraphElementBG(2);
            this.addChild((Node)this.cellObject);
        }
    }

    public int getSelectedAtomCount() {
        int ret = 0;
        AtomObject[] aobjs = this.getAtomObjects();
        if (aobjs == null) {
            return ret;
        }
        for (int i = 0; i < aobjs.length; ++i) {
            if (!aobjs[i].isSelected()) continue;
            ++ret;
        }
        return ret;
    }

    public int[] getSelectedAtomsIndex() {
        int i;
        Vector<String> vret = new Vector<String>();
        AtomObject[] aobjs = this.getAtomObjects();
        if (aobjs == null) {
            return null;
        }
        for (i = 0; i < aobjs.length; ++i) {
            if (!aobjs[i].isSelected()) continue;
            vret.addElement(aobjs[i].getID());
        }
        if (vret.size() == 0) {
            return null;
        }
        int[] ret = new int[vret.size()];
        for (i = 0; i < vret.size(); ++i) {
            ret[i] = Integer.parseInt((String)vret.elementAt(i)) - 1;
        }
        return ret;
    }

    public void setRescaleOnUpdate(boolean rescaleOnUpdate) {
        this.rescaleOnUpdate = rescaleOnUpdate;
    }

    public boolean getRescaleOnUpdate() {
        return this.rescaleOnUpdate;
    }

    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    public void configDataUpdate() {
        logger.debug("start bond update");
        this.bondUpdate();
        this.HbondUpdate();
        this.doBond();
        logger.debug("end bond update");
        this.updateMeasureObjects();
        if (this.mCD.forceUpdate()) {
            this.addCell();
        }
    }

    public int getLastNumAt() {
        int last = this.mCD.getNumAt();
        logger.debug("stored selection; numat now: " + last);
        return last;
    }

    public boolean needsUpdate() {
        return true;
    }

    public DynamicallyEditable[] getDynamicallyEditableElements() {
        int i;
        Vector<DynamicallyEditable> retvec = new Vector<DynamicallyEditable>();
        AtomObject[] aobjs = this.getAtomObjects();
        BondObject[] bobjs = this.getBondObjects();
        for (i = 0; i < aobjs.length; ++i) {
            retvec.addElement(aobjs[i]);
        }
        if (bobjs != null) {
            for (i = 0; i < bobjs.length; ++i) {
                retvec.addElement(bobjs[i]);
            }
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new DynamicallyEditable[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }

    public CellObject getCellObject() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof CellObject)) continue;
            return (CellObject)this.getChild(i);
        }
        return null;
    }

    private BondObject[] getBondObjects() {
        Vector<Node> retvec = new Vector<Node>();
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof BondObject)) continue;
            retvec.addElement(this.getChild(i));
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new BondObject[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }

    public AtomObjectBG[] getAtomObjectBGs() {
        Vector<Node> retvec = new Vector<Node>();
        for (int i = 0; i < this.atomBranchGroup.numChildren(); ++i) {
            retvec.addElement(this.atomBranchGroup.getChild(i));
        }
        if (retvec.size() == 0) {
            return null;
        }
        AtomObjectBG[] rets = new AtomObjectBG[retvec.size()];
        retvec.copyInto((Object[])rets);
        return rets;
    }

    public AtomObject[] getAtomObjects() {
        Vector<Node> retvec = new Vector<Node>();
        for (int i = 0; i < this.atomBranchGroup.numChildren(); ++i) {
            retvec.addElement(this.atomBranchGroup.getChild(i));
        }
        if (retvec.size() == 0) {
            return null;
        }
        AtomObject[] rets = new AtomObject[retvec.size()];
        for (int i = 0; i < rets.length; ++i) {
            rets[i] = ((AtomObjectBG)((Object)retvec.get(i))).getAssociatedAtomObject();
        }
        return rets;
    }

    public AtomObject[] getSelectedAtoms() {
        AtomObject[] all = this.getAtomObjects();
        if (all == null) {
            return null;
        }
        Vector<AtomObject> retvec = new Vector<AtomObject>();
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].isSelected()) continue;
            retvec.addElement(all[i]);
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new AtomObject[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }
}

