/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import ciss.phase_viewer.acviewer.colormap.ColorBar;
import ciss.phase_viewer.acviewer.colormap.ColorMap;
import ciss.phase_viewer.acviewer.geom.Plane;
import ciss.phase_viewer.acviewer.scenegraphelements.PartitionedCell;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.apache.log4j.Logger;

public class Contour
extends Plane
implements ConfigData {
    private static Logger logger = Logger.getLogger(Contour.class.getName());
    private int ID;
    private boolean invert = false;
    private ColorBar colorBar;
    private J3DPanel parentPanel;
    private float[][] bounds;
    private int cID;
    private boolean force = false;
    private int[] ndiv;
    private ColorMap cmap;
    private float transparency = 0.0f;
    private int transparencyMode = 3;
    private Float minVal;
    private Float maxVal;
    private double lenmax = 1.0;
    private double[] jusin = new double[]{0.0, 0.0, 0.0};
    private Plane[] planes;
    private GlobalProperties prop;
    private VolumetricData vdata;
    private TransparencyAttributes tattr;
    private ColoringAttributes cattr;
    private PolygonAttributes pattr;
    private Appearance app;
    private Shape3D s3d;
    private GeometryArray fanarray;
    private Vector valVec = new Vector();
    private BranchGroup shape3dBranch;
    private DecimalFormat decform = new DecimalFormat("0.00");

    public Contour(J3DPanel parentPanel, VolumetricData vdata, double lenmax, double[] jusin) {
        this.parentPanel = parentPanel;
        this.vdata = vdata;
        this.lenmax = lenmax;
        this.jusin = jusin;
        this.init();
    }

    public void setColorBar(ColorBar colorBar) {
        this.colorBar = colorBar;
    }

    public ColorBar getColorBar() {
        return this.colorBar;
    }

    public int getChargeID() {
        return this.cID;
    }

    public void setChargeID(int cID) {
        this.cID = cID;
    }

    public void setVolumetricData(VolumetricData vdata) {
        this.vdata = vdata;
        this.ndiv = vdata.getNumDiv();
        this.force = true;
    }

    public void forceCreation(boolean force) {
        this.force = force;
    }

    public void setLenMax(double lenmax) {
        this.lenmax = lenmax;
    }

    public double getLenMax() {
        return this.lenmax;
    }

    public double[] getCOM() {
        return this.jusin;
    }

    public void setCOM(double[] jusin) {
        this.jusin = jusin;
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public int getID() {
        return this.ID;
    }

    public Float getMaxVal() {
        return this.maxVal;
    }

    public Float getMinVal() {
        return this.minVal;
    }

    private void init() {
        this.origin.x += 1.3244E-7f;
        this.origin.y += 2.8553E-7f;
        this.origin.z += 3.4302E-7f;
        this.origin_buff.x += 1.3244E-7f;
        this.origin_buff.y += 2.8553E-7f;
        this.origin_buff.z += 3.4302E-7f;
        this.prop = PropertiesManager.getGlobalProperties(1);
        this.setCapability(17);
        this.setCapability(14);
        if (this.cmap == null) {
            this.cmap = BaseColorMap.getSupportedColorMaps()[0];
        }
        if (this.vdata == null) {
            logger.error("charge density not allocated");
            return;
        }
        this.ndiv = this.vdata.getNumDiv();
        if (this.ndiv == null || this.ndiv.length < 3) {
            logger.error("invalid ndiv");
            return;
        }
        this.bounds = ((ChaseTransformGroup)this.parentPanel.getRootTransform()).getEffectiveBounds();
        if (this.parentPanel instanceof MainPanel) {
            ((CoordsViewerInterface)((Object)this.parentPanel)).getCD().register(this);
        }
    }

    public void setColorMap(ColorMap cmap) {
        this.cmap = cmap;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparencyMode(int transparencyMode) {
        this.transparencyMode = transparencyMode;
    }

    public int getTransparencyMode() {
        return this.transparencyMode;
    }

    public String getTransparencyModeInString() {
        if (this.transparencyMode == 3) {
            return "SCREEN_DOOR";
        }
        if (this.transparencyMode == 2) {
            return "BLENDED";
        }
        return "NONE";
    }

    public void setMinMax(Float minVal, Float maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public void setClippingPlane(Plane[] planes) {
        this.planes = planes;
    }

    private GeometryArray createGeometry(Vector valVec) {
        float[] fjusin = new float[3];
        for (int i = 0; i < 3; ++i) {
            fjusin[i] = (float)this.jusin[i];
        }
        float[][][][] coords = this.vdata.getCoordinates_explicitIndeces((float)this.lenmax, fjusin);
        float[][][] vals = this.vdata.getValue_explicitIndeces();
        PartitionedCell cell = new PartitionedCell(coords, vals);
        if (this.planes != null) {
            float[] foo = this.vdata.getOrigin();
            cell.setClippingPlane(this.planes, foo);
        }
        Vector posVec = new Vector();
        Vector<Integer> stripCountVec = new Vector<Integer>();
        try {
            for (int i = 0; i < this.ndiv[2] - 1; ++i) {
                for (int j = 0; j < this.ndiv[1] - 1; ++j) {
                    for (int k = 0; k < this.ndiv[0] - 1; ++k) {
                        int strCount;
                        if (!cell.setData(i, j, k) || (strCount = cell.doPlaneCross(this, valVec, posVec)) < 1) continue;
                        stripCountVec.addElement(new Integer(strCount));
                    }
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (stripCountVec.size() == 0) {
            logger.info("no cell crosses the specified plane.");
            return null;
        }
        int[] strcount = new int[stripCountVec.size()];
        for (int i = 0; i < strcount.length; ++i) {
            strcount[i] = (Integer)stripCountVec.elementAt(i);
        }
        TriangleFanArray farray = new TriangleFanArray(posVec.size(), 5, strcount);
        farray.setCapability(3);
        for (int i = 0; i < posVec.size(); ++i) {
            Point3f p3 = (Point3f)posVec.get(i);
            farray.setCoordinate(i, p3);
        }
        try {
            farray.setCapability(18);
        }
        catch (RestrictedAccessException rae) {
            // empty catch block
        }
        return farray;
    }

    private void doColor() {
        float min = this.vdata.getMinVal();
        float max = this.vdata.getMaxVal();
        if (this.minVal == null) {
            this.minVal = new Float(min);
        }
        if (this.maxVal == null) {
            this.maxVal = new Float(max);
        }
        double minimum = this.minVal.floatValue();
        double maximum = this.maxVal.floatValue();
        Color3f[] colors = new Color3f[this.valVec.size()];
        for (int i = 0; i < this.valVec.size(); ++i) {
            float val = ((Float)this.valVec.get(i)).floatValue();
            if (this.vdata.getInterpolationScheme() == VolumetricData.LOG) {
                colors[i] = this.cmap.getColor3f((float)BaseColorMap.getLogScaledValue(minimum, maximum, val), this.invert);
                continue;
            }
            if (this.vdata.getInterpolationScheme() != VolumetricData.LINEAR) continue;
            colors[i] = this.cmap.getColor3f((float)BaseColorMap.getLinearScaledValue(minimum, maximum, val), this.invert);
        }
        if (this.fanarray != null) {
            this.fanarray.setColors(0, colors);
        }
    }

    private void doAppearance() {
        if (this.app == null) {
            this.app = new Appearance();
            this.app.setCapability(11);
            this.app.setCapability(15);
            this.app.setCapability(9);
        }
        if (this.tattr == null) {
            this.tattr = new TransparencyAttributes();
            this.tattr.setCapability(3);
            this.tattr.setCapability(1);
            this.app.setTransparencyAttributes(this.tattr);
        }
        if (this.pattr == null) {
            this.pattr = new PolygonAttributes();
            this.pattr.setCullFace(0);
            this.pattr.setPolygonMode(2);
            this.pattr.setBackFaceNormalFlip(true);
            this.app.setPolygonAttributes(this.pattr);
        }
        if (this.cattr == null) {
            this.cattr = new ColoringAttributes();
            this.cattr.setShadeModel(3);
            this.app.setColoringAttributes(this.cattr);
        }
        if (this.transparency == 0.0f) {
            this.tattr.setTransparencyMode(4);
        } else {
            this.tattr.setTransparencyMode(this.transparencyMode);
        }
        this.tattr.setTransparency(this.transparency);
    }

    public void createContour() {
        this.valVec = new Vector();
        try {
            this.fanarray = this.createGeometry(this.valVec);
            if (this.fanarray == null) {
                return;
            }
            this.doColor();
            this.doAppearance();
            this.s3d = new Shape3D();
            this.s3d.setCapability(15);
            this.s3d.setCapability(13);
            this.s3d.setAppearance(this.app);
            this.shape3dBranch = new BranchGroup();
            this.shape3dBranch.addChild((Node)this.s3d);
            this.addChild((Node)this.shape3dBranch);
            this.s3d.setGeometry((Geometry)this.fanarray);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void recreateContour() {
        if (!this.origin.epsilonEquals((Tuple3f)this.origin_buff, 0.001f) || !this.normal.epsilonEquals((Tuple3f)this.normal_buff, 1.0E-6f) || this.force) {
            this.force = false;
            this.valVec = new Vector();
            this.fanarray = this.createGeometry(this.valVec);
            this.origin_buff = new Point3f(this.origin);
            this.normal_buff = new Point3f(this.normal);
            if (this.fanarray == null) {
                return;
            }
            this.doColor();
            this.doAppearance();
            if (this.s3d == null) {
                this.s3d = new Shape3D();
                this.s3d.setCapability(15);
                this.s3d.setCapability(13);
                this.s3d.setAppearance(this.app);
                this.shape3dBranch = new BranchGroup();
                this.shape3dBranch.addChild((Node)this.s3d);
                this.addChild((Node)this.shape3dBranch);
            }
            this.s3d.setGeometry((Geometry)this.fanarray);
        } else {
            this.doColor();
            this.doAppearance();
        }
    }

    public String toString() {
        String ret = "";
        if (this.minVal != null && this.maxVal != null) {
            ret = ret + "no. " + String.valueOf(this.ID) + ", norm: " + this.decform.format(this.normal.x) + " " + this.decform.format(this.normal.y) + " " + this.decform.format(this.normal.z);
            ret = ret + ", orig: " + this.decform.format(this.origin.x) + " " + this.decform.format(this.origin.y) + " " + this.decform.format(this.origin.z);
        }
        return ret;
    }

    public void setOrigin(Point3f origin) {
        super.setOrigin(origin);
        origin.x += 1.3244E-7f;
        origin.y += 2.8553E-7f;
        origin.z += 3.4302E-7f;
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        if (e.getType() == ConfigDataUpdateEvent.CELL_CHANGED) {
            this.force = true;
            this.setVolumetricData(this.vdata);
            this.jusin = ((TGAtom)this.parentPanel.getRootTransform()).getJusin();
            this.lenmax = ((TGAtom)this.parentPanel.getRootTransform()).getLenMax();
            this.detach();
            this.recreateContour();
            this.parentPanel.getRootTransform().addChild((Node)this);
            this.bounds = ((ChaseTransformGroup)this.parentPanel.getRootTransform()).getEffectiveBounds();
        }
    }

    public boolean needsUpdate() {
        return true;
    }
}

