/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;

public class WignerSeitzAttributes {
    private Logger logger = Logger.getLogger(WignerSeitzAttributes.class.getName());
    public boolean drawEdge = true;
    public Color3f edgeColor = new Color3f(0.0f, 0.0f, 0.0f);
    public double edgeWidth = 0.005;
    public boolean drawPlane = true;
    public Color3f planeColor = new Color3f(0.9f, 0.6f, 0.6f);
    public float planeTransparency = 0.5f;
    public boolean drawAxis = false;
    public double axisWidth = 0.002;
    public Color3f axisColor = new Color3f(0.0f, 0.0f, 0.0f);
    public boolean drawSymmetryPoints = true;
    public boolean centerOfPlaneIsSymmetric = true;
    public boolean centerOfEdgeIsSymmetric = true;
    public boolean vertexIsSymmetric = true;
    public boolean gammaIsSymmetric = true;
    public Color3f symmetricPointColor = new Color3f(1.0f, 0.8f, 0.4f);
    public Color3f selectedSymmetricPointColor = new Color3f(0.0f, 0.2f, 0.6f);
    public float symmetricPointRadius = 0.02f;
    public float symmetricLineWidth = 4.0f;
    public Color3f symmetricLineColor = new Color3f(0.0f, 0.0f, 0.0f);
    public boolean isReciprocalSpace = true;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    public static String DRAW_EDGE = "wscell_draw_edge";
    public static String DRAW_AXIS = "wscell_draw_axis";
    public static String DRAW_PLANE = "wscell_draw_plane";
    public static String EDGE_WIDTH = "wscell_edge_width";
    public static String PLANE_TRANSPARENCY = "wscell_plane_transparency";
    public static String AXIS_WIDTH = "wscell_axis_width";
    public static String PLANE_COLOR = "wscell_plane_color";
    public static String EDGE_COLOR = "wscell_edge_color";
    public static String AXIS_COLOR = "wscell_axis_color";
    public static String DRAW_SYMMETRIC_POINTS = "wscell_draw_symmetric_points";
    public static String PLANE_CENTER_IS_SYMMETRIC = "wscell_plane_center_is_symmetric";
    public static String EDGE_CENTER_IS_SYMMETRIC = "wscell_edge_center_is_symmetric";
    public static String VERTEX_IS_SYMMETRIC = "wscell_vertex_is_symmetric";
    public static String GAMMA_IS_SYMMETRIC = "wscell_gamma_is_symmetric";
    public static String SYMMETRIC_POINT_COLOR = "wscell_symmetric_point_color";
    public static String SELECTED_SYMMETRIC_POINT_COLOR = "wscell_selected_symmetric_point_color";
    public static String SYMMETRIC_POINT_RADIUS = "wscell_symmetric_point_radius";
    public static String SYMMETRIC_LINE_WIDTH = "wscell_symmetric_line_width";
    public static String SYMMETRIC_LINE_COLOR = "wscell_symmetric_line_color";

    public WignerSeitzAttributes() {
        this.loadFromProps();
    }

    public void loadFromProps() {
        try {
            this.drawEdge = new Boolean(this.gp.getProperty(DRAW_EDGE));
            this.drawAxis = new Boolean(this.gp.getProperty(DRAW_AXIS));
            this.drawPlane = new Boolean(this.gp.getProperty(DRAW_PLANE));
            this.edgeWidth = Double.parseDouble(this.gp.getProperty(EDGE_WIDTH));
            this.planeTransparency = Float.parseFloat(this.gp.getProperty(PLANE_TRANSPARENCY));
            this.axisWidth = Double.parseDouble(this.gp.getProperty(AXIS_WIDTH));
            String[] pcolor = this.gp.getProperty(PLANE_COLOR).split(",");
            this.planeColor = new Color3f(Float.parseFloat(pcolor[0]), Float.parseFloat(pcolor[1]), Float.parseFloat(pcolor[2]));
            String[] ecolor = this.gp.getProperty(EDGE_COLOR).split(",");
            this.edgeColor = new Color3f(Float.parseFloat(ecolor[0]), Float.parseFloat(ecolor[1]), Float.parseFloat(ecolor[2]));
            String[] acolor = this.gp.getProperty(AXIS_COLOR).split(",");
            this.axisColor = new Color3f(Float.parseFloat(acolor[0]), Float.parseFloat(acolor[1]), Float.parseFloat(acolor[2]));
            this.drawSymmetryPoints = new Boolean(this.gp.getProperty(DRAW_SYMMETRIC_POINTS));
            this.centerOfPlaneIsSymmetric = new Boolean(this.gp.getProperty(PLANE_CENTER_IS_SYMMETRIC));
            this.centerOfEdgeIsSymmetric = new Boolean(this.gp.getProperty(EDGE_CENTER_IS_SYMMETRIC));
            this.vertexIsSymmetric = new Boolean(this.gp.getProperty(VERTEX_IS_SYMMETRIC));
            this.gammaIsSymmetric = new Boolean(this.gp.getProperty(GAMMA_IS_SYMMETRIC));
            String[] pointColor = this.gp.getProperty(SYMMETRIC_POINT_COLOR).split(",");
            this.symmetricPointColor = new Color3f(Float.parseFloat(pointColor[0]), Float.parseFloat(pointColor[1]), Float.parseFloat(pointColor[2]));
            String[] selePointColor = this.gp.getProperty(SELECTED_SYMMETRIC_POINT_COLOR).split(",");
            this.selectedSymmetricPointColor = new Color3f(Float.parseFloat(selePointColor[0]), Float.parseFloat(selePointColor[1]), Float.parseFloat(selePointColor[2]));
            String[] lineColor = this.gp.getProperty(SYMMETRIC_LINE_COLOR).split(",");
            this.symmetricLineColor = new Color3f(Float.parseFloat(lineColor[0]), Float.parseFloat(lineColor[1]), Float.parseFloat(lineColor[2]));
            this.symmetricPointRadius = Float.parseFloat(this.gp.getProperty(SYMMETRIC_POINT_RADIUS));
            this.symmetricLineWidth = Float.parseFloat(this.gp.getProperty(SYMMETRIC_LINE_WIDTH));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

