/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.NewElementCreater;
import ciss.phase_viewer.acviewer.keylistener.J3DKeyListener;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseRotate;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseTranslate;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomPicker;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyListener;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class Show3D
implements ConfigData {
    private static Logger logger = Logger.getLogger(Show3D.class.getName());
    private JPanel panel;
    private MainPanel mp;
    private J3DDataManager mACVD;
    private ConfigDataManager mCD;
    private Container cont;
    private int NumAt;
    private int i;
    private int NumBond;
    private TGAtom tgatom;
    private TransformGroup objTransformAxis;
    private Transform3D trans3d;
    private Transform3D trans3dAxis;
    private Transform3D translateorigin;
    private int numNewElements = 0;
    private int lastNumAt;
    private int[] selectedAts;
    private BranchGroup rootRootBranchGroup;
    private BranchGroup rootRootRootBranchGroup;
    private TransformGroup rootRootTransform;
    private BranchGroup objRoot;
    private MyMouseRotate myMouseRotate;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    private BranchGroup legendBranch;
    private BranchGroup axisBranch;
    private SceneGraphElementCreator creator;

    public Show3D(MainPanel parent) {
        this.mp = parent;
        this.mACVD = parent.getJ3DDataManager();
        this.mCD = parent.getCD();
        if (this.mCD != null) {
            this.mCD.register(this);
        }
        this.tgatom = new TGAtom();
        GlobalProperties props = PropertiesManager.getGlobalProperties(1);
        Vector3f pos = new Vector3f(-0.8f, -0.7f, 0.0f);
        try {
            String[] spos = props.getProperty("axis_pos").split(",");
            pos = new Vector3f(Float.parseFloat(spos[0]), Float.parseFloat(spos[1]), Float.parseFloat(spos[2]));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.translateorigin = new Transform3D();
        this.translateorigin.set(pos);
        this.objTransformAxis = new TransformGroup(this.translateorigin);
        this.objTransformAxis.setCapability(18);
        this.objTransformAxis.setCapability(17);
        this.objTransformAxis.setCapability(12);
        this.trans3d = new Transform3D();
        this.trans3dAxis = new Transform3D();
        this.objTransformAxis.getTransform(this.trans3dAxis);
    }

    public void cleanUp() {
        this.objRoot = null;
        this.creator = null;
        this.tgatom = null;
        this.objTransformAxis = null;
        this.mACVD = null;
        this.mCD = null;
    }

    public void setmACVD(J3DDataManager mACVD) {
        this.mACVD = mACVD;
    }

    public J3DDataManager getACV() {
        return this.mACVD;
    }

    public ConfigDataManager getCD() {
        return this.mCD;
    }

    public void storeState() {
        this.storeTrans();
        this.storeSelected();
        this.initTGAtom();
    }

    private void storeTrans() {
        this.tgatom.getTransform(this.trans3d);
        this.objTransformAxis.getTransform(this.trans3dAxis);
    }

    private void storeSelected() {
        this.lastNumAt = this.tgatom.getLastNumAt();
        this.selectedAts = this.tgatom.getSelectedAtomsIndex();
    }

    private void initTGAtom() {
        this.tgatom = new TGAtom();
        this.tgatom.setCapability(12);
        this.tgatom.setCapability(18);
        this.tgatom.setCapability(17);
        this.tgatom.setCapability(1);
        this.objTransformAxis = new TransformGroup(this.translateorigin);
        this.objTransformAxis.setCapability(18);
        this.objTransformAxis.setCapability(17);
        this.objTransformAxis.setCapability(12);
    }

    public void createNewElement() {
        NewElementCreater creater = new NewElementCreater(this.mACVD, this.mCD);
        this.numNewElements = creater.createNewElement();
    }

    public BranchGroup getObjRoot() {
        return this.createObjRoot();
    }

    protected void doPost() {
        this.tgatom.restoreSelection(this.lastNumAt, this.selectedAts);
    }

    public TransformGroup getRootRootTransform() {
        return this.rootRootTransform;
    }

    public void setMouseMotionBehaviours() {
        JPanel component = this.mp.getJCanvas3D();
        this.myMouseRotate = BaseJ3DPanel.useJCanvas3D() ? new MyMouseRotate(component) : new MyMouseRotate();
        this.myMouseRotate.setTransformGroup(this.tgatom);
        this.myMouseRotate.setSchedulingBounds((Bounds)this.bounds);
        this.objRoot.addChild((Node)this.myMouseRotate);
        MyMouseTranslate myMouseTranslate = null;
        myMouseTranslate = BaseJ3DPanel.useJCanvas3D() ? new MyMouseTranslate(component) : new MyMouseTranslate();
        myMouseTranslate.setTransformGroup(this.tgatom);
        myMouseTranslate.setSchedulingBounds((Bounds)this.bounds);
        this.objRoot.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = null;
        myMouseZoom = BaseJ3DPanel.useJCanvas3D() ? new MouseZoom((Component)component) : new MouseZoom();
        myMouseZoom.setTransformGroup((TransformGroup)this.tgatom);
        myMouseZoom.setSchedulingBounds((Bounds)this.bounds);
        this.objRoot.addChild((Node)myMouseZoom);
        MouseWheelZoom myMouseWheelZoom = null;
        myMouseWheelZoom = BaseJ3DPanel.useJCanvas3D() ? new MouseWheelZoom((Component)component) : new MouseWheelZoom();
        myMouseWheelZoom.setTransformGroup((TransformGroup)this.tgatom);
        myMouseWheelZoom.setSchedulingBounds((Bounds)this.bounds);
        this.objRoot.addChild((Node)myMouseWheelZoom);
    }

    private BranchGroup createObjRoot() {
        this.creator = new SceneGraphElementCreator(this.mACVD, this.mCD);
        this.objRoot = new BranchGroup();
        this.objRoot.setCapability(17);
        this.objRoot.setCapability(12);
        this.objRoot.setCapability(13);
        this.objRoot.setCapability(14);
        AtomPicker picker = new AtomPicker(this.mACVD.getParent().getCanvas(), this.objRoot, (Bounds)new BoundingSphere());
        this.tgatom.setPicker(picker);
        this.tgatom.setSceneGraphElementCreator(this.creator);
        this.creator.setTGAtom(this.tgatom);
        this.tgatom.setParentFrame(this.mp);
        this.tgatom.create();
        this.tgatom.setTransform(this.trans3d);
        this.rootRootTransform = new TransformGroup();
        this.rootRootTransform.setCapability(17);
        this.rootRootTransform.setCapability(18);
        this.rootRootTransform.setCapability(13);
        this.rootRootTransform.setCapability(12);
        this.rootRootTransform.addChild((Node)this.tgatom);
        this.objRoot.addChild((Node)this.rootRootTransform);
        JPanel component = this.mp.getJCanvas3D();
        this.objTransformAxis = this.creator.getSceneGraphElement(3);
        this.objTransformAxis.setTransform(this.trans3dAxis);
        MyMouseRotate myMouseRotateAxis = null;
        myMouseRotateAxis = BaseJ3DPanel.useJCanvas3D() ? new MyMouseRotate(component) : new MyMouseRotate();
        myMouseRotateAxis.setTransformGroup(this.objTransformAxis);
        myMouseRotateAxis.setSchedulingBounds((Bounds)this.bounds);
        myMouseRotateAxis.setTranslation(new Vector3d(0.5, 0.0, 0.0));
        this.objRoot.addChild((Node)myMouseRotateAxis);
        if (this.mACVD.getLegend()) {
            this.legendBranch = new BranchGroup();
            this.legendBranch.setCapability(17);
            this.legendBranch.addChild((Node)this.creator.getSceneGraphElement(4));
            this.objRoot.addChild((Node)this.legendBranch);
        }
        this.axisBranch = new BranchGroup();
        this.axisBranch.setCapability(17);
        this.axisBranch.setCapability(12);
        this.axisBranch.setCapability(13);
        this.axisBranch.addChild((Node)this.objTransformAxis);
        if (this.mACVD.getAxis()) {
            this.objRoot.addChild((Node)this.axisBranch);
        }
        this.objRoot.addChild((Node)this.creator.getSceneGraphElement(5));
        this.objRoot.addChild((Node)this.creator.getSceneGraphElement(6));
        KeyListener[] listeners = J3DKeyListener.getKeyListeners(this.mp);
        for (int i = 0; i < listeners.length; ++i) {
            if (BaseJ3DPanel.useJCanvas3D()) {
                this.mp.getJCanvas3D().addKeyListener(listeners[i]);
                continue;
            }
            this.mp.getCanvas().addKeyListener(listeners[i]);
        }
        return this.objRoot;
    }

    public TransformGroup getTGAtom() {
        return this.tgatom;
    }

    public TransformGroup getTGAxis() {
        return this.objTransformAxis;
    }

    public void setTransform(Transform3D transform) {
        Transform3D at = new Transform3D();
        this.tgatom.getTransform(at);
        at.mul(transform);
        this.tgatom.setTransform(at);
        Transform3D axi = new Transform3D();
        this.objTransformAxis.getTransform(axi);
        axi.mul(transform);
        this.objTransformAxis.setTransform(axi);
    }

    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    public boolean needsUpdate() {
        return true;
    }

    public void configDataUpdate() {
        if (this.legendBranch != null) {
            this.legendBranch.detach();
        }
        if (this.mACVD.getLegend()) {
            this.legendBranch = new BranchGroup();
            this.legendBranch.setCapability(17);
            this.legendBranch.addChild((Node)this.creator.getSceneGraphElement(4));
            this.objRoot.addChild((Node)this.legendBranch);
        }
        if (this.axisBranch != null) {
            this.axisBranch.detach();
        }
        if (this.mACVD.getAxis()) {
            this.objRoot.addChild((Node)this.axisBranch);
        }
    }
}

