/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.AbstractDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.XYDataset;
import org.jfree.util.Log;

public class JDBCXYDataset
extends AbstractDataset
implements XYDataset,
RangeInfo {
    private Connection connection;
    private String[] columnNames = new String[0];
    private ArrayList rows = new ArrayList();
    private double maxValue = 0.0;
    private double minValue = 0.0;
    private boolean isTimeSeries = false;

    private JDBCXYDataset() {
    }

    public JDBCXYDataset(String url, String driverName, String user, String password) throws SQLException, ClassNotFoundException {
        this();
        Class.forName(driverName);
        this.connection = DriverManager.getConnection(url, user, password);
    }

    public JDBCXYDataset(Connection con) throws SQLException {
        this();
        this.connection = con;
    }

    public JDBCXYDataset(Connection con, String query) throws SQLException {
        this(con);
        this.executeQuery(query);
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public void setTimeSeries(boolean timeSeries) {
        this.isTimeSeries = timeSeries;
    }

    public void executeQuery(String query) throws SQLException {
        this.executeQuery(this.connection, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Connection con, String query) throws SQLException {
        Exception e32;
        Statement statement;
        block39: {
            Object xObject = null;
            int column = 0;
            int currentColumn = 0;
            int numberOfColumns = 0;
            int numberOfValidColumns = 0;
            int[] columnTypes = null;
            if (con == null) {
                throw new SQLException("There is no database to execute the query.");
            }
            ResultSet resultSet = null;
            ResultSetMetaData metaData = null;
            statement = null;
            try {
                statement = con.createStatement();
                resultSet = statement.executeQuery(query);
                metaData = resultSet.getMetaData();
                numberOfColumns = metaData.getColumnCount();
                columnTypes = new int[numberOfColumns];
                for (column = 0; column < numberOfColumns; ++column) {
                    try {
                        int type = metaData.getColumnType(column + 1);
                        switch (type) {
                            case -7: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 91: 
                            case 92: 
                            case 93: {
                                ++numberOfValidColumns;
                                columnTypes[column] = type;
                                break;
                            }
                            default: {
                                Log.warn((Object)("Unable to load column " + column + " (" + type + "," + metaData.getColumnClassName(column + 1) + ")"));
                                columnTypes[column] = 0;
                                break;
                            }
                        }
                        continue;
                    }
                    catch (SQLException e2) {
                        columnTypes[column] = 0;
                        throw e2;
                    }
                }
                if (numberOfValidColumns <= 1) {
                    throw new SQLException("Not enough valid columns where generated by query.");
                }
                this.columnNames = new String[numberOfValidColumns - 1];
                currentColumn = 0;
                for (column = 1; column < numberOfColumns; ++column) {
                    if (columnTypes[column] == 0) continue;
                    this.columnNames[currentColumn] = metaData.getColumnLabel(column + 1);
                    ++currentColumn;
                }
                if (this.rows != null) {
                    for (column = 0; column < this.rows.size(); ++column) {
                        ArrayList row = (ArrayList)this.rows.get(column);
                        row.clear();
                    }
                    this.rows.clear();
                }
                switch (columnTypes[0]) {
                    case 91: 
                    case 92: 
                    case 93: {
                        this.isTimeSeries = true;
                        break;
                    }
                    default: {
                        this.isTimeSeries = false;
                    }
                }
                while (resultSet.next()) {
                    ArrayList<Object> newRow = new ArrayList<Object>();
                    block25: for (column = 0; column < numberOfColumns; ++column) {
                        xObject = resultSet.getObject(column + 1);
                        switch (columnTypes[column]) {
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: {
                                newRow.add(xObject);
                                continue block25;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                newRow.add(new Long(((Date)xObject).getTime()));
                                continue block25;
                            }
                            case 0: {
                                continue block25;
                            }
                            default: {
                                System.err.println("Unknown data");
                                columnTypes[column] = 0;
                            }
                        }
                    }
                    this.rows.add(newRow);
                }
                if (this.rows.size() == 0) {
                    ArrayList<Integer> newRow = new ArrayList<Integer>();
                    for (column = 0; column < numberOfColumns; ++column) {
                        if (columnTypes[column] == 0) continue;
                        newRow.add(new Integer(0));
                    }
                    this.rows.add(newRow);
                }
                if (this.rows.size() < 1) {
                    this.maxValue = 0.0;
                    this.minValue = 0.0;
                } else {
                    ArrayList row = (ArrayList)this.rows.get(0);
                    this.minValue = this.maxValue = ((Number)row.get(1)).doubleValue();
                    for (int rowNum = 0; rowNum < this.rows.size(); ++rowNum) {
                        row = (ArrayList)this.rows.get(rowNum);
                        for (column = 1; column < numberOfColumns; ++column) {
                            Object testValue = row.get(column);
                            if (testValue == null) continue;
                            double test = ((Number)testValue).doubleValue();
                            if (test < this.minValue) {
                                this.minValue = test;
                            }
                            if (!(test > this.maxValue)) continue;
                            this.maxValue = test;
                        }
                    }
                }
                this.fireDatasetChanged();
                Object var18_21 = null;
                if (resultSet == null) break block39;
            }
            catch (Throwable throwable) {
                Exception e32;
                Object var18_22 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception e32) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Exception e32) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e32) {}
        }
    }

    public Number getXValue(int seriesIndex, int itemIndex) {
        ArrayList row = (ArrayList)this.rows.get(itemIndex);
        return (Number)row.get(0);
    }

    public Number getYValue(int seriesIndex, int itemIndex) {
        ArrayList row = (ArrayList)this.rows.get(itemIndex);
        return (Number)row.get(seriesIndex + 1);
    }

    public int getItemCount(int seriesIndex) {
        return this.rows.size();
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int seriesIndex) {
        if (seriesIndex < this.columnNames.length && this.columnNames[seriesIndex] != null) {
            return this.columnNames[seriesIndex];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    public Range getValueRange() {
        return new Range(this.minValue, this.maxValue);
    }
}

