/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KnownHosts;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JSch {
    static Hashtable config = new Hashtable();
    Vector pool = new Vector();
    Vector identities = new Vector();
    private HostKeyRepository known_hosts = null;
    private static final Logger DEVNULL;
    static Logger logger;
    private Vector proxies;

    public JSch() {
        try {
            String string = (String)System.getProperties().get("os.name");
            if (string != null && string.equals("Mac OS X")) {
                config.put("hmac-sha1", "com.jcraft.jsch.jcraft.HMACSHA1");
                config.put("hmac-md5", "com.jcraft.jsch.jcraft.HMACMD5");
                config.put("hmac-md5-96", "com.jcraft.jsch.jcraft.HMACMD596");
                config.put("hmac-sha1-96", "com.jcraft.jsch.jcraft.HMACSHA196");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Session getSession(String string, String string2) throws JSchException {
        return this.getSession(string, string2, 22);
    }

    public Session getSession(String string, String string2, int n) throws JSchException {
        if (string == null) {
            throw new JSchException("username must not be null.");
        }
        if (string2 == null) {
            throw new JSchException("host must not be null.");
        }
        Session session = new Session(this);
        session.setUserName(string);
        session.setHost(string2);
        session.setPort(n);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(Session session) {
        Vector vector = this.pool;
        synchronized (vector) {
            this.pool.addElement(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(Session session) {
        Vector vector = this.pool;
        synchronized (vector) {
            boolean bl = this.pool.remove(session);
            return bl;
        }
    }

    public void setHostKeyRepository(HostKeyRepository hostKeyRepository) {
        this.known_hosts = hostKeyRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownHosts(String string) throws JSchException {
        if (this.known_hosts == null) {
            this.known_hosts = new KnownHosts(this);
        }
        if (this.known_hosts instanceof KnownHosts) {
            HostKeyRepository hostKeyRepository = this.known_hosts;
            synchronized (hostKeyRepository) {
                ((KnownHosts)this.known_hosts).setKnownHosts(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownHosts(InputStream inputStream) throws JSchException {
        if (this.known_hosts == null) {
            this.known_hosts = new KnownHosts(this);
        }
        if (this.known_hosts instanceof KnownHosts) {
            HostKeyRepository hostKeyRepository = this.known_hosts;
            synchronized (hostKeyRepository) {
                ((KnownHosts)this.known_hosts).setKnownHosts(inputStream);
            }
        }
    }

    public HostKeyRepository getHostKeyRepository() {
        if (this.known_hosts == null) {
            this.known_hosts = new KnownHosts(this);
        }
        return this.known_hosts;
    }

    public void addIdentity(String string) throws JSchException {
        this.addIdentity(string, (byte[])null);
    }

    public void addIdentity(String string, String string2) throws JSchException {
        byte[] byArray = null;
        if (string2 != null) {
            byArray = Util.str2byte(string2);
        }
        this.addIdentity(string, byArray);
        if (byArray != null) {
            Util.bzero(byArray);
        }
    }

    public void addIdentity(String string, byte[] byArray) throws JSchException {
        IdentityFile identityFile = IdentityFile.newInstance(string, null, this);
        this.addIdentity(identityFile, byArray);
    }

    public void addIdentity(String string, String string2, byte[] byArray) throws JSchException {
        IdentityFile identityFile = IdentityFile.newInstance(string, string2, this);
        this.addIdentity(identityFile, byArray);
    }

    public void addIdentity(String string, byte[] byArray, byte[] byArray2, byte[] byArray3) throws JSchException {
        IdentityFile identityFile = IdentityFile.newInstance(string, byArray, byArray2, this);
        this.addIdentity(identityFile, byArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity identity, byte[] object) throws JSchException {
        Object object2;
        if (object != null) {
            try {
                object2 = new byte[((byte[])object).length];
                System.arraycopy(object, 0, object2, 0, ((byte[])object).length);
                object = object2;
                identity.setPassphrase((byte[])object);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Util.bzero(object);
                throw throwable;
            }
            Util.bzero(object);
            {
            }
        }
        object2 = this.identities;
        synchronized (object2) {
            if (!this.identities.contains(identity)) {
                this.identities.addElement(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdentity(String string) throws JSchException {
        Vector vector = this.identities;
        synchronized (vector) {
            int n = 0;
            while (n < this.identities.size()) {
                Identity identity = (Identity)this.identities.elementAt(n);
                if (identity.getName().equals(string)) {
                    this.identities.removeElement(identity);
                    identity.clear();
                    break;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIdentityNames() throws JSchException {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.identities;
        synchronized (vector2) {
            int n = 0;
            while (n < this.identities.size()) {
                Identity identity = (Identity)this.identities.elementAt(n);
                vector.addElement(identity.getName());
                ++n;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllIdentity() throws JSchException {
        Vector vector = this.identities;
        synchronized (vector) {
            Vector vector2 = this.getIdentityNames();
            int n = 0;
            while (n < vector2.size()) {
                String string = (String)vector2.elementAt(n);
                this.removeIdentity(string);
                ++n;
            }
        }
    }

    String getConfig(String string) {
        return (String)config.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProxy(String string, Proxy proxy) {
        String[] stringArray = Util.split(string, ",");
        if (this.proxies == null) {
            this.proxies = new Vector();
        }
        Vector vector = this.proxies;
        synchronized (vector) {
            int n = 0;
            while (n < stringArray.length) {
                if (proxy == null) {
                    this.proxies.insertElementAt(null, 0);
                    this.proxies.insertElementAt(stringArray[n].getBytes(), 0);
                } else {
                    this.proxies.addElement(stringArray[n].getBytes());
                    this.proxies.addElement(proxy);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Proxy getProxy(String string) {
        if (this.proxies == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        Vector vector = this.proxies;
        synchronized (vector) {
            int n = 0;
            while (n < this.proxies.size()) {
                if (Util.glob((byte[])this.proxies.elementAt(n), byArray)) {
                    return (Proxy)this.proxies.elementAt(n + 1);
                }
                n += 2;
            }
            return null;
        }
    }

    void removeProxy() {
        this.proxies = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(Hashtable hashtable) {
        Hashtable hashtable2 = config;
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                config.put(string, (String)hashtable.get(string));
            }
        }
    }

    public static void setLogger(Logger logger) {
        if (logger == null) {
            JSch.logger = DEVNULL;
        }
        JSch.logger = logger;
    }

    static Logger getLogger() {
        return logger;
    }

    static {
        config.put("kex", "diffie-hellman-group1-sha1,diffie-hellman-group-exchange-sha1");
        config.put("server_host_key", "ssh-rsa,ssh-dss");
        config.put("cipher.s2c", "3des-cbc,blowfish-cbc");
        config.put("cipher.c2s", "3des-cbc,blowfish-cbc");
        config.put("mac.s2c", "hmac-md5,hmac-sha1,hmac-sha1-96,hmac-md5-96");
        config.put("mac.c2s", "hmac-md5,hmac-sha1,hmac-sha1-96,hmac-md5-96");
        config.put("compression.s2c", "none");
        config.put("compression.c2s", "none");
        config.put("lang.s2c", "");
        config.put("lang.c2s", "");
        config.put("compression_level", "6");
        config.put("diffie-hellman-group-exchange-sha1", "com.jcraft.jsch.DHGEX");
        config.put("diffie-hellman-group1-sha1", "com.jcraft.jsch.DHG1");
        config.put("dh", "com.jcraft.jsch.jce.DH");
        config.put("3des-cbc", "com.jcraft.jsch.jce.TripleDESCBC");
        config.put("blowfish-cbc", "com.jcraft.jsch.jce.BlowfishCBC");
        config.put("hmac-sha1", "com.jcraft.jsch.jce.HMACSHA1");
        config.put("hmac-sha1-96", "com.jcraft.jsch.jce.HMACSHA196");
        config.put("hmac-md5", "com.jcraft.jsch.jce.HMACMD5");
        config.put("hmac-md5-96", "com.jcraft.jsch.jce.HMACMD596");
        config.put("sha-1", "com.jcraft.jsch.jce.SHA1");
        config.put("md5", "com.jcraft.jsch.jce.MD5");
        config.put("signature.dss", "com.jcraft.jsch.jce.SignatureDSA");
        config.put("signature.rsa", "com.jcraft.jsch.jce.SignatureRSA");
        config.put("keypairgen.dsa", "com.jcraft.jsch.jce.KeyPairGenDSA");
        config.put("keypairgen.rsa", "com.jcraft.jsch.jce.KeyPairGenRSA");
        config.put("random", "com.jcraft.jsch.jce.Random");
        config.put("none", "com.jcraft.jsch.CipherNone");
        config.put("aes128-cbc", "com.jcraft.jsch.jce.AES128CBC");
        config.put("aes192-cbc", "com.jcraft.jsch.jce.AES192CBC");
        config.put("aes256-cbc", "com.jcraft.jsch.jce.AES256CBC");
        config.put("userauth.none", "com.jcraft.jsch.UserAuthNone");
        config.put("userauth.password", "com.jcraft.jsch.UserAuthPassword");
        config.put("userauth.keyboard-interactive", "com.jcraft.jsch.UserAuthKeyboardInteractive");
        config.put("userauth.publickey", "com.jcraft.jsch.UserAuthPublicKey");
        config.put("userauth.gssapi-with-mic", "com.jcraft.jsch.UserAuthGSSAPIWithMIC");
        config.put("gssapi-with-mic.krb5", "com.jcraft.jsch.jgss.GSSContextKrb5");
        config.put("zlib", "com.jcraft.jsch.jcraft.Compression");
        config.put("zlib@openssh.com", "com.jcraft.jsch.jcraft.Compression");
        config.put("StrictHostKeyChecking", "ask");
        config.put("HashKnownHosts", "no");
        logger = DEVNULL = new Logger(){

            public boolean isEnabled(int n) {
                return false;
            }

            public void log(int n, String string) {
            }
        };
    }
}

