/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.config.SystemPropertyConfiguration;
import org.jfree.base.modules.PackageManager;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Configuration;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.ExtendedConfigurationWrapper;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractBoot
implements SubSystem {
    private ExtendedConfigurationWrapper extWrapper;
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    protected AbstractBoot() {
    }

    protected Configuration createDefaultHierarchicalConfiguration(String staticConfig, String userConfig, boolean addSysProps) {
        HierarchicalConfiguration globalConfig = new HierarchicalConfiguration();
        if (staticConfig != null) {
            PropertyFileConfiguration rootProperty = new PropertyFileConfiguration();
            rootProperty.load(staticConfig);
            globalConfig.insertConfiguration(rootProperty);
            globalConfig.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (userConfig != null) {
            String userConfigStripped = userConfig.startsWith("/") ? userConfig.substring(1) : userConfig;
            try {
                PropertyFileConfiguration baseProperty;
                Enumeration<URL> userConfigs = ObjectUtilities.getClassLoader(this.getClass()).getResources(userConfigStripped);
                ArrayList<PropertyFileConfiguration> configs = new ArrayList<PropertyFileConfiguration>();
                while (userConfigs.hasMoreElements()) {
                    URL url = userConfigs.nextElement();
                    try {
                        baseProperty = new PropertyFileConfiguration();
                        InputStream in = url.openStream();
                        baseProperty.load(in);
                        in.close();
                        configs.add(baseProperty);
                    }
                    catch (IOException ioe) {
                        Log.warn("Failed to load the user configuration at " + url, ioe);
                    }
                }
                int i = configs.size() - 1;
                while (i >= 0) {
                    baseProperty = (PropertyFileConfiguration)configs.get(i);
                    globalConfig.insertConfiguration(baseProperty);
                    --i;
                }
            }
            catch (IOException e) {
                Log.warn("Failed to lookup the user configurations.", e);
            }
        }
        SystemPropertyConfiguration systemConfig = new SystemPropertyConfiguration();
        globalConfig.insertConfiguration(systemConfig);
        return globalConfig;
    }

    public synchronized ExtendedConfiguration getExtendedConfig() {
        if (this.extWrapper == null) {
            this.extWrapper = new ExtendedConfigurationWrapper(this.getGlobalConfig());
        }
        return this.extWrapper;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
        }
        return this.globalConfig;
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = PackageManager.createInstance(this);
        }
        return this.packageManager;
    }

    protected abstract BootableProjectInfo getProjectInfo();

    public final synchronized boolean isBootDone() {
        return this.bootDone;
    }

    public final synchronized boolean isBootInProgress() {
        return this.bootInProgress;
    }

    protected AbstractBoot loadBooter(String classname) {
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(classname);
            Method m = c.getMethod("getInstance", null);
            return (AbstractBoot)m.invoke(null, null);
        }
        catch (Exception exception) {
            Log.info("Unable to boot dependent class: " + classname);
            return null;
        }
    }

    protected abstract Configuration loadConfiguration();

    protected abstract void performBoot();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void start() {
        AbstractBoot abstractBoot = this;
        synchronized (abstractBoot) {
            if (this.isBootDone()) {
                return;
            }
            while (true) {
                if (!this.isBootInProgress()) {
                    this.bootInProgress = true;
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        BootableProjectInfo info = this.getProjectInfo();
        if (info != null) {
            BootableProjectInfo[] childs = info.getDependencies();
            int i = 0;
            while (i < childs.length) {
                AbstractBoot boot = this.loadBooter(childs[i].getBootClass());
                if (boot != null) {
                    AbstractBoot abstractBoot2 = boot;
                    synchronized (abstractBoot2) {
                        boot.start();
                        while (!boot.isBootDone()) {
                            try {
                                boot.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                ++i;
            }
        }
        this.performBoot();
        if (info != null) {
            Log.info(String.valueOf(info.getName()) + " " + info.getVersion() + " started.");
        } else {
            Log.info(String.valueOf(String.valueOf(this.getClass())) + " started.");
        }
        AbstractBoot abstractBoot3 = this;
        synchronized (abstractBoot3) {
            this.bootInProgress = false;
            this.bootDone = true;
            this.notifyAll();
            return;
        }
    }
}

