/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.IFitData;
import hep.aida.ref.fitter.fitdata.FitData;
import hep.aida.ref.pdf.RangeSet;
import hep.aida.ref.pdf.RangeSetListener;
import hep.aida.ref.pdf.Variable;

public class Dependent
extends Variable
implements RangeSetListener {
    private double value;
    private RangeSet range;
    private FitData data = null;

    public Dependent(String name, double lowerEdge, double upperEdge) {
        super(name, Variable.DEPENDENT);
        this.range = new RangeSet(lowerEdge, upperEdge);
    }

    public double value() {
        return this.value;
    }

    protected void setVariableValue(double value) {
        if (!this.range.isInRange(value)) {
            throw new IllegalArgumentException("Value " + value + " is out of the current range.");
        }
        this.value = value;
    }

    public RangeSet range() {
        return this.range;
    }

    public void rangeSetChanged() {
        this.notifyVariableChanged(Variable.RANGE_CHANGED);
    }

    public void connectToData(Object dataObject) {
        if (dataObject instanceof FitData) {
            this.data = (FitData)dataObject;
        } else {
            this.data = new FitData();
            this.data.create1DConnection(dataObject);
        }
    }

    public boolean isConnected() {
        return this.data != null;
    }

    public IFitData data() {
        return this.data;
    }
}

