/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.ext.IManagedFunction;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.CodeletUtils;
import hep.aida.ref.function.ExponentialCoreNorm;
import hep.aida.ref.function.ExponentialCoreNotNorm;
import hep.aida.ref.function.FunctionCatalog;
import hep.aida.ref.function.GaussianCore2DNorm;
import hep.aida.ref.function.GaussianCore2DNotNorm;
import hep.aida.ref.function.GaussianCoreNorm;
import hep.aida.ref.function.GaussianCoreNotNorm;
import hep.aida.ref.function.JELBaseModelFunction;
import hep.aida.ref.function.PolynomialCoreNorm;
import hep.aida.ref.function.PolynomialCoreNotNorm;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class FunctionCreator {
    public IFunction createFromCodelet(String codeletString) {
        return this.createFromCodelet(null, codeletString);
    }

    public IFunction createFromCodelet(String nameInTree, String codeletString) {
        BaseModelFunction f = null;
        if (!codeletString.toLowerCase().startsWith(FunctionCatalog.prefix)) {
            throw new IllegalArgumentException("\"" + codeletString + "\" is not a codelet string (must start with \"" + FunctionCatalog.prefix + "\")");
        }
        String name = CodeletUtils.modelFromCodelet(codeletString);
        String location = CodeletUtils.locationFromCodelet(codeletString);
        if (CodeletUtils.isCodeletFromCatalog(codeletString)) {
            if (name.toLowerCase().equals("e")) {
                f = new BaseModelFunction(name, name, new ExponentialCoreNotNorm(name), new ExponentialCoreNorm(name));
            } else if (name.toLowerCase().startsWith("p")) {
                f = new BaseModelFunction(name, name, new PolynomialCoreNotNorm(name), new PolynomialCoreNorm(name));
            } else if (name.toLowerCase().startsWith("g2")) {
                f = new BaseModelFunction(name, name, new GaussianCore2DNotNorm(name), new GaussianCore2DNorm(name));
            } else if (name.toLowerCase().startsWith("g")) {
                f = new BaseModelFunction(name, name, new GaussianCoreNotNorm(name), new GaussianCoreNorm(name));
            } else {
                throw new UnsupportedOperationException("Can not create function: " + name);
            }
            f.setCodeletString(codeletString);
            if (nameInTree == null) {
                nameInTree = name;
            }
            ((ManagedObject)f).setName(nameInTree);
        } else if (CodeletUtils.isCodeletFromScript(codeletString)) {
            String scriptDef = location.substring(14);
            int index = scriptDef.indexOf(":");
            int dim = Integer.parseInt(scriptDef.substring(0, index).trim());
            int index2 = scriptDef.indexOf(":", index + 1);
            String valexpr = scriptDef.substring(index + 1, index2);
            index = scriptDef.indexOf(":", index2 + 1);
            String parameters = scriptDef.substring(index2 + 1, index);
            index2 = scriptDef.lastIndexOf(":");
            String gradexpr = scriptDef.substring(index2 + 1);
            if (gradexpr.trim().toLowerCase().equals("null") || gradexpr.trim().equals("")) {
                gradexpr = null;
            }
            f = new JELBaseModelFunction(name, dim, valexpr, parameters, name, gradexpr);
            ((JELBaseModelFunction)f).setCodeletString(codeletString);
            ((ManagedObject)f).setName(nameInTree);
        } else if (CodeletUtils.isCodeletFromFile(codeletString)) {
            try {
                String urlString = location.substring(5).trim();
                if (urlString == null || urlString.equals("")) {
                    Class<?> cl = Class.forName(name);
                    f = (IFunction)cl.newInstance();
                } else {
                    URL[] urlList = new URL[]{new File(urlString.substring(1)).toURL()};
                    URLClassLoader loader = new URLClassLoader(urlList);
                    System.out.println("Name: " + name + "\nFile Name: " + urlString);
                    System.out.println("URL: " + urlList[0].getFile());
                    Class<?> cl = loader.loadClass(name);
                    f = (IFunction)cl.newInstance();
                }
                if (f instanceof ManagedObject) {
                    ((ManagedObject)f).setName(nameInTree);
                }
                if (f instanceof IManagedFunction) {
                    ((IManagedFunction)((Object)f)).setName(nameInTree);
                }
            }
            catch (Exception ec) {
                throw new RuntimeException("Can not create user function:" + name, ec);
            }
        }
        return f;
    }

    public static String toString(IFunction f) {
        String out = "Codelet: " + f.codeletString() + "\n";
        if (f instanceof IManagedObject) {
            out = out + "   name: " + ((IManagedObject)f).name() + "\n";
        }
        out = out + "\tDimensions: " + f.dimension() + "\n";
        for (int i = 0; i < f.dimension(); ++i) {
            out = out + "\t\t Variable " + i + "\t Name: " + f.variableName(i) + "\n";
        }
        out = out + "\tParameters: " + f.numberOfParameters() + "\n";
        String[] par = f.parameterNames();
        for (int i = 0; i < f.numberOfParameters(); ++i) {
            out = out + "\t\t Parameter " + i + "\t Name: " + par[i] + "\n";
        }
        out = out + "Provides gradiant: " + f.providesGradient();
        return out;
    }
}

