/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCatalog;

abstract class CodeletUtils {
    private static String EMPTY_STRING = "";

    CodeletUtils() {
    }

    protected static String modelFromCodelet(String codeletString) {
        int index = codeletString.indexOf(":", FunctionCatalog.prefix.length());
        if (index < 0) {
            return EMPTY_STRING;
        }
        return codeletString.substring(FunctionCatalog.prefix.length(), index).trim();
    }

    protected static String locationFromCodelet(String codeletString) {
        int index = codeletString.indexOf(":", FunctionCatalog.prefix.length());
        if (index < 0) {
            return EMPTY_STRING;
        }
        return codeletString.substring(index + 1);
    }

    protected static boolean isCodeletFromCatalog(String codeletString) {
        return CodeletUtils.locationFromCodelet(codeletString).trim().toLowerCase().startsWith("catalog");
    }

    protected static boolean isCodeletFromScript(String codeletString) {
        return CodeletUtils.locationFromCodelet(codeletString).trim().toLowerCase().startsWith("verbatim:jel ");
    }

    protected static boolean isCodeletFromFile(String codeletString) {
        return CodeletUtils.locationFromCodelet(codeletString).trim().toLowerCase().startsWith("file:");
    }
}

