/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter.fitdata;

import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPointSet;
import hep.aida.IEvaluator;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.IRangeSet;
import hep.aida.ITuple;
import hep.aida.dev.IDevFitData;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ref.fitter.fitdata.FitDataIterator;
import hep.aida.ref.fitter.fitdata.RangeSetFilter;
import hep.aida.ref.function.RangeSet;
import hep.aida.ref.tuple.Tuple;
import hep.aida.ref.tuple.TupleFactory;

public class FitData
implements IDevFitData {
    private ITuple tup;
    private int dimension;
    private int fitType;
    private IRangeSet[] rangeSet;
    private String dataDescription = "";

    public FitData() {
        this.reset();
    }

    public void create1DConnection(Object data) {
        if (data instanceof IHistogram1D) {
            this.create1DConnection((IHistogram1D)data);
        } else if (data instanceof ICloud1D) {
            this.create1DConnection((ICloud1D)data);
        } else if (data instanceof IProfile1D) {
            this.create1DConnection((IProfile1D)data);
        } else if (data instanceof IDataPointSet) {
            this.create1DConnection((IDataPointSet)data);
        } else {
            throw new IllegalArgumentException("Cannot create 1D connection with object of type " + data.getClass());
        }
    }

    public void create1DConnection(IHistogram1D hist) throws IllegalArgumentException {
        this.dataDescription = "IHistogram1D " + ((IManagedObject)hist).name();
        this.prepareConnections(1, 0);
        double[] vals = new double[1];
        int bins = hist.axis().bins();
        for (int i = 0; i < bins; ++i) {
            double e = hist.binError(i);
            double v = hist.binHeight(i);
            vals[0] = hist.binMean(i);
            if (e == 0.0) continue;
            this.fillConnections(v, e, e, vals);
        }
        this.rangeSet[0].includeAll();
    }

    public void create1DConnection(IProfile1D profile) throws IllegalArgumentException {
        this.dataDescription = "IProfile1D " + ((IManagedObject)profile).name();
        this.prepareConnections(1, 0);
        double[] vals = new double[1];
        int bins = profile.axis().bins();
        for (int i = 0; i < bins; ++i) {
            double e = profile.binError(i);
            double v = profile.binHeight(i);
            vals[0] = profile.binMean(i);
            if (e == 0.0) continue;
            this.fillConnections(v, e, e, vals);
        }
        this.rangeSet[0].includeAll();
    }

    public void create1DConnection(ICloud1D cloud) throws IllegalArgumentException {
        this.dataDescription = "ICloud1D " + ((IManagedObject)cloud).name();
        if (cloud.isConverted()) {
            throw new IllegalArgumentException("This ICloud is converted. You should explicitely fit the IHistogram inside the ICloud, if that is what you want to do");
        }
        this.prepareConnections(1, 1);
        double[] vals = new double[1];
        int entries = cloud.entries();
        for (int i = 0; i < entries; ++i) {
            vals[0] = cloud.value(i);
            this.fillConnections(0.0, 0.0, 0.0, vals);
        }
        this.rangeSet[0].includeAll();
    }

    public void create1DConnection(IDataPointSet dataPointSet, int xIndex, int valIndex) throws IllegalArgumentException {
        int[] indeces = new int[]{xIndex};
        this.createConnection(dataPointSet, indeces, valIndex);
    }

    public void create1DConnection(double[] x, double[] y, double[] corrMatrix) throws IllegalArgumentException {
        throw new UnsupportedOperationException("");
    }

    public void create2DConnection(IHistogram2D hist) throws IllegalArgumentException {
        this.create2DConnection(hist, 0, 1);
    }

    public void create2DConnection(IHistogram2D hist, int xIndex, int yIndex) throws IllegalArgumentException {
        if (xIndex * yIndex != 0 || xIndex + yIndex != 1) {
            throw new IllegalArgumentException("Illegal values for the axis " + xIndex + " " + yIndex);
        }
        this.dataDescription = "IHistogram2D " + ((IManagedObject)hist).name();
        this.prepareConnections(2, 0);
        double[] vals = new double[2];
        int xBins = hist.xAxis().bins();
        int yBins = hist.yAxis().bins();
        for (int i = 0; i < xBins; ++i) {
            for (int j = 0; j < yBins; ++j) {
                double e = hist.binError(i, j);
                double v = hist.binHeight(i, j);
                vals[xIndex] = hist.binMeanX(i, j);
                vals[yIndex] = hist.binMeanY(i, j);
                if (e == 0.0) continue;
                this.fillConnections(v, e, e, vals);
            }
        }
        this.rangeSet[xIndex].includeAll();
        this.rangeSet[yIndex].includeAll();
    }

    public void create2DConnection(IProfile2D profile) throws IllegalArgumentException {
        this.create2DConnection(profile, 0, 1);
    }

    public void create2DConnection(IProfile2D profile, int xIndex, int yIndex) throws IllegalArgumentException {
        if (xIndex * yIndex != 0 || xIndex + yIndex != 1) {
            throw new IllegalArgumentException("Illegal values for the axis " + xIndex + " " + yIndex);
        }
        this.dataDescription = "IProfile2D " + ((IManagedObject)profile).name();
        this.prepareConnections(2, 0);
        double[] vals = new double[2];
        int xBins = profile.xAxis().bins();
        int yBins = profile.yAxis().bins();
        for (int i = 0; i < xBins; ++i) {
            for (int j = 0; j < yBins; ++j) {
                double e = profile.binError(i, j);
                double v = profile.binHeight(i, j);
                vals[xIndex] = profile.binMeanX(i, j);
                vals[yIndex] = profile.binMeanY(i, j);
                if (e == 0.0) continue;
                this.fillConnections(v, e, e, vals);
            }
        }
        this.rangeSet[xIndex].includeAll();
        this.rangeSet[yIndex].includeAll();
    }

    public void create2DConnection(ICloud2D cloud) throws IllegalArgumentException {
        this.create2DConnection(cloud, 0, 1);
    }

    public void create2DConnection(ICloud2D cloud, int xIndex, int yIndex) throws IllegalArgumentException {
        if (cloud.isConverted()) {
            throw new IllegalArgumentException("This ICloud is converted. You should explicitely fit the IHistogram inside the ICloud, if that is what you want to do");
        }
        if (xIndex * yIndex != 0 || xIndex + yIndex != 1) {
            throw new IllegalArgumentException("Illegal values for the axis " + xIndex + " " + yIndex);
        }
        this.dataDescription = "ICloud2D " + ((IManagedObject)cloud).name();
        this.prepareConnections(2, 1);
        double[] vals = new double[2];
        int entries = cloud.entries();
        for (int i = 0; i < entries; ++i) {
            vals[xIndex] = cloud.valueX(i);
            vals[yIndex] = cloud.valueY(i);
            this.fillConnections(0.0, 0.0, 0.0, vals);
        }
        this.rangeSet[xIndex].includeAll();
        this.rangeSet[yIndex].includeAll();
    }

    public void create2DConnection(IDataPointSet dataPointSet, int xIndex, int yIndex, int valIndex) throws IllegalArgumentException {
        int[] indeces = new int[]{xIndex, yIndex};
        this.createConnection(dataPointSet, indeces, valIndex);
    }

    public void create3DConnection(IHistogram3D hist) throws IllegalArgumentException {
        this.create3DConnection(hist, 0, 1, 2);
    }

    public void create3DConnection(IHistogram3D hist, int xIndex, int yIndex, int zIndex) throws IllegalArgumentException {
        if (xIndex * yIndex * zIndex != 0 || xIndex + yIndex + zIndex != 3) {
            throw new IllegalArgumentException("Illegal values for the axis " + xIndex + " " + yIndex + " " + zIndex);
        }
        if (xIndex > 2 || yIndex > 2 || zIndex > 2) {
            throw new IllegalArgumentException("Illegal values for the axis " + xIndex + " " + yIndex + " " + zIndex);
        }
        this.dataDescription = "IHistogram3D " + ((IManagedObject)hist).name();
        this.prepareConnections(3, 0);
        double[] vals = new double[3];
        int xBins = hist.xAxis().bins();
        int yBins = hist.yAxis().bins();
        int zBins = hist.zAxis().bins();
        for (int i = 0; i < xBins; ++i) {
            for (int j = 0; j < yBins; ++j) {
                for (int k = 0; k < zBins; ++k) {
                    double e = hist.binError(i, j, k);
                    double v = hist.binHeight(i, j, k);
                    vals[xIndex] = hist.binMeanX(i, j, k);
                    vals[yIndex] = hist.binMeanY(i, j, k);
                    vals[zIndex] = hist.binMeanZ(i, j, k);
                    if (e == 0.0) continue;
                    this.fillConnections(v, e, e, vals);
                }
            }
        }
        this.rangeSet[xIndex].includeAll();
        this.rangeSet[yIndex].includeAll();
        this.rangeSet[zIndex].includeAll();
    }

    public void create3DConnection(ICloud3D cloud) throws IllegalArgumentException {
        this.create3DConnection(cloud, 0, 1, 2);
    }

    public void create3DConnection(ICloud3D cloud, int xIndex, int yIndex, int zIndex) throws IllegalArgumentException {
        if (cloud.isConverted()) {
            throw new IllegalArgumentException("This ICloud is converted. You should explicitely fit the IHistogram inside the ICloud, if that is what you want to do");
        }
        if (xIndex * yIndex * zIndex != 0 || xIndex + yIndex + zIndex != 3) {
            throw new IllegalArgumentException("Illegal values for the axis " + xIndex + " " + yIndex + " " + zIndex);
        }
        if (xIndex > 2 || yIndex > 2 || zIndex > 2) {
            throw new IllegalArgumentException("Illegal values for the axis " + xIndex + " " + yIndex + " " + zIndex);
        }
        this.dataDescription = "ICloud3D " + ((IManagedObject)cloud).name();
        this.prepareConnections(3, 1);
        double[] vals = new double[3];
        int entries = cloud.entries();
        for (int i = 0; i < entries; ++i) {
            vals[xIndex] = cloud.valueX(i);
            vals[yIndex] = cloud.valueY(i);
            vals[zIndex] = cloud.valueZ(i);
            this.fillConnections(0.0, 0.0, 0.0, vals);
        }
        this.rangeSet[xIndex].includeAll();
        this.rangeSet[yIndex].includeAll();
        this.rangeSet[zIndex].includeAll();
    }

    public void create3DConnection(IDataPointSet dataPointSet, int xIndex, int yIndex, int zIndex, int valIndex) throws IllegalArgumentException {
        int[] indeces = new int[]{xIndex, yIndex, zIndex};
        this.createConnection(dataPointSet, indeces, valIndex);
    }

    public void createConnection(IDataPointSet dataPointSet, int[] indeces, int valIndex) throws IllegalArgumentException {
        int i;
        int dimension = indeces.length;
        for (int i2 = 0; i2 < dimension; ++i2) {
            if (indeces[i2] > dataPointSet.dimension() - 1) {
                throw new IllegalArgumentException("Variable index " + indeces[i2] + " cannot be greater than the dataPointSet dimension " + dataPointSet.dimension());
            }
            if (indeces[i2] == valIndex) {
                throw new IllegalArgumentException("Variable index cannot be the same as the value index " + valIndex);
            }
            for (int j = i2 + 1; j < dimension; ++j) {
                if (indeces[i2] != indeces[j]) continue;
                throw new IllegalArgumentException("Two indeces are identical! Impossible configuration");
            }
        }
        this.dataDescription = "IDataPointSet " + ((IManagedObject)dataPointSet).name();
        this.prepareConnections(dimension, 0);
        double[] vals = new double[dimension];
        for (i = 0; i < dataPointSet.size(); ++i) {
            double v = dataPointSet.point(i).coordinate(valIndex).value();
            double ep = dataPointSet.point(i).coordinate(valIndex).errorPlus();
            double em = dataPointSet.point(i).coordinate(valIndex).errorMinus();
            if (ep == 0.0 && em == 0.0) continue;
            for (int j = 0; j < dimension; ++j) {
                vals[j] = dataPointSet.point(i).coordinate(indeces[j]).value();
            }
            this.fillConnections(v, ep, em, vals);
        }
        for (i = 0; i < dimension; ++i) {
            this.rangeSet[i].includeAll();
        }
    }

    public void createConnection(ITuple tuple, IEvaluator[] evals) {
        int i;
        int dimension = evals.length;
        this.dataDescription = "ITuple " + ((IManagedObject)tuple).name();
        this.prepareConnections(dimension, 1);
        for (int i2 = 0; i2 < dimension; ++i2) {
            evals[i2].initialize(tuple);
        }
        double[] upperEdges = new double[dimension];
        double[] lowerEdges = new double[dimension];
        for (int i3 = 0; i3 < dimension; ++i3) {
            lowerEdges[i3] = Double.NaN;
            upperEdges[i3] = Double.NaN;
        }
        double[] vals = new double[dimension];
        tuple.start();
        while (tuple.next()) {
            for (i = 0; i < dimension; ++i) {
                vals[i] = evals[i].evaluateDouble();
                if (Double.isNaN(upperEdges[i]) || vals[i] > upperEdges[i]) {
                    upperEdges[i] = vals[i];
                }
                if (!Double.isNaN(lowerEdges[i]) && !(vals[i] < lowerEdges[i])) continue;
                lowerEdges[i] = vals[i];
            }
            this.fillConnections(0.0, 0.0, 0.0, vals);
        }
        for (i = 0; i < dimension; ++i) {
            this.rangeSet[i].includeAll();
        }
    }

    public void createConnection(ITuple tuple, String[] colNames) {
        int i;
        int dimension = colNames.length;
        this.dataDescription = "ITuple " + ((IManagedObject)tuple).name();
        this.prepareConnections(dimension, 1);
        int[] indeces = new int[dimension];
        for (int i2 = 0; i2 < dimension; ++i2) {
            indeces[i2] = tuple.findColumn(colNames[i2]);
        }
        double[] vals = new double[dimension];
        tuple.start();
        while (tuple.next()) {
            for (i = 0; i < dimension; ++i) {
                vals[i] = tuple.getDouble(indeces[i]);
            }
            this.fillConnections(0.0, 0.0, 0.0, vals);
        }
        for (i = 0; i < dimension; ++i) {
            this.rangeSet[i].includeAll();
        }
    }

    public IRangeSet range(int index) throws IllegalArgumentException {
        if (this.rangeSet == null) {
            throw new RuntimeException("RangeSet have not been initialized!!");
        }
        if (index < 0) {
            throw new IllegalArgumentException("The index cannot be negative!!");
        }
        if (index > this.rangeSet.length - 1) {
            throw new IllegalArgumentException("Wrong index " + index + ". It exceeds the number of RangeSets " + this.rangeSet.length + ".");
        }
        return this.rangeSet[index];
    }

    public IDevFitDataIterator dataIterator() {
        TupleFactory tupFactory = new TupleFactory(null);
        return new FitDataIterator(tupFactory.createFiltered("", this.tup, new RangeSetFilter(this.rangeSet)));
    }

    public int dimension() {
        return this.dimension;
    }

    public String dataDescription() {
        return this.dataDescription;
    }

    public void reset() {
        this.tup = null;
        this.dimension = -1;
        this.fitType = -1;
        this.rangeSet = null;
    }

    public int fitType() {
        return this.fitType;
    }

    private void prepareConnections(int dimension, int fitType) {
        int i;
        this.reset();
        this.dimension = dimension;
        this.fitType = fitType;
        String tupString = "double value, double error, double minusError";
        for (i = 0; i < dimension; ++i) {
            tupString = tupString + ", double x" + i;
        }
        this.tup = new Tuple("", "", tupString, "");
        this.rangeSet = new RangeSet[dimension];
        for (i = 0; i < dimension; ++i) {
            this.rangeSet[i] = new RangeSet();
        }
    }

    private void fillConnections(double value, double error, double minusError, double[] vals) {
        this.tup.fill(0, value);
        this.tup.fill(1, error);
        this.tup.fill(2, minusError);
        for (int i = 0; i < vals.length; ++i) {
            this.tup.fill(3 + i, vals[i]);
        }
        this.tup.addRow();
    }
}

