/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.sftp;

import com.jcraft.jsch.ChannelSftp;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.filebrowser.FileBrowserEvent;
import jp.advancesoft.chase.filebrowser.FileBrowserParent;
import jp.advancesoft.chase.filebrowser.FileBrowserTree;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import jp.advancesoft.chase.ssh.SshClient;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import jp.advancesoft.chase.ssh.hosts.HostConnector;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.sftp.DirMaker;
import jp.advancesoft.chase.ssh.sftp.FilePropertyViewer;
import jp.advancesoft.chase.ssh.sftp.Renamer;
import jp.advancesoft.chase.ssh.sftp.Sftp;
import jp.advancesoft.chase.ssh.sftp.SftpClientMenuBar;
import jp.advancesoft.chase.ssh.sftp.SftpEvent;
import jp.advancesoft.chase.ssh.sftp.SftpListener;
import org.apache.log4j.Logger;

public class SftpClient
extends InternalFrameChase
implements SshClient,
SftpListener,
FileBrowserParent {
    private static Logger logger = Logger.getLogger(SftpClient.class.getName());
    private FileBrowserTree local;
    private FileBrowserTree remote;
    private HostInfo hostinfo;
    private Sftp sftp;
    private ChannelSftp c;
    private boolean isConnected = false;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);

    public SftpClient() {
        super("sftp client", true, true, true, true, new Dimension(500, 500));
        this.init();
    }

    public SftpClient(HostInfo hostinfo) {
        super("sftp client", true, true, true, true, new Dimension(500, 500));
        this.hostinfo = hostinfo;
        this.init();
        this.connect(hostinfo);
    }

    public int getMode() {
        int ret = 0;
        return ret;
    }

    public void uploadFinished(SftpEvent se) {
        this.reload(0);
    }

    public void downloadFinished(SftpEvent se) {
        this.reload(1);
    }

    public void connect(HostInfo host) {
        this.hostinfo = host;
        logger.debug("connecting to host: " + host.getName());
        this.sftp = new Sftp(host);
        this.sftp.addSftpListener(this);
        this.sftp.connect();
        ((TitledBorder)this.remote.getBorder()).setTitle("connected to host: " + host.getName());
        this.c = this.sftp.getChannelSftp();
        this.remote.setChannelSftp(this.c);
        String initDir = new String();
        initDir = this.sftp.getChannelSftp().pwd();
        this.remote.init(initDir);
        this.setSize(this.getSize().width, this.getSize().height);
        this.isConnected = true;
    }

    public void disconnect() {
        if (this.sftp != null) {
            this.sftp.disconnect();
        }
    }

    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    public HostInfo getHostInfo() {
        return this.hostinfo;
    }

    public Sftp getSftp() {
        return this.sftp;
    }

    public void directoryHasChanged(FileBrowserEvent fbe) {
        FileBrowserTree tmp = (FileBrowserTree)fbe.getSource();
        boolean isremote = tmp.isRemote();
        RemoteFile cur = tmp.getCurrentDir();
        String curdir = new String();
        curdir = cur != null ? cur.getAbsolutePath() : RemoteFile.listRoots()[0].getAbsolutePath();
        if (isremote) {
            logger.debug("remote directory has changed to " + curdir);
            if (this.sftp != null) {
                this.sftp.cd(curdir);
            }
        } else {
            logger.debug("local directory has changed to " + curdir);
            if (this.sftp != null) {
                this.sftp.lcd(curdir);
            }
        }
    }

    public void bootFilePropertyViewer(int mode) {
        RemoteFile[] selectedFiles = this.getSelectedFiles(mode);
        if (selectedFiles != null) {
            FilePropertyViewer filePropertyViewer = new FilePropertyViewer(selectedFiles);
        }
    }

    public void deleteSelectedFiles(int mode) {
        boolean warn = true;
        String ask = this.gp.getProperty("sftp_client_ask_delfile");
        if (ask != null) {
            logger.debug("ask: " + ask);
            if (ask.trim().equals("false")) {
                warn = false;
                logger.debug("deleteing file without warning");
            } else {
                logger.debug("warn");
            }
        } else {
            logger.debug("sftp_client_ask_deflfile not set, using default");
        }
        RemoteFile[] selectedFiles = this.getSelectedFiles(mode);
        if (selectedFiles != null) {
            int res = 0;
            if (warn) {
                String message = "deleting " + selectedFiles.length + " file(s) ... proceed?";
                res = JOptionPane.showInternalConfirmDialog(Desktop.getDesktop(), message);
            }
            if (res == 0) {
                for (int i = 0; i < selectedFiles.length; ++i) {
                    logger.info("deleteing file: " + selectedFiles[i].getAbsolutePath());
                    boolean b2 = selectedFiles[i].delete();
                    if (b2) continue;
                    logger.warn("failed to delete: " + selectedFiles[i].getAbsolutePath());
                }
            }
        }
        this.reload(mode);
    }

    public void mkdir(int mode) {
        logger.debug("running....");
        RemoteFile file = this.getSelectedFile(mode);
        String message = "enter new directory name";
        RemoteFile newdir = this.getNewFile(message, file, "newdir");
        if (newdir == null) {
            logger.info("canceled.");
            return;
        }
        DirMaker dm = new DirMaker(this, mode, newdir);
        new Thread(dm).start();
    }

    public void rename(int mode) {
        RemoteFile file = this.getSelectedFile(mode);
        logger.debug("mode: " + mode + " filename: " + file.getAbsolutePath());
        String message = "enter new file name";
        RemoteFile renameTo = this.getNewFile(message, file, file.getName());
        if (renameTo == null) {
            logger.info("canceled.");
            return;
        }
        Renamer rn = new Renamer(this, mode, file, renameTo);
        new Thread(rn).start();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private RemoteFile getNewFile(String message, RemoteFile file, String init) {
        logger.debug("getting file name....");
        String name = JOptionPane.showInternalInputDialog(Desktop.getDesktop(), message);
        logger.debug("got file name: " + name);
        if (name == null) {
            return null;
        }
        RemoteFile parent = null;
        parent = !file.isDirectory() ? (RemoteFile)file.getParentFile() : new RemoteFile(file.getAbsolutePath(), this.c);
        String newfile = "";
        String fs = file.getSeparator();
        if (parent != null) {
            newfile = parent.getAbsolutePath() + fs;
            newfile = newfile + name;
        }
        return new RemoteFile(newfile, this.c);
    }

    protected void reload(int mode) {
        if (mode == 1) {
            this.local.init();
        } else if (mode == 0) {
            this.remote.init();
        }
    }

    private RemoteFile[] getSelectedFiles(int mode) {
        RemoteFile[] selectedFiles = null;
        if (mode == 1) {
            selectedFiles = this.local.getSelectedFiles();
        } else if (mode == 0) {
            selectedFiles = this.remote.getSelectedFiles();
        } else {
            logger.error("bug ...");
            return null;
        }
        return selectedFiles;
    }

    private RemoteFile getSelectedFile(int mode) {
        return this.getSelectedFiles(mode)[0];
    }

    private void init() {
        this.setJMenuBar(new SftpClientMenuBar(this));
        HostConnector connector = new HostConnector(this);
        JPanel p = this.createBrowsersAndButtons();
        this.getContentPane().add(p);
    }

    private JPanel createBrowsersAndButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel pane = this.createBrowsers();
        JPanel buttons = this.createButtons();
        p.add(pane);
        p.add(buttons);
        return p;
    }

    private JPanel createBrowsers() {
        int os = 0;
        if (!System.getProperty("os.name").trim().toLowerCase().startsWith("windows")) {
            os = 1;
        }
        this.local = new FileBrowserTree(os, System.getProperty("user.home"), (FileBrowserParent)this, 1);
        this.local.setBorder(new TitledBorder("local"));
        this.local.addFileBrowserListener(this);
        this.remote = new FileBrowserTree(1, ".", (FileBrowserParent)this, true, 0);
        this.remote.setBorder(new TitledBorder("(not connected)"));
        this.remote.setRemote(true);
        this.remote.addFileBrowserListener(this);
        JSplitPane split0 = new JSplitPane(0, true, this.local, this.remote);
        split0.setResizeWeight(0.43);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(split0);
        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton upload = new JButton("upload");
        JButton download = new JButton("download");
        p.add(upload);
        p.add(download);
        JButton test = new JButton("test");
        test.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient.this.sftpTest();
            }
        });
        upload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient.this.uploadFiles();
            }
        });
        download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient.this.downloadFiles();
            }
        });
        JButton close = new JButton("close");
        p.add(close);
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient.this.dispose();
            }
        });
        return p;
    }

    private void sftpTest() {
        String result;
        if (this.c != null) {
            result = JOptionPane.showInputDialog("enter dir.");
            if (result == null || result.trim().length() == 0) {
                return;
            }
        } else {
            logger.error("must be connected to perform test.");
            return;
        }
        RemoteFile file = new RemoteFile(result, this.c);
        file.mkdirs();
    }

    public void dispose() {
        this.disconnect();
        super.dispose();
    }

    protected void uploadFiles() {
        RemoteFile[] localFiles = this.local.getSelectedFiles();
        if (localFiles != null) {
            for (int i = 0; i < localFiles.length; ++i) {
                logger.debug("selected file: " + localFiles[i].getAbsolutePath());
            }
        }
        if (this.sftp == null) {
            logger.info("not connected");
            return;
        }
        this.sftp.upload(localFiles, this.remote.getCurrentDir());
    }

    protected void downloadFiles() {
        RemoteFile[] remoteFiles = this.remote.getSelectedFiles();
        if (remoteFiles != null) {
            for (int i = 0; i < remoteFiles.length; ++i) {
                logger.debug("selected file: " + remoteFiles[i].getAbsolutePath());
            }
        }
        if (this.sftp == null) {
            logger.info("not connected");
            return;
        }
        this.sftp.download(remoteFiles, this.local.getCurrentDir());
    }

    private void test() {
        RemoteFile local = new RemoteFile(System.getProperty("user.home"));
        RemoteFile[] locals = (RemoteFile[])local.listFiles();
        if (locals != null) {
            for (int i = 0; i < locals.length; ++i) {
                logger.debug("user.home: " + locals[i].getAbsolutePath());
            }
        }
        if (this.sftp != null) {
            this.sftp.test();
        } else {
            logger.info("not connected");
        }
    }
}

