/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.inputinterface;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.advancesoft.chase.inputinterface.DataManager;
import org.apache.log4j.Logger;

class EntryTokenizer {
    private Logger logger;
    private boolean table = false;
    private String token = new String();
    private int numCols;
    private boolean wid = true;
    private String tokenKind = DataManager.entry;

    public EntryTokenizer(String token, String tokenKind) {
        this.token = token;
        this.tokenKind = tokenKind;
    }

    public EntryTokenizer() {
        this.logger = Logger.getLogger(this.getClass());
    }

    public void setTokens(String token, String tokenKind) {
        this.token = token;
        this.tokenKind = tokenKind;
    }

    public void setWSisDelimiter(boolean wid) {
        this.wid = wid;
    }

    public Vector getResults() {
        Vector returnVector = new Vector();
        returnVector = this.tokenKind.equals(DataManager.tableStart) || this.tokenKind.equals(DataManager.tableEntry) ? this.tokenizeTable() : (this.tokenKind.equals(DataManager.entry) ? this.tokenizePrimitive() : (this.tokenKind.equals(DataManager.DEFAULT) ? this.tokenizeDefaults() : (this.tokenKind.equals(DataManager.UNITS) ? this.tokenizeUnits() : null)));
        return returnVector;
    }

    private Vector tokenizeTable() {
        Vector<String[]> tokens = new Vector<String[]>();
        if (this.tokenKind.equals(DataManager.tableStart)) {
            int hashStart = this.token.indexOf(DataManager.HASH);
            this.token = this.token.substring(hashStart + 4, this.token.length()).trim();
            Vector vec = EntryTokenizer.tokenizeSpaceOrDoubleQuote(this.token);
            String[] st = new String[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                st[i] = (String)vec.get(i);
            }
            tokens.addElement(st);
            this.numCols = st.length;
        } else if (this.tokenKind.equals(DataManager.tableEntry)) {
            int i;
            String[] ret = new String[this.numCols];
            Vector vec = EntryTokenizer.tokenizeSpaceOrDoubleQuote(this.token);
            String[] st = new String[vec.size()];
            for (int i2 = 0; i2 < vec.size(); ++i2) {
                st[i2] = (String)vec.get(i2);
            }
            int count = this.numCols;
            if (st.length < this.numCols) {
                count = st.length;
            }
            for (i = 0; i < count; ++i) {
                ret[i] = st[i].toString();
            }
            for (i = count; i < this.numCols; ++i) {
                ret[i] = DataManager.AST;
            }
            tokens.addElement(ret);
        }
        return tokens;
    }

    private Vector tokenizePrimitive() {
        Vector<String[]> tokens = new Vector<String[]>();
        String[] first = this.token.split(",");
        for (int i = 0; i < first.length; ++i) {
            String[] tokenString = new String[3];
            String[] second = first[i].trim().split("=");
            boolean isCellVec = false;
            if (second.length >= 2) {
                tokenString[0] = second[0];
                for (int cell = 0; cell < DataManager.CELL_VECTORS.length; ++cell) {
                    if (!second[0].trim().equals(DataManager.CELL_VECTORS[cell])) continue;
                    isCellVec = true;
                }
                Vector vector = new Vector();
                if (isCellVec) {
                    vector.addElement(second[1]);
                } else if (!this.wid) {
                    vector.addElement(second[1]);
                } else {
                    vector = EntryTokenizer.tokenizeSpaceOrDoubleQuote(second[1]);
                }
                for (int ii = 0; ii < vector.size(); ++ii) {
                    this.logger.debug("tokenized: " + vector.get(ii));
                }
                if (vector.size() == 1) {
                    tokenString[1] = (String)vector.get(0);
                    tokenString[2] = "";
                } else if (vector.size() > 1) {
                    tokenString[1] = (String)vector.get(0);
                    tokenString[2] = (String)vector.get(1);
                } else {
                    tokenString[1] = "";
                    tokenString[2] = "";
                }
            } else {
                tokenString[0] = "";
                tokenString[1] = "";
                tokenString[2] = "";
            }
            tokens.addElement(tokenString);
        }
        return tokens;
    }

    private Vector tokenizeUnits() {
        Vector<String[]> tokens = new Vector<String[]>();
        int hashStart = this.token.indexOf(DataManager.HASH);
        this.token = this.token.substring(hashStart + 6, this.token.length()).trim();
        String[] st = this.token.split("\\s+");
        tokens.addElement(st);
        return tokens;
    }

    private Vector tokenizeDefaults() {
        Vector<String[]> tokens = new Vector<String[]>();
        int hashStart = this.token.indexOf(DataManager.HASH);
        this.token = this.token.substring(hashStart + 9, this.token.length()).trim();
        String[] st = this.token.split(",");
        String[] st2 = new String[st.length];
        for (int i = 0; i < st.length; ++i) {
            st2[i] = st[i].trim();
        }
        tokens.addElement(st2);
        return tokens;
    }

    static Vector tokenizeSpaceOrDoubleQuote(String string) {
        int i;
        String substring;
        String[] indeces;
        int i2;
        string = string.trim();
        String SPACE = "[\\s]+";
        char QUOTE = '\"';
        String IN_QUOTE = "\".+\"";
        boolean inQuote = false;
        boolean inToken = true;
        String tokenString = "";
        Vector<String> tokenVector = new Vector<String>();
        String separator = SPACE;
        Vector<String[]> quoteVector = new Vector<String[]>();
        Vector<String[]> normalVector = new Vector<String[]>();
        Pattern pattern = Pattern.compile(IN_QUOTE);
        Matcher matcher = pattern.matcher(string);
        String quoteStart = "0";
        String normalStart = "0";
        String quoteEnd = "0";
        String normalEnd = "0";
        for (int i3 = 0; i3 < string.length(); ++i3) {
            if (string.charAt(i3) != QUOTE) continue;
            if (!inQuote) {
                quoteStart = String.valueOf(i3);
                normalEnd = String.valueOf(i3);
                if (Integer.parseInt(normalEnd) - Integer.parseInt(normalStart) > 0) {
                    String[] normal = new String[]{normalStart, normalEnd};
                    normalVector.addElement(normal);
                }
            } else {
                quoteEnd = String.valueOf(i3 + 1);
                normalStart = String.valueOf(i3 + 1);
                String[] quote = new String[]{quoteStart, quoteEnd};
                quoteVector.addElement(quote);
            }
            inQuote = !inQuote;
        }
        normalEnd = String.valueOf(string.length());
        String[] normal = new String[]{normalStart, normalEnd};
        normalVector.addElement(normal);
        Vector<String> map = new Vector<String>();
        Vector<String> substringVector = new Vector<String>();
        Vector<Boolean> isQuote = new Vector<Boolean>();
        for (i2 = 0; i2 < normalVector.size(); ++i2) {
            indeces = (String[])normalVector.get(i2);
            substring = string.substring(Integer.parseInt(indeces[0]), Integer.parseInt(indeces[1])).trim();
            if (substring.length() <= 0) continue;
            substringVector.addElement(substring);
            map.addElement(indeces[0]);
            isQuote.addElement(new Boolean(false));
        }
        for (i2 = 0; i2 < quoteVector.size(); ++i2) {
            indeces = (String[])quoteVector.get(i2);
            substring = string.substring(Integer.parseInt(indeces[0]), Integer.parseInt(indeces[1])).trim();
            if (substring.length() <= 0) continue;
            substringVector.addElement(substring);
            map.addElement(indeces[0]);
            isQuote.addElement(new Boolean(true));
        }
        String[] retString = new String[substringVector.size()];
        String[] mapString = new String[map.size()];
        Boolean[] isQuoteBoolean = new Boolean[isQuote.size()];
        for (i = 0; i < retString.length; ++i) {
            retString[i] = (String)substringVector.get(i);
            mapString[i] = (String)map.get(i);
            isQuoteBoolean[i] = (Boolean)isQuote.get(i);
        }
        for (i = 0; i < mapString.length - 1; ++i) {
            for (int j = i + 1; j < mapString.length; ++j) {
                Boolean bj;
                String tmpj;
                int ii = Integer.parseInt(mapString[i]);
                int jj = Integer.parseInt(mapString[j]);
                if (jj >= ii) continue;
                String tmpi = mapString[i];
                mapString[i] = tmpj = mapString[j];
                mapString[j] = tmpi;
                tmpi = retString[i];
                retString[i] = tmpj = retString[j];
                retString[j] = tmpi;
                Boolean bi = isQuoteBoolean[i];
                isQuoteBoolean[i] = bj = isQuoteBoolean[j];
                isQuoteBoolean[j] = bi;
            }
        }
        for (i = 0; i < retString.length; ++i) {
            if (isQuoteBoolean[i].booleanValue()) {
                tokenVector.addElement(retString[i]);
                continue;
            }
            String[] split = retString[i].split("\\s+");
            for (int j = 0; j < split.length; ++j) {
                tokenVector.addElement(split[j]);
            }
        }
        return tokenVector;
    }
}

