/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.advancesoft.chase.common.ChaseFileChooser;
import jp.advancesoft.chase.common.ImageFilter;
import jp.advancesoft.chase.graph.GraphPanel;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import say.swing.JFontChooser;

public class PropertyEditor
extends InternalFrameChase {
    private int width = 512;
    private int height = 512;
    private Object pane;
    private int type;
    private int istart;
    private String title = null;
    private String xlabel = "x";
    private String ylabel = "y";
    private String plottitle = null;
    private String[] legendtext;
    private String[] plotrangetype;
    private String[] stranchorpos = new String[]{"south", "north", "east", "west"};
    private String[] strplottype = new String[]{"lines", "shapes", "lines and shapes"};
    private String[] plotnumber = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private boolean btitle = true;
    private boolean bxlabel = true;
    private boolean bylabel = true;
    private boolean blegend = false;
    private boolean bantialias = false;
    private Font titlefont = new Font("Helvetica", 0, 12);
    private Font legendfont = new Font("Helvetica", 0, 10);
    private Font xaxisfont = new Font("Helvetica", 0, 10);
    private Font yaxisfont = new Font("Helvetica", 0, 10);
    private Font xaxisticfont = new Font("Helvetica", 0, 10);
    private Font yaxisticfont = new Font("Helvetica", 0, 10);
    private Color chartcolor;
    private Color plotcolor;
    private GraphPanel parent;
    private Container cont;
    private JTabbedPane tab;
    private JTabbedPane tabaxis;
    private Font textanfont;
    private String textantext;
    private double textanposx;
    private double textanposy;
    private double textanrotation;
    private int textanmode;
    private String imageFileName;
    private double imageScale;
    private double imagePosX;
    private double imagePosY;
    private boolean bpointerAnnotation;
    private double pointerAnnotationX;
    private double pointerAnnotationY;
    private double pointerAnnotationRot;
    private double pointerAnnotationBase;
    private String pointerAnnotationLabel;
    private Font pointerAnnotationFont;
    private double pointerAnnotationOffset;
    private int[] selectedSeries;
    private int NumSeries;
    private boolean[] bplotdefault;
    private int[] plottype;
    private int[] linetype;
    private int[] shapetype;
    private float[] linewidth;
    private double[] shapesize;
    private Color[] seriescolor;
    private JCheckBox cblegend;
    private JCheckBox cbantialias;
    private JCheckBox cbplottitle;
    private JComboBox cmboxlegend;
    private JComboBox comboanchor;
    private JTextField talegend;
    private JTextField taplottitle;
    private int iaxis;
    private JTabbedPane tpaxis;
    private JPanel[] paxis = new JPanel[2];
    private JTextField[] taaxislabel = new JTextField[2];
    private JButton[] btnaxisfont = new JButton[2];
    private JTextField[] tatics = new JTextField[2];
    private JCheckBox[] cbgrid = new JCheckBox[2];
    private JCheckBox[] cblog = new JCheckBox[2];
    private JComboBox[] combotics = new JComboBox[2];
    private JTextField[] taticunits = new JTextField[2];
    private JButton[] btnticfont = new JButton[2];
    private String[] range;
    private JComboBox[] comborange = new JComboBox[2];
    private JTextField[] tarangemin = new JTextField[2];
    private JTextField[] tarangemax = new JTextField[2];
    private String[] strtics = new String[]{"auto", "integer", "real"};
    private String[] strrange = new String[]{"auto", "manual"};
    private JButton btntitlefont;
    private JButton btnlegendfont;
    private JButton btnchartcolor;
    private JButton btnplotcolor;
    private JCheckBox cbapplytoall;
    private JComboBox comboplottype;
    private JComboBox comboplotrangetype;
    private JList list;
    private DefaultListModel listModel;
    private JScrollPane scrPane;
    private JComboBox comboplotlinetype;
    private JComboBox comboplotshapetype;
    private JTextField tfplotlinewidth;
    private JTextField tfplotshapesize;
    private JButton btnplotlinecolor;
    private JButton btnplotshapecolor;
    private JComboBox combotextannotation;
    private JTextField tftextannotation;
    private JButton btntextannotation;
    private JTextField tftextannotationposx;
    private JTextField tftextannotationposy;
    private JTextField tftextannotationrotation;
    private JButton btnimageselect;
    private JTextField tfimagescale;
    private JTextField tfimageposx;
    private JTextField tfimageposy;
    private JCheckBox cbptan;
    private JTextField tfptanposx;
    private JTextField tfptanposy;
    private JTextField tfptanrotate;
    private JTextField tfptanbase;
    private JTextField tfptanlabel;
    private JButton btnptanlabelfont;
    private JTextField tfptanlabeloffset;
    private int Ndata;

    public PropertyEditor(GraphPanel parent) {
        super("Property editor", true, true, true, true, new Dimension(512, 512), 3);
        this.parent = parent;
    }

    public void createPropertyPanel() {
        this.setSize(this.width, this.height);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.tab = new JTabbedPane();
        this.tab.add("general", this.createGeneralPanel());
        if (this.type == 0) {
            this.tab.add("axis", this.createAxisPanel());
        }
        this.tab.add("bg-color", this.createBGColorPanel());
        if (this.type == 0) {
            this.tab.add("plot", this.createPlotPanel());
            this.tab.add("annotations", this.createAnnotationPanel());
        }
        this.cont.add(this.tab);
        this.cont.add(this.createButtonPanel());
        this.pane = this;
        this.setVisible(false);
    }

    public void display() {
        this.setVisible(true);
    }

    public void loadFromGraphPanel() {
        this.type = this.parent.getType();
        this.xlabel = this.parent.getXlabel();
        this.ylabel = this.parent.getYlabel();
        this.plottitle = this.parent.getPlotTitle();
        this.blegend = this.parent.getDrawLegendOrNot();
        this.bantialias = this.parent.getAntiAlias();
        this.legendtext = this.parent.getLegendText();
        this.legendfont = this.parent.getLegendFont();
        this.chartcolor = this.parent.getChartColor();
        this.plotcolor = this.parent.getPlotColor();
        this.NumSeries = this.parent.getNumSeries();
        this.bplotdefault = this.parent.getPlotDefault();
        this.plottype = this.parent.getPlotType();
        this.linetype = this.parent.getLineType();
        this.shapetype = this.parent.getShapeType();
        this.linewidth = this.parent.getLineWidth();
        this.shapesize = this.parent.getShapeSize();
        this.seriescolor = this.parent.getSeriesColor();
        this.textanfont = this.parent.getTextAnnotationFont();
        this.textantext = this.parent.getTextAnnotationText();
        this.textanposx = this.parent.getTextAnnotationPosX();
        this.textanposy = this.parent.getTextAnnotationPosY();
        this.textanrotation = this.parent.getTextAnnotationRotAngle();
        this.textanmode = this.parent.getTextAnnotationMode();
        this.imageFileName = this.parent.getImageFileName();
        this.imageScale = this.parent.getImageScale();
        this.imagePosX = this.parent.getImagePosX();
        this.imagePosY = this.parent.getImagePosY();
        this.bpointerAnnotation = this.parent.getPointerAnnotation();
        this.pointerAnnotationX = this.parent.getPointerAnnotationX();
        this.pointerAnnotationY = this.parent.getPointerAnnotationY();
        this.pointerAnnotationRot = this.parent.getPointerAnnotationRot();
        this.pointerAnnotationBase = this.parent.getPointerAnnotationBase();
        this.pointerAnnotationLabel = this.parent.getPointerAnnotationLabel();
        this.pointerAnnotationFont = this.parent.getPointerAnnotationFont();
        this.pointerAnnotationOffset = this.parent.getPointerAnnotationOffset();
    }

    private JPanel createGeneralPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        JPanel ptitle = new JPanel();
        ptitle.setLayout(new BoxLayout(ptitle, 0));
        this.cbplottitle = new JCheckBox("show title");
        this.taplottitle = new JTextField(25);
        this.btntitlefont = new JButton("select font");
        this.btitle = this.plottitle != null;
        this.cbplottitle.setSelected(this.btitle);
        this.taplottitle.setText(this.plottitle);
        ptitle.add(this.cbplottitle);
        ptitle.add(this.taplottitle);
        ptitle.add(this.btntitlefont);
        ptitle.setBorder(new TitledBorder("title"));
        p.add(ptitle);
        JPanel plegend = new JPanel();
        plegend.setLayout(new BoxLayout(plegend, 0));
        this.cblegend = new JCheckBox("show legend");
        this.cblegend.setSelected(this.blegend);
        this.istart = 1 - this.type;
        String[] range = new String[this.legendtext.length - this.istart];
        for (int i = this.istart; i < this.legendtext.length; ++i) {
            range[i - this.istart] = this.legendtext[i];
        }
        this.cmboxlegend = new JComboBox<String>(range);
        this.talegend = new JTextField(13);
        this.talegend.setText(this.legendtext[this.cmboxlegend.getSelectedIndex() + this.istart]);
        this.legendtext[this.cmboxlegend.getSelectedIndex() + this.istart] = this.talegend.getText();
        JPanel panchor = new JPanel();
        this.comboanchor = new JComboBox<String>(this.stranchorpos);
        panchor.setBorder(new TitledBorder("anchor position"));
        panchor.add(this.comboanchor);
        this.btnlegendfont = new JButton("select font");
        plegend.add(this.cblegend);
        plegend.add(this.cmboxlegend);
        plegend.add(this.talegend);
        plegend.add(this.comboanchor);
        plegend.add(this.btnlegendfont);
        plegend.setBorder(new TitledBorder("legend"));
        p.add(plegend);
        JPanel panti = new JPanel();
        panti.setLayout(new BoxLayout(panti, 0));
        this.cbantialias = new JCheckBox("anti-aliasing");
        this.cbantialias.setSelected(this.bantialias);
        panti.add(this.cbantialias);
        p.add(panti);
        this.cmboxlegend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.talegend.setText(PropertyEditor.this.legendtext[PropertyEditor.this.cmboxlegend.getSelectedIndex() + PropertyEditor.this.istart]);
            }
        });
        this.talegend.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    ((PropertyEditor)PropertyEditor.this).legendtext[((PropertyEditor)PropertyEditor.this).cmboxlegend.getSelectedIndex() + ((PropertyEditor)PropertyEditor.this).istart] = PropertyEditor.this.talegend.getText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btntitlefont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.titlefont = PropertyEditor.this.chooseFont(PropertyEditor.this.titlefont);
                PropertyEditor.this.btntitlefont.setFont(PropertyEditor.this.titlefont);
            }
        });
        this.btnlegendfont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.legendfont = PropertyEditor.this.chooseFont(PropertyEditor.this.legendfont);
                PropertyEditor.this.btnlegendfont.setFont(PropertyEditor.this.legendfont);
            }
        });
        return p;
    }

    private Font chooseFont(Font initialfont) {
        JFontChooser fontChooser = new JFontChooser();
        fontChooser.setSelectedFont(initialfont);
        int result = fontChooser.showDialog(this);
        if (result == 0) {
            Font choosedFont = fontChooser.getSelectedFont();
            return choosedFont;
        }
        Font choosedFont = new Font("Helvetica", 0, 12);
        return choosedFont;
    }

    private JTabbedPane createAxisPanel() {
        this.iaxis = 0;
        while (this.iaxis < 2) {
            this.paxis[this.iaxis] = new JPanel();
            this.paxis[this.iaxis].setLayout(new FlowLayout());
            JPanel plabel = new JPanel();
            plabel.setLayout(new BoxLayout(plabel, 0));
            this.taaxislabel[this.iaxis] = new JTextField(25);
            if (this.iaxis == 0) {
                this.taaxislabel[this.iaxis].setText(this.xlabel);
            } else {
                this.taaxislabel[this.iaxis].setText(this.ylabel);
            }
            this.btnaxisfont[this.iaxis] = new JButton("select font");
            plabel.setBorder(new TitledBorder("axis label"));
            plabel.add(this.taaxislabel[this.iaxis]);
            plabel.add(this.btnaxisfont[this.iaxis]);
            this.paxis[this.iaxis].add(plabel);
            JPanel ptics = new JPanel();
            ptics.setLayout(new BoxLayout(ptics, 0));
            this.combotics[this.iaxis] = new JComboBox<String>(this.strtics);
            this.combotics[this.iaxis].setBorder(new TitledBorder("tic mode"));
            this.taticunits[this.iaxis] = new JTextField(20);
            JPanel ptftic = new JPanel();
            ptftic.setBorder(new TitledBorder("tick units"));
            ptftic.add(this.taticunits[this.iaxis]);
            this.btnticfont[this.iaxis] = new JButton("select font");
            ptics.setBorder(new TitledBorder("tics"));
            ptics.add(this.combotics[this.iaxis]);
            ptics.add(ptftic);
            ptics.add(this.btnticfont[this.iaxis]);
            this.paxis[this.iaxis].add(ptics);
            JPanel prange = new JPanel();
            prange.setLayout(new BoxLayout(prange, 0));
            this.comborange[this.iaxis] = new JComboBox<String>(this.strrange);
            this.comborange[this.iaxis].setBorder(new TitledBorder("range mode"));
            this.tarangemin[this.iaxis] = new JTextField(15);
            this.tarangemax[this.iaxis] = new JTextField(15);
            JPanel ptfmin = new JPanel();
            ptfmin.setBorder(new TitledBorder("min value"));
            ptfmin.add(this.tarangemin[this.iaxis]);
            JPanel ptfmax = new JPanel();
            ptfmax.setBorder(new TitledBorder("max value"));
            ptfmax.add(this.tarangemax[this.iaxis]);
            prange.setBorder(new TitledBorder("range"));
            prange.add(this.comborange[this.iaxis]);
            prange.add(ptfmin);
            prange.add(ptfmax);
            this.paxis[this.iaxis].add(prange);
            JPanel ploggrid = new JPanel();
            ploggrid.setLayout(new BoxLayout(ploggrid, 0));
            this.cblog[this.iaxis] = new JCheckBox("log scale");
            this.cbgrid[this.iaxis] = new JCheckBox("do not show grid");
            ploggrid.add(this.cblog[this.iaxis]);
            ploggrid.add(this.cbgrid[this.iaxis]);
            ploggrid.setBorder(new TitledBorder("other axis-related properties"));
            this.paxis[this.iaxis].add(ploggrid);
            if (this.iaxis == 0) {
                this.btnaxisfont[this.iaxis].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PropertyEditor.this.xaxisfont = PropertyEditor.this.chooseFont(PropertyEditor.this.xaxisfont);
                        PropertyEditor.this.btnaxisfont[0].setFont(PropertyEditor.this.xaxisfont);
                    }
                });
                this.btnticfont[this.iaxis].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PropertyEditor.this.xaxisticfont = PropertyEditor.this.chooseFont(PropertyEditor.this.xaxisticfont);
                        PropertyEditor.this.btnticfont[0].setFont(PropertyEditor.this.xaxisticfont);
                    }
                });
            } else if (this.iaxis == 1) {
                this.btnaxisfont[this.iaxis].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PropertyEditor.this.yaxisfont = PropertyEditor.this.chooseFont(PropertyEditor.this.yaxisfont);
                        PropertyEditor.this.btnaxisfont[1].setFont(PropertyEditor.this.yaxisfont);
                    }
                });
                this.btnticfont[this.iaxis].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PropertyEditor.this.yaxisticfont = PropertyEditor.this.chooseFont(PropertyEditor.this.yaxisticfont);
                        PropertyEditor.this.btnticfont[1].setFont(PropertyEditor.this.yaxisticfont);
                    }
                });
            }
            ++this.iaxis;
        }
        this.combotics[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PropertyEditor.this.combotics[0].getSelectedItem().equals("auto")) {
                    PropertyEditor.this.taticunits[0].setEditable(false);
                } else {
                    PropertyEditor.this.taticunits[0].setEditable(true);
                }
            }
        });
        this.combotics[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PropertyEditor.this.combotics[1].getSelectedItem().equals("auto")) {
                    PropertyEditor.this.taticunits[1].setEditable(false);
                } else {
                    PropertyEditor.this.taticunits[1].setEditable(true);
                }
            }
        });
        this.combotics[0].setSelectedIndex(0);
        this.combotics[1].setSelectedIndex(0);
        this.comborange[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PropertyEditor.this.comborange[0].getSelectedItem().equals("auto")) {
                    PropertyEditor.this.tarangemin[0].setEditable(false);
                    PropertyEditor.this.tarangemax[0].setEditable(false);
                } else {
                    PropertyEditor.this.tarangemin[0].setEditable(true);
                    PropertyEditor.this.tarangemax[0].setEditable(true);
                }
            }
        });
        this.comborange[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PropertyEditor.this.comborange[1].getSelectedItem().equals("auto")) {
                    PropertyEditor.this.tarangemin[1].setEditable(false);
                    PropertyEditor.this.tarangemax[1].setEditable(false);
                } else {
                    PropertyEditor.this.tarangemin[1].setEditable(true);
                    PropertyEditor.this.tarangemax[1].setEditable(true);
                }
            }
        });
        this.comborange[0].setSelectedIndex(0);
        this.comborange[1].setSelectedIndex(0);
        this.tpaxis = new JTabbedPane();
        this.tpaxis.add((Component)this.paxis[0], "x-axis");
        this.tpaxis.add((Component)this.paxis[1], "y-axis");
        return this.tpaxis;
    }

    private JPanel createBGColorPanel() {
        JPanel p = new JPanel();
        JPanel pbtncolor = new JPanel();
        pbtncolor.setLayout(new BoxLayout(pbtncolor, 0));
        pbtncolor.setBorder(new TitledBorder("back ground color"));
        this.btnchartcolor = new JButton("select chart color");
        this.btnchartcolor.setBackground(this.chartcolor);
        this.btnplotcolor = new JButton("select plot color");
        this.btnplotcolor.setBackground(this.plotcolor);
        pbtncolor.add(this.btnchartcolor);
        pbtncolor.add(this.btnplotcolor);
        p.add(pbtncolor);
        this.btnchartcolor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PropertyEditor.this.cont, "Choose", PropertyEditor.this.chartcolor);
                if (color != null) {
                    PropertyEditor.this.chartcolor = color;
                    PropertyEditor.this.btnchartcolor.setBackground(PropertyEditor.this.chartcolor);
                }
            }
        });
        this.btnplotcolor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PropertyEditor.this.cont, "Choose", PropertyEditor.this.plotcolor);
                if (color != null) {
                    PropertyEditor.this.plotcolor = color;
                    PropertyEditor.this.btnplotcolor.setBackground(PropertyEditor.this.plotcolor);
                }
            }
        });
        return p;
    }

    private JPanel createPlotPanel() {
        int i;
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        JPanel prangetype = new JPanel();
        prangetype.setLayout(new BoxLayout(prangetype, 0));
        prangetype.setPreferredSize(new Dimension(500, 150));
        this.range = new String[this.NumSeries];
        for (i = 1; i < this.NumSeries + 1; ++i) {
            this.range[i - 1] = this.legendtext[i];
        }
        this.listModel = new DefaultListModel();
        for (i = 0; i < this.NumSeries; ++i) {
            this.listModel.addElement(this.range[i]);
        }
        this.selectedSeries = new int[this.listModel.getSize()];
        this.comboplotrangetype = new JComboBox<String>(this.range);
        this.comboplotrangetype.setBorder(new TitledBorder("edit properties for: "));
        this.list = new JList<String>(this.range);
        this.list.setSelectionMode(2);
        this.list.setSelectedIndex(0);
        this.scrPane = new JScrollPane(this.list);
        this.scrPane.setPreferredSize(new Dimension(200, 150));
        this.scrPane.setBorder(new TitledBorder("series"));
        this.cbapplytoall = new JCheckBox("apply changes to all series");
        this.selectedSeries = this.list.getSelectedIndices();
        prangetype.add(this.scrPane);
        prangetype.add(this.cbapplytoall);
        prangetype.add(Box.createHorizontalStrut(0));
        p.add(prangetype);
        JPanel pplottype = new JPanel();
        pplottype.setLayout(new BoxLayout(pplottype, 0));
        pplottype.setPreferredSize(new Dimension(500, 60));
        this.comboplottype = new JComboBox<String>(this.strplottype);
        this.comboplottype.setBorder(new TitledBorder("plot type"));
        this.btnplotlinecolor = new JButton("select");
        JPanel pbtnline = new JPanel();
        pbtnline.setBorder(new TitledBorder("color"));
        pbtnline.add(this.btnplotlinecolor);
        pplottype.add(this.comboplottype);
        pplottype.add(pbtnline);
        p.add(pplottype);
        JPanel plineproperties = new JPanel();
        this.comboplotlinetype = new JComboBox<String>(this.plotnumber);
        this.comboplotlinetype.setBorder(new TitledBorder("line type"));
        this.tfplotlinewidth = new JTextField(10);
        JPanel ptfline = new JPanel();
        ptfline.setBorder(new TitledBorder("line width"));
        ptfline.add(this.tfplotlinewidth);
        plineproperties.setLayout(new GridLayout(1, 3));
        plineproperties.setPreferredSize(new Dimension(500, 80));
        plineproperties.setBorder(new TitledBorder("line properties"));
        plineproperties.add(this.comboplotlinetype);
        plineproperties.add(ptfline);
        p.add(plineproperties);
        JPanel pshapeproperties = new JPanel();
        this.comboplotshapetype = new JComboBox<String>(this.plotnumber);
        this.comboplotshapetype.setBorder(new TitledBorder("shape type"));
        this.tfplotshapesize = new JTextField(10);
        JPanel ptf = new JPanel();
        ptf.setBorder(new TitledBorder("shape size"));
        ptf.add(this.tfplotshapesize);
        pshapeproperties.setLayout(new GridLayout(1, 3));
        pshapeproperties.setPreferredSize(new Dimension(500, 80));
        pshapeproperties.setBorder(new TitledBorder("shape properties"));
        pshapeproperties.add(this.comboplotshapetype);
        pshapeproperties.add(ptf);
        p.add(pshapeproperties);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PropertyEditor.this.callSwitchPlotAttributes();
            }
        });
        this.cbapplytoall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PropertyEditor.this.cbapplytoall.isSelected()) {
                    for (int i = 0; i < PropertyEditor.this.NumSeries; ++i) {
                        PropertyEditor.this.setPlotProperties(i);
                    }
                }
            }
        });
        this.comboplottype.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PropertyEditor.this.cbapplytoall.isSelected()) {
                    for (int i = 0; i < PropertyEditor.this.selectedSeries.length; ++i) {
                        ((PropertyEditor)PropertyEditor.this).plottype[((PropertyEditor)PropertyEditor.this).selectedSeries[i]] = PropertyEditor.this.comboplottype.getSelectedIndex();
                    }
                } else {
                    for (int i = 0; i < PropertyEditor.this.NumSeries; ++i) {
                        ((PropertyEditor)PropertyEditor.this).plottype[i] = PropertyEditor.this.comboplottype.getSelectedIndex();
                    }
                }
            }
        });
        this.btnplotlinecolor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PropertyEditor.this.cont, "Choose", PropertyEditor.this.seriescolor[PropertyEditor.this.selectedSeries[0]]);
                if (color != null) {
                    if (!PropertyEditor.this.cbapplytoall.isSelected()) {
                        for (int i = 0; i < PropertyEditor.this.selectedSeries.length; ++i) {
                            int icolor = PropertyEditor.this.selectedSeries[i];
                            ((PropertyEditor)PropertyEditor.this).seriescolor[icolor] = color;
                        }
                    } else {
                        for (int i = 0; i < PropertyEditor.this.NumSeries; ++i) {
                            ((PropertyEditor)PropertyEditor.this).seriescolor[i] = color;
                        }
                    }
                    PropertyEditor.this.btnplotlinecolor.setBackground(color);
                }
            }
        });
        this.comboplotlinetype.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PropertyEditor.this.cbapplytoall.isSelected()) {
                    for (int i = 0; i < PropertyEditor.this.selectedSeries.length; ++i) {
                        ((PropertyEditor)PropertyEditor.this).linetype[((PropertyEditor)PropertyEditor.this).selectedSeries[i]] = PropertyEditor.this.comboplotlinetype.getSelectedIndex();
                    }
                } else {
                    for (int i = 0; i < PropertyEditor.this.NumSeries; ++i) {
                        ((PropertyEditor)PropertyEditor.this).linetype[i] = PropertyEditor.this.comboplotlinetype.getSelectedIndex();
                    }
                }
            }
        });
        this.tfplotlinewidth.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                if (!PropertyEditor.this.cbapplytoall.isSelected()) {
                    try {
                        for (int i = 0; i < PropertyEditor.this.selectedSeries.length; ++i) {
                            ((PropertyEditor)PropertyEditor.this).linewidth[((PropertyEditor)PropertyEditor.this).selectedSeries[i]] = Float.parseFloat(PropertyEditor.this.tfplotlinewidth.getText());
                        }
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        for (int i = 0; i < PropertyEditor.this.NumSeries; ++i) {
                            ((PropertyEditor)PropertyEditor.this).linewidth[i] = Float.parseFloat(PropertyEditor.this.tfplotlinewidth.getText());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.comboplotshapetype.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PropertyEditor.this.cbapplytoall.isSelected()) {
                    for (int i = 0; i < PropertyEditor.this.selectedSeries.length; ++i) {
                        ((PropertyEditor)PropertyEditor.this).shapetype[((PropertyEditor)PropertyEditor.this).selectedSeries[i]] = PropertyEditor.this.comboplotshapetype.getSelectedIndex();
                    }
                } else {
                    for (int i = 0; i < PropertyEditor.this.NumSeries; ++i) {
                        ((PropertyEditor)PropertyEditor.this).shapetype[i] = PropertyEditor.this.comboplotshapetype.getSelectedIndex();
                    }
                }
            }
        });
        this.tfplotshapesize.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                if (!PropertyEditor.this.cbapplytoall.isSelected()) {
                    try {
                        for (int i = 0; i < PropertyEditor.this.selectedSeries.length; ++i) {
                            ((PropertyEditor)PropertyEditor.this).shapesize[((PropertyEditor)PropertyEditor.this).selectedSeries[i]] = Double.parseDouble(PropertyEditor.this.tfplotshapesize.getText());
                        }
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        for (int i = 0; i < PropertyEditor.this.NumSeries; ++i) {
                            ((PropertyEditor)PropertyEditor.this).shapesize[i] = Double.parseDouble(PropertyEditor.this.tfplotshapesize.getText());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.list.setSelectedIndex(0);
        this.callSwitchPlotAttributes();
        return p;
    }

    private JPanel createAnnotationPanel() {
        JPanel p = new JPanel();
        String[] strtextannotation = new String[]{"new", "add", "clear all"};
        p.setLayout(new BoxLayout(p, 1));
        JPanel ptextan = new JPanel();
        ptextan.setLayout(new BoxLayout(ptextan, 1));
        ptextan.setBorder(new TitledBorder("text annotation"));
        JPanel pcomboandpos = new JPanel();
        pcomboandpos.setLayout(new BoxLayout(pcomboandpos, 0));
        JPanel pcombo = new JPanel();
        pcombo.setLayout(new FlowLayout(1));
        this.combotextannotation = new JComboBox<String>(strtextannotation);
        this.combotextannotation.setBorder(new TitledBorder("mode"));
        pcombo.add(this.combotextannotation);
        pcomboandpos.add(pcombo);
        JPanel tfpos = new JPanel();
        JPanel tfx = new JPanel();
        JPanel tfy = new JPanel();
        JPanel tfrot = new JPanel();
        tfx.setBorder(new TitledBorder("position (x)"));
        tfy.setBorder(new TitledBorder("position (y)"));
        tfrot.setBorder(new TitledBorder("rot (degrees)"));
        this.tftextannotationposx = new JTextField(7);
        this.tftextannotationposy = new JTextField(7);
        this.tftextannotationrotation = new JTextField(7);
        tfx.add(this.tftextannotationposx);
        tfy.add(this.tftextannotationposy);
        tfrot.add(this.tftextannotationrotation);
        tfpos.add(tfx);
        tfpos.add(tfy);
        tfpos.add(tfrot);
        pcomboandpos.add(tfpos);
        ptextan.add(pcomboandpos);
        this.tftextannotation = new JTextField(15);
        JPanel ptftext = new JPanel();
        ptftext.setBorder(new TitledBorder("annotation text"));
        ptftext.setLayout(new BoxLayout(ptftext, 0));
        this.btntextannotation = new JButton("select font");
        ptftext.add(this.tftextannotation);
        ptftext.add(this.btntextannotation);
        ptextan.add(ptftext);
        p.add(ptextan);
        JPanel pimagean = new JPanel();
        pimagean.setBorder(new TitledBorder("image annotation"));
        pimagean.setLayout(new BoxLayout(pimagean, 0));
        this.btnimageselect = new JButton("choose image file");
        JPanel pimagepos = new JPanel();
        pimagepos.setLayout(new BoxLayout(pimagepos, 0));
        this.tfimagescale = new JTextField(7);
        JPanel pimscale = new JPanel();
        pimscale.setBorder(new TitledBorder("scale"));
        pimscale.add(this.tfimagescale);
        this.tfimageposx = new JTextField(7);
        JPanel pimposx = new JPanel();
        pimposx.setBorder(new TitledBorder("position(x)"));
        pimposx.add(this.tfimageposx);
        this.tfimageposy = new JTextField(7);
        JPanel pimposy = new JPanel();
        pimposy.setBorder(new TitledBorder("position(y)"));
        pimposy.add(this.tfimageposy);
        pimagepos.add(pimscale);
        pimagepos.add(pimposx);
        pimagepos.add(pimposy);
        pimagean.add(this.btnimageselect);
        pimagean.add(pimagepos);
        p.add(pimagean);
        JPanel pptan = new JPanel();
        pptan.setBorder(new TitledBorder("arrow annotation"));
        pptan.setLayout(new BoxLayout(pptan, 1));
        JPanel parrow = new JPanel();
        parrow.setLayout(new BoxLayout(parrow, 0));
        this.cbptan = new JCheckBox("display");
        JPanel parrowattributes = new JPanel();
        parrowattributes.setLayout(new BoxLayout(parrowattributes, 0));
        this.tfptanposx = new JTextField(5);
        JPanel ptfptanposx = new JPanel();
        ptfptanposx.setBorder(new TitledBorder("position(x)"));
        ptfptanposx.add(this.tfptanposx);
        this.tfptanposy = new JTextField(5);
        JPanel ptfptanposy = new JPanel();
        ptfptanposy.setBorder(new TitledBorder("position(y)"));
        ptfptanposy.add(this.tfptanposy);
        this.tfptanrotate = new JTextField(5);
        JPanel ptfptanrotate = new JPanel();
        ptfptanrotate.setBorder(new TitledBorder("rotate(deg.)"));
        ptfptanrotate.add(this.tfptanrotate);
        this.tfptanbase = new JTextField(5);
        JPanel ptfptanbase = new JPanel();
        ptfptanbase.setBorder(new TitledBorder("base"));
        ptfptanbase.add(this.tfptanbase);
        parrowattributes.add(ptfptanposx);
        parrowattributes.add(ptfptanposy);
        parrowattributes.add(ptfptanrotate);
        parrowattributes.add(ptfptanbase);
        parrow.add(this.cbptan);
        parrow.add(parrowattributes);
        pptan.add(parrow);
        JPanel parrowlabel = new JPanel();
        parrowlabel.setLayout(new BoxLayout(parrowlabel, 0));
        this.tfptanlabel = new JTextField(7);
        JPanel ptfptanlabel = new JPanel();
        ptfptanlabel.setBorder(new TitledBorder("label text"));
        ptfptanlabel.add(this.tfptanlabel);
        this.btnptanlabelfont = new JButton("select font");
        JPanel pbtnptanlabelfont = new JPanel();
        pbtnptanlabelfont.setBorder(new TitledBorder("label font"));
        pbtnptanlabelfont.add(this.btnptanlabelfont);
        this.tfptanlabeloffset = new JTextField(5);
        JPanel ptfptanlabeloffset = new JPanel();
        ptfptanlabeloffset.setBorder(new TitledBorder("label offset"));
        ptfptanlabeloffset.add(this.tfptanlabeloffset);
        parrowlabel.add(ptfptanlabel);
        parrowlabel.add(pbtnptanlabelfont);
        parrowlabel.add(ptfptanlabeloffset);
        pptan.add(parrowlabel);
        p.add(pptan);
        p.add(Box.createVerticalStrut(50));
        this.btntextannotation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.textanfont = PropertyEditor.this.chooseFont(PropertyEditor.this.textanfont);
                PropertyEditor.this.btntextannotation.setFont(PropertyEditor.this.textanfont);
            }
        });
        this.tftextannotation.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.textantext = PropertyEditor.this.tftextannotation.getText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.tftextannotationposx.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.textanposx = Double.parseDouble(PropertyEditor.this.tftextannotationposx.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.tftextannotationposy.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.textanposy = Double.parseDouble(PropertyEditor.this.tftextannotationposy.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.tftextannotationrotation.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.textanrotation = Double.parseDouble(PropertyEditor.this.tftextannotationrotation.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnimageselect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseFileChooser fdlg = new ChaseFileChooser("media");
                fdlg.setDialogType(2);
                fdlg.setDialogTitle("select image");
                fdlg.setFileSelectionMode(0);
                fdlg.addChoosableFileFilter(new ImageFilter());
                if (fdlg.showDialog(PropertyEditor.this.cont, "open") != 0) {
                    PropertyEditor.this.imageFileName = null;
                } else {
                    PropertyEditor.this.imageFileName = fdlg.getSelectedFile().getAbsolutePath();
                    File file = new File(PropertyEditor.this.imageFileName);
                    PropertyEditor.this.btnimageselect.setText(file.getName());
                }
            }
        });
        this.tfimagescale.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.imageScale = Double.parseDouble(PropertyEditor.this.tfimagescale.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.imageScale = 0.0;
                }
            }
        });
        this.tfimageposx.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.imagePosX = Double.parseDouble(PropertyEditor.this.tfimageposx.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.imagePosX = 0.0;
                }
            }
        });
        this.tfimageposy.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.imagePosY = Double.parseDouble(PropertyEditor.this.tfimageposy.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.imagePosY = 0.0;
                }
            }
        });
        this.tfptanposx.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.pointerAnnotationX = Double.parseDouble(PropertyEditor.this.tfptanposx.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.pointerAnnotationX = 0.0;
                }
            }
        });
        this.tfptanposy.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.pointerAnnotationY = Double.parseDouble(PropertyEditor.this.tfptanposy.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.pointerAnnotationY = 0.0;
                }
            }
        });
        this.tfptanrotate.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.pointerAnnotationRot = Double.parseDouble(PropertyEditor.this.tfptanrotate.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.pointerAnnotationRot = 0.0;
                }
            }
        });
        this.tfptanbase.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.pointerAnnotationBase = Double.parseDouble(PropertyEditor.this.tfptanbase.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.pointerAnnotationBase = 0.0;
                }
            }
        });
        this.tfptanlabel.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.pointerAnnotationLabel = PropertyEditor.this.tfptanlabel.getText();
                }
                catch (Exception e) {
                    PropertyEditor.this.pointerAnnotationLabel = "";
                }
            }
        });
        this.btnptanlabelfont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.pointerAnnotationFont = PropertyEditor.this.chooseFont(PropertyEditor.this.pointerAnnotationFont);
                PropertyEditor.this.btnptanlabelfont.setFont(PropertyEditor.this.pointerAnnotationFont);
            }
        });
        this.tfptanlabeloffset.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                try {
                    PropertyEditor.this.pointerAnnotationOffset = Double.parseDouble(PropertyEditor.this.tfptanlabeloffset.getText());
                }
                catch (Exception e) {
                    PropertyEditor.this.pointerAnnotationOffset = 0.0;
                }
            }
        });
        return p;
    }

    private void callSwitchPlotAttributes() {
        if (!this.cbapplytoall.isSelected()) {
            this.selectedSeries = this.list.getSelectedIndices();
            this.switchPlotAttributes(this.selectedSeries[0]);
            for (int i = 0; i < this.selectedSeries.length; ++i) {
                this.setPlotProperties(this.selectedSeries[i]);
            }
        } else {
            for (int i = 0; i < this.range.length; ++i) {
                this.switchPlotAttributes(i);
            }
        }
    }

    private void setPlotProperties(int i) {
        this.bplotdefault[i] = false;
        this.plottype[i] = this.comboplottype.getSelectedIndex();
        this.seriescolor[i] = this.btnplotlinecolor.getBackground();
        this.linetype[i] = this.comboplotlinetype.getSelectedIndex();
        try {
            this.linewidth[i] = Float.parseFloat(this.tfplotlinewidth.getText());
            this.shapetype[i] = this.comboplotshapetype.getSelectedIndex();
            this.shapesize[i] = Double.parseDouble(this.tfplotshapesize.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void switchPlotAttributes(int i) {
        this.comboplottype.setSelectedIndex(this.plottype[i]);
        this.comboplotlinetype.setSelectedIndex(this.linetype[i]);
        this.comboplotshapetype.setSelectedIndex(this.shapetype[i]);
        this.tfplotshapesize.setText(Double.toString(this.shapesize[i]));
        this.tfplotlinewidth.setText(Float.toString(this.linewidth[i]));
        this.btnplotlinecolor.setBackground(this.seriescolor[i]);
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton btnupdate = new JButton("update graph panel");
        JButton btnsave = new JButton("save");
        JButton btnsaveclose = new JButton("save & close");
        JButton btnclose = new JButton("close");
        p.add(btnupdate);
        p.add(btnsave);
        p.add(btnsaveclose);
        p.add(btnclose);
        btnupdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.saveProperties();
                PropertyEditor.this.parent.updateChartPanel();
            }
        });
        btnsave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.saveProperties();
            }
        });
        btnsaveclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.saveProperties();
                PropertyEditor.this.dispose();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.dispose();
            }
        });
        return p;
    }

    private void saveProperties() {
        this.parent.setDrawLegendOrNot(this.cblegend.isSelected());
        if (this.cbplottitle.isSelected()) {
            this.parent.setPlotTitle(this.taplottitle.getText());
            this.parent.setPlotTitleFont(this.titlefont);
        } else {
            this.parent.setPlotTitle(null);
        }
        this.parent.setAntiAlias(this.cbantialias.isSelected());
        this.parent.setLegendText(this.legendtext);
        this.parent.setLegendFont(this.legendfont);
        this.parent.setLegendAnchor((String)this.comboanchor.getSelectedItem());
        this.parent.setChartColor(this.chartcolor);
        this.parent.setPlotColor(this.plotcolor);
        if (this.type == 0) {
            this.parent.setXlabel(this.taaxislabel[0].getText());
            this.parent.setYlabel(this.taaxislabel[1].getText());
            this.parent.setXAxisFont(this.xaxisfont);
            this.parent.setYAxisFont(this.yaxisfont);
            this.parent.setTicModeXAxis(this.combotics[0].getSelectedIndex());
            this.parent.setTicModeYAxis(this.combotics[1].getSelectedIndex());
            this.parent.setTicUnitsXAxis(this.taticunits[0].getText());
            this.parent.setTicUnitsYAxis(this.taticunits[1].getText());
            this.parent.setTicFontXAxis(this.xaxisticfont);
            this.parent.setTicFontYAxis(this.yaxisticfont);
            this.parent.setXAxisRangeMode(this.comborange[0].getSelectedIndex());
            this.parent.setYAxisRangeMode(this.comborange[1].getSelectedIndex());
            this.parent.setXAxisMin(this.tarangemin[0].getText());
            this.parent.setYAxisMin(this.tarangemin[1].getText());
            this.parent.setXAxisMax(this.tarangemax[0].getText());
            this.parent.setYAxisMax(this.tarangemax[1].getText());
            this.parent.setDrawGridX(this.cbgrid[0].isSelected());
            this.parent.setDrawGridY(this.cbgrid[1].isSelected());
            this.parent.setLogX(this.cblog[0].isSelected());
            this.parent.setLogY(this.cblog[1].isSelected());
            this.parent.setPlotDefault(this.bplotdefault);
            this.parent.setNumSeries(this.NumSeries);
            this.parent.setPlotType(this.plottype);
            this.parent.setLineType(this.linetype);
            this.parent.setShapeType(this.shapetype);
            this.parent.setLineWidth(this.linewidth);
            this.parent.setSeriesColor(this.seriescolor);
            this.parent.setTextAnnotationFont(this.textanfont);
            this.parent.setTextAnnotationText(this.textantext);
            this.parent.setTextAnnotationPosX(this.textanposx);
            this.parent.setTextAnnotationPosY(this.textanposy);
            this.parent.setTextAnnotationRotAngle(this.textanrotation);
            this.parent.setTextAnnotationMode(this.combotextannotation.getSelectedIndex());
            this.parent.setImageFileName(this.imageFileName);
            this.parent.setImageScale(this.imageScale);
            this.parent.setImagePosX(this.imagePosX);
            this.parent.setImagePosY(this.imagePosY);
            this.parent.setPointerAnnotation(this.cbptan.isSelected());
            this.parent.setPointerAnnotationX(this.pointerAnnotationX);
            this.parent.setPointerAnnotationY(this.pointerAnnotationY);
            this.parent.setPointerAnnotationRot(this.pointerAnnotationRot);
            this.parent.setPointerAnnotationBase(this.pointerAnnotationBase);
            this.parent.setPointerAnnotationLabel(this.pointerAnnotationLabel);
            this.parent.setPointerAnnotationFont(this.pointerAnnotationFont);
            this.parent.setPointerAnnotationOffset(this.pointerAnnotationOffset);
        }
    }
}

