/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.terminal;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.ssh.SshClient;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.terminal.TermPanel;
import jp.advancesoft.chase.ssh.terminal.TerminalListener;
import jp.advancesoft.chase.ssh.terminal.TerminalMenuBar;
import org.apache.log4j.Logger;

public class Terminal
extends InternalFrameChase
implements SshClient {
    private static Logger logger = Logger.getLogger(Terminal.class.getName());
    private HostInfo hostinfo;
    private TermPanel termpanel;
    private int origw;
    private int origh;

    public Terminal() {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        this.init();
    }

    public Terminal(HostInfo hostinfo) {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        this.hostinfo = hostinfo;
        this.init();
        if (hostinfo != null) {
            this.connect(hostinfo);
        }
    }

    private void init() {
        this.origw = this.getSize().width;
        this.origh = this.getSize().height;
        JPanel p = this.createPanelAndButtons();
        this.getContentPane().add(p);
        this.addComponentListener(new TerminalListener(this));
        super.setJMenuBar(new TerminalMenuBar(this));
        this.pack();
    }

    protected void resized() {
        double wnow = this.getSize().width;
        double hnow = this.getSize().height;
        double wscale = wnow / (double)this.origw;
        double hscale = hnow / (double)this.origh;
        this.termpanel.parentResized(wscale, hscale);
    }

    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    public void connect(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
        logger.debug("connecting ...");
        if (hostinfo != null) {
            this.termpanel.connect(hostinfo);
        }
    }

    public void disconnect() {
        if (this.termpanel != null) {
            this.termpanel.disconnect();
        }
        this.termpanel = null;
    }

    public HostInfo getHostInfo() {
        return this.hostinfo;
    }

    private JPanel createPanelAndButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.termpanel = new TermPanel();
        JScrollPane pane = new JScrollPane(this.termpanel);
        p.add(pane);
        p.add(this.createButtons());
        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton close = new JButton("close");
        p.add(close);
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal.this.dispose();
            }
        });
        return p;
    }

    public void dispose() {
        this.disconnect();
        super.dispose();
    }
}

