/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.settings;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jp.advancesoft.chase.settings.ACVProperties;
import jp.advancesoft.chase.settings.ChaseProperties;
import jp.advancesoft.chase.settings.ElementProperties;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.InstallationProperties;
import jp.advancesoft.chase.settings.LastUsedDirProperties;
import jp.advancesoft.chase.settings.SizeProperties;
import jp.advancesoft.chase.settings.WindowProperties;
import org.apache.log4j.Logger;

public class PropertiesManager {
    public static final int PROPERTIES_CHASE = 0;
    public static final int PROPERTIES_ACV = 1;
    public static final int PROPERTIES_SIZE = 2;
    public static final int PROPERTIES_ELEMINFO = 3;
    public static final int PROPERTIES_INSTALLATION = 4;
    public static final int PROPERTIES_LAST_USED_DIR = 5;
    public static final int PROPERTIES_WINDOW = 6;
    private static InstallationProperties installation;
    private static GlobalProperties Chase;
    private static GlobalProperties ACV;
    private static GlobalProperties Size;
    private static GlobalProperties Element;
    private static GlobalProperties Last_used_dir;
    private static GlobalProperties windows;
    private static Logger logger;

    public static GlobalProperties getGlobalProperties(int propertyType) {
        if (installation == null) {
            installation = new InstallationProperties();
        }
        if (propertyType == 0) {
            if (Chase == null) {
                Chase = new ChaseProperties(installation);
            }
            return Chase;
        }
        if (propertyType == 1) {
            if (ACV == null) {
                InputStream inStream = GlobalProperties.class.getResourceAsStream("/jp/advancesoft/chase/settings/acvconfig.properties");
                Properties props = new Properties();
                try {
                    props.load(inStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ACV = new ACVProperties(installation, props);
            }
            return ACV;
        }
        if (propertyType == 2) {
            if (Size == null) {
                Size = new SizeProperties(installation);
            }
            return Size;
        }
        if (propertyType == 3) {
            if (Element == null) {
                Element = new ElementProperties(installation);
            }
            return Element;
        }
        if (propertyType == 5) {
            if (Last_used_dir == null) {
                Last_used_dir = new LastUsedDirProperties(installation);
            }
            return Last_used_dir;
        }
        if (propertyType == 6) {
            if (windows == null) {
                windows = new WindowProperties(installation);
            }
            return windows;
        }
        logger.debug("wrong property type");
        return null;
    }

    static {
        logger = Logger.getLogger(PropertiesManager.class.getName());
    }
}

