/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.pkg;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.advancesoft.chase.common.ChaseFileChooser;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;

public class ActivationPanel
extends InternalFrameChase {
    String lcg = "advanceLCG";
    String FS = System.getProperty("file.separator");
    String LS = System.getProperty("line.separator");
    MyMessageBox mbox = new MyMessageBox();
    GlobalProperties property = PropertiesManager.getGlobalProperties(0);

    public ActivationPanel() {
        super("activate", true, true, true, true);
        this.setSize(200, 100);
        Container container = this.getContentPane();
        container.add(this.createButtons());
    }

    public void display() {
        System.out.println("displaying activation panel ...");
        this.setVisible(true);
    }

    private JPanel createButtons() {
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new GridLayout(3, 1));
        JButton btnBootLCG = new JButton("get Locking Code");
        JButton btnSelectLF = new JButton("select license file");
        JButton btnClose = new JButton("close");
        pbtn.add(btnBootLCG);
        pbtn.add(btnSelectLF);
        pbtn.add(btnClose);
        btnBootLCG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String exec = System.getProperty("chase.home") + ActivationPanel.this.FS + ActivationPanel.this.property.getProperty("lcgpath") + ActivationPanel.this.FS + ActivationPanel.this.lcg;
                if (System.getProperty("os.name").trim().toLowerCase().startsWith("windows")) {
                    exec = exec + ".exe";
                }
                if (new File(exec).exists()) {
                    ActivationPanel.this.bootLCG(exec);
                } else {
                    ActivationPanel.this.mbox.setText("couldn't find locking code generator!");
                }
            }
        });
        btnSelectLF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ActivationPanel.this.selectLF();
            }
        });
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ActivationPanel.this.dispose();
            }
        });
        return pbtn;
    }

    private void bootLCG(String exec) {
        BufferedReader[] bin;
        try {
            bin = ExternalProgramExecuter.executeGetBR(exec);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.mbox.setText("failed execution of: " + exec);
            return;
        }
        String acumString = new String();
        try {
            String string;
            while ((string = bin[0].readLine()) != null) {
                acumString = acumString + string + this.LS;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return;
        }
        System.out.println(acumString);
        JOptionPane.showMessageDialog(Desktop.getDesktop(), acumString, "advanceLCG", -1);
        this.deleteAnnoyingFiles();
    }

    private void selectLF() {
        String lfpath = System.getProperty("chase.home") + this.FS + this.property.getProperty("licensefilepath");
        ChaseFileChooser fdlg = new ChaseFileChooser();
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("select");
        fdlg.setFileSelectionMode(0);
        if (fdlg.showDialog(this, "open") != 0) {
            return;
        }
        String copyFrom = fdlg.getSelectedFile().getAbsolutePath();
        String selectedFileName = new File(copyFrom).getName();
        String copyTo = lfpath + this.FS + selectedFileName;
        if (!copyTo.trim().equals(copyFrom.trim())) {
            try {
                ExternalProgramExecuter.copy(copyFrom, copyTo);
                this.mbox.setText("successfully copied file " + copyFrom + " to " + copyTo);
            }
            catch (Exception exc) {
                return;
            }
        } else {
            this.mbox.setText("same file!");
        }
    }

    private void deleteAnnoyingFiles() {
        String[] files = new String[]{"clauth1.dll", "clauth2.dll", "lsprst7", "ssprs.dll", "ssprs.tgz", "sysprs7", "sysprs7.tgz", "lsprst7.tgz"};
        String pwd = System.getProperty("user.dir");
        for (int i = 0; i < files.length; ++i) {
            String delfile = pwd + System.getProperty("file.separator") + files[i];
            new File(delfile).delete();
        }
    }
}

