/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.phase.PhaseFrame;
import jp.advancesoft.chase.phase.TFJobStatus;

class JobStatusMoniter
extends JPanel {
    public static final String JOBSTATUS_FILE = "jobstatus";
    private PhaseFrame parent;
    private String projdir;
    private String statusFile;
    private String extension;
    private TFJobStatus status;
    private TFJobStatus iteration;
    private TFJobStatus iter_ionic;
    private TFJobStatus iter_elec;
    private TFJobStatus elapsed_time;
    private Timer timer;
    private final int REFRESH = 5000;

    public JobStatusMoniter(PhaseFrame parent) {
        this.parent = parent;
        this.setLayout(new FlowLayout());
        this.add(this.createPanel());
        this.setMaximumSize(new Dimension(520, 70));
        this.setMinimumSize(new Dimension(520, 70));
        this.setSize(new Dimension(520, 70));
        this.timer = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                JobStatusMoniter.this.reload();
            }
        });
        this.timer.start();
    }

    void setProjDir(String projdir) {
        this.projdir = projdir;
    }

    void setExtension(String extension) {
        this.extension = extension;
        this.statusFile = this.projdir + JOBSTATUS_FILE + extension;
        if (extension.trim().length() == 0) {
            System.out.println("jobstatus file: (not available)");
            return;
        }
        System.out.println("jobstatus file: " + this.statusFile);
    }

    void reload() {
        File file = new File(this.statusFile);
        boolean statusExists = file.exists();
        String str_status = new String();
        String str_iteration = new String();
        String str_iter_ionic = new String();
        String str_iter_elec = new String();
        String str_elapsed_time = new String();
        if (statusExists) {
            this.setBorder(new TitledBorder("jobstatus file: " + file.getName()));
            try {
                String readString;
                BufferedReader br = new BufferedReader(new FileReader(this.statusFile));
                while ((readString = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(readString, "=");
                    if (st.countTokens() < 2) continue;
                    String ident = st.nextToken().trim();
                    if (ident.equals("status")) {
                        str_status = st.nextToken().trim();
                        continue;
                    }
                    if (ident.equals("iteration")) {
                        str_iteration = st.nextToken().trim();
                        continue;
                    }
                    if (ident.equals("iter_ionic")) {
                        str_iter_ionic = st.nextToken().trim();
                        continue;
                    }
                    if (ident.equals("iter_elec")) {
                        str_iter_elec = st.nextToken().trim();
                        continue;
                    }
                    if (!ident.equals("elapsed_time")) continue;
                    str_elapsed_time = st.nextToken().trim();
                }
            }
            catch (Exception exc) {
                System.out.println("failed read from: " + this.statusFile);
            }
        } else {
            this.setBorder(new TitledBorder("jobstatus file: (not available)"));
        }
        this.status.setText(str_status);
        this.iteration.setText(str_iteration);
        this.iter_ionic.setText(str_iter_ionic);
        this.iter_elec.setText(str_iter_elec);
        this.elapsed_time.setText(str_elapsed_time);
        this.changeTextFieldProps(statusExists);
    }

    private void changeTextFieldProps(boolean b2) {
        int intc = 230;
        Color color = new Color(intc, intc, intc);
        if (b2) {
            color = Color.white;
        }
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        int width = 13;
        this.status = new TFJobStatus("status", width);
        this.iteration = new TFJobStatus("iteration", width);
        this.iter_ionic = new TFJobStatus("iter_ionic", width);
        this.iter_elec = new TFJobStatus("iter_elec", width);
        this.elapsed_time = new TFJobStatus("elapsed_time", width);
        panel.add(this.status);
        panel.add(this.iteration);
        panel.add(this.iter_ionic);
        panel.add(this.iter_elec);
        panel.add(this.elapsed_time);
        return panel;
    }
}

