/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.phase.ChoicePanelPhase;
import jp.advancesoft.chase.phase.GUIBootButton;
import jp.advancesoft.chase.phase.InputPanelPhase;
import jp.advancesoft.chase.phase.Kpoints;
import jp.advancesoft.chase.phase.PhaseInputItems;
import jp.advancesoft.chase.phase.TableForNonTabularData;

class AccuracyPanel
extends PhaseInputItems {
    protected AccuracyPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    void createGUI() {
        this.add(this.createAccuracyPanel());
    }

    private JPanel createAccuracyPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setSize(500, 250);
        JPanel p_cutoff = new JPanel();
        p_cutoff.setLayout(new GridLayout(1, 2, 1, 1));
        String accuracy = "accuracy.";
        String[] specWF = new String[]{accuracy + "cutoff_wf", accuracy + "cke_wf", accuracy + "cutoff_energy_for_wavefunctions", accuracy + "cke_wavefunctions"};
        String[] specCD = new String[]{accuracy + "cutoff_cd", accuracy + "cke_cd", accuracy + "cutoff_energy_for_chargedensity", accuracy + "cke_chargedensity"};
        InputPanelPhase wf = new InputPanelPhase(specWF, this.inputInterface, "wave function", 4, 7, this);
        InputPanelPhase cd = new InputPanelPhase(specCD, this.inputInterface, "charge density", 4, 7, this);
        p_cutoff.setBorder(new TitledBorder("Cut-off"));
        p_cutoff.add(wf);
        p_cutoff.add(cd);
        p.add(p_cutoff);
        JPanel p_numband = new JPanel();
        p_numband.setLayout(new GridLayout(1, 2, 1, 1));
        String[] specNumBnd = new String[]{accuracy + "num_bands"};
        InputPanelPhase numbands = new InputPanelPhase(specNumBnd, this.inputInterface, "num. bands", 0, 7, this);
        String[] specXC = new String[]{accuracy + "xctype"};
        String[] xcChoice = new String[]{this.NO_SELECTION, "ldapw91", "ggapbe"};
        ChoicePanelPhase xc = new ChoicePanelPhase(specXC, this.inputInterface, "XC type", xcChoice, this);
        p_numband.add(numbands);
        p_numband.add(xc);
        p.add(p_numband);
        JPanel p_ksample = new JPanel();
        p_ksample.setLayout(new FlowLayout(1));
        String ksamp = accuracy + "ksampling.";
        String[] specMethod = new String[]{ksamp + "method"};
        String[] methodChoice = new String[]{this.NO_SELECTION, "monk", "mesh", "file", "gamma", "directin"};
        ChoicePanelPhase method = new ChoicePanelPhase(specMethod, this.inputInterface, "Method", methodChoice, this);
        p_ksample.add(method);
        Object[] argk = new Object[1];
        GUIBootButton btnkdirect = new GUIBootButton("edit kpoints", this.inputInterface, Kpoints.class, (ActionListener)this);
        method.registerDisabableGUI(new int[]{0, 1, 2, 3, 4}, btnkdirect);
        p_ksample.add(btnkdirect);
        Object[] colname = new String[]{"", "nx", "ny", "nz"};
        String akm = ksamp + "mesh.";
        Object[][] kmeshdata = new String[][]{{"mesh", "", "", ""}};
        String[] inputSpecskm = new String[]{akm + "nx", akm + "ny", akm + "nz"};
        TableForNonTabularData kmeshTable = new TableForNonTabularData(inputSpecskm, this.inputInterface, kmeshdata, colname);
        kmeshTable.setInputToModel();
        kmeshTable.getModel().addTableModelListener(this);
        JScrollPane scrPaneKmesh = new JScrollPane();
        scrPaneKmesh.getViewport().setView(kmeshTable);
        scrPaneKmesh.setPreferredSize(new Dimension(180, 35));
        p_ksample.add(scrPaneKmesh);
        int icol = kmeshTable.getModel().getColumnCount();
        int[] intarray = new int[]{3, 4, 5};
        for (int j2 = 0; j2 < icol; ++j2) {
            DefaultCellEditor editor = (DefaultCellEditor)kmeshTable.getColumnModel().getColumn(j2).getCellEditor();
            method.registerDisabableGUI(intarray, (JComponent)editor.getComponent());
        }
        String kshift = ksamp + "kshift.";
        String[] specKshift = new String[]{kshift + "k1", kshift + "k2", kshift + "k3"};
        Object[] colname_kshift = new String[]{"", "k1", "k2", "k3"};
        Object[][] kshiftdata = new String[][]{{"kshift", "", "", ""}};
        TableForNonTabularData kshiftTable = new TableForNonTabularData(specKshift, this.inputInterface, kshiftdata, colname_kshift);
        kshiftTable.setInputToModel();
        kshiftTable.getModel().addTableModelListener(this);
        JScrollPane scrPaneKshift = new JScrollPane();
        scrPaneKshift.getViewport().setView(kshiftTable);
        scrPaneKshift.setPreferredSize(new Dimension(160, 35));
        p_ksample.add(scrPaneKshift);
        icol = kshiftTable.getModel().getColumnCount();
        int[] intshift = new int[]{2, 3, 4, 5};
        for (int j3 = 0; j3 < icol; ++j3) {
            DefaultCellEditor editor = (DefaultCellEditor)kshiftTable.getColumnModel().getColumn(j3).getCellEditor();
            method.registerDisabableGUI(intshift, (JComponent)editor.getComponent());
        }
        p_ksample.setBorder(new TitledBorder("K point sampling"));
        p.add(p_ksample);
        JPanel p_smear = new JPanel();
        p_smear.setLayout(new GridLayout(1, 2, 1, 1));
        String[] specSmear = new String[]{accuracy + "smearing.method"};
        String[] smearChoice = new String[]{this.NO_SELECTION, "parabolic", "tetrahedron"};
        ChoicePanelPhase smear = new ChoicePanelPhase(specSmear, this.inputInterface, "Method", smearChoice, this);
        p_smear.add(smear);
        String[] specWidth = new String[]{accuracy + "smearing.width"};
        InputPanelPhase width = new InputPanelPhase(specWidth, this.inputInterface, "width", 4, 7, this);
        p_smear.add(width);
        smear.registerDisabableGUI(new int[]{0, 2}, width);
        p_smear.setBorder(new TitledBorder("Smearing"));
        p.add(p_smear);
        JPanel p_conv = new JPanel();
        p_conv.setLayout(new GridLayout(1, 3));
        String scfconv = accuracy + "scf_convergence.";
        String[] specConvDe = new String[]{scfconv + "delta_total_energy"};
        InputPanelPhase scfde = new InputPanelPhase(specConvDe, this.inputInterface, "dE", 4, 5, this);
        p_conv.add(scfde);
        String[] specSuc = new String[]{scfconv + "succession"};
        InputPanelPhase scfsuc = new InputPanelPhase(specSuc, this.inputInterface, "succession", 0, 5, this);
        p_conv.add(scfsuc);
        String[] specForceConv = new String[]{accuracy + "force_convergence.max_force"};
        InputPanelPhase forcConv = new InputPanelPhase(specForceConv, this.inputInterface, "force", 5, 5, this);
        p_conv.add(forcConv);
        p_conv.setBorder(new TitledBorder("Convergence"));
        p.add(p_conv);
        JPanel p_init = new JPanel();
        p_init.setLayout(new GridLayout(1, 2, 1, 1));
        String[] initWFSpec = new String[]{accuracy + "initial_wavefunctions"};
        String[] initWFChoice = new String[]{this.NO_SELECTION, "Matrix_diagon", "Random_numbers"};
        ChoicePanelPhase initWF = new ChoicePanelPhase(initWFSpec, this.inputInterface, "wave function", initWFChoice, this);
        String[] matdiagonCutoffSpec = new String[]{accuracy + "matrix_diagon.cutoff_wf"};
        InputPanelPhase matdiagon = new InputPanelPhase(matdiagonCutoffSpec, this.inputInterface, "cutoff (matrix diagon)", 4, 7, this);
        p_init.add(initWF);
        p_init.add(matdiagon);
        initWF.registerDisabableGUI(new int[]{0, 2}, matdiagon);
        String[] initCDSpec = new String[]{accuracy + "initial_charge_density"};
        String[] initCDChoice = new String[]{"Gauss"};
        ChoicePanelPhase initCD = new ChoicePanelPhase(initCDSpec, this.inputInterface, "charge density", initCDChoice, this);
        p_init.add(initCD);
        p_init.setBorder(new TitledBorder("Initial"));
        p.add(p_init);
        JPanel p_ek_convergence = new JPanel();
        p_ek_convergence.setLayout(new GridLayout(2, 3, 1, 1));
        String ekconv = accuracy + "ek_convergence.";
        String[] nebSpec = new String[]{ekconv + "num_extra_bands"};
        String[] nitSpec = new String[]{ekconv + "num_max_iteration"};
        String[] seedSpec = new String[]{ekconv + "sw_eval_eig_diff"};
        String[] ekdeSpec = new String[]{ekconv + "delta_eigenvalue"};
        String[] eksucSpec = new String[]{ekconv + "succession"};
        InputPanelPhase neb = new InputPanelPhase(nebSpec, this.inputInterface, "num_extra_bands", 0, 7, this);
        InputPanelPhase nit = new InputPanelPhase(nitSpec, this.inputInterface, "num_max_iteration", 0, 7, this);
        ChoicePanelPhase seed = new ChoicePanelPhase(seedSpec, this.inputInterface, "sw_eval_eig_diff", this.ON_OFF, this);
        InputPanelPhase ekde = new InputPanelPhase(ekdeSpec, this.inputInterface, "delta_eigenvalue", 4, 7, this);
        InputPanelPhase eksuc = new InputPanelPhase(eksucSpec, this.inputInterface, "succession", 0, 7, this);
        p_ek_convergence.add(neb);
        p_ek_convergence.add(nit);
        p_ek_convergence.add(seed);
        p_ek_convergence.add(ekde);
        p_ek_convergence.add(eksuc);
        p.add(p_ek_convergence);
        return p;
    }
}

