/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.MyJCheckBoxMenuItem;
import jp.advancesoft.chase.common.MyJMenu;
import jp.advancesoft.chase.mainpanel.ChaseMenu;
import jp.advancesoft.chase.mainpanel.SkinActionListener;
import jp.advancesoft.chase.mainpanel.UIActionListener;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class LookandFeel
extends MyJMenu {
    protected Logger logger = Logger.getLogger(LookandFeel.class.getName());
    protected GlobalProperties props = PropertiesManager.getGlobalProperties(0);
    public static String landf_metal = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static String landf_motif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static String landf_win = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static String landf_skin = "com.l2fprod.gui.plaf.skin.SkinLookAndFeel";
    public static String[] supported_lf = new String[]{landf_metal, landf_motif, landf_win, landf_skin};
    private String FS = ConstParameters.FS;
    private MyJMenu mskin;
    private String theme;
    private String theme_full;
    private ChaseMenu parent;
    private Vector menuArray = new Vector();
    private String init_lf = "";
    private String init_skin = "";

    public LookandFeel(ChaseMenu parent) {
        super("Look & feel", 76);
        this.parent = parent;
        this.init_lf = this.props.getProperty("look_and_feel");
        this.init_skin = this.props.getProperty("look_and_feel_skin");
        this.init();
        this.skinLF();
    }

    private void skinLF() {
        File skinlfdir = new File(System.getProperty("chase.home") + this.FS + "lib" + this.FS + "skinlf");
        if (!skinlfdir.exists()) {
            return;
        }
        File[] skinfiles = skinlfdir.listFiles();
        if (skinfiles == null || skinfiles.length == 0) {
            this.logger.info("no skin found.");
            return;
        }
        for (int i = 0; i < skinfiles.length; ++i) {
            this.theme_full = skinfiles[i].getName();
            String[] str2 = this.theme_full.split("themepack.zip");
            if (str2 == null || str2[0].trim().length() == 0) continue;
            this.theme = str2[0];
            MyJCheckBoxMenuItem skin = new MyJCheckBoxMenuItem(this.theme);
            this.mskin.add(skin);
            this.menuArray.addElement(skin);
            skin.addActionListener(new UIActionListener(skin, this.menuArray));
            skin.addActionListener(new SkinActionListener(skinfiles[i].getName(), this));
            if (this.init_skin == null || !this.init_skin.equals(this.theme_full) || !this.init_lf.equals(landf_skin)) continue;
            skin.setState(true);
        }
    }

    private void init() {
        this.mskin = new MyJMenu("Skin", 83);
        this.add(this.mskin);
        MyJCheckBoxMenuItem mmetal = new MyJCheckBoxMenuItem("Metal", 77);
        mmetal.addActionListener(new UIActionListener(mmetal, this.menuArray));
        mmetal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LookandFeel.this.setUI(landf_metal);
                LookandFeel.this.props.setProperty("look_and_feel", landf_metal);
                LookandFeel.this.props.storeProperty();
            }
        });
        this.menuArray.addElement(mmetal);
        this.add(mmetal);
        if (this.init_lf != null && this.init_lf.equals(landf_metal)) {
            mmetal.setState(true);
        }
        MyJCheckBoxMenuItem mmotif = new MyJCheckBoxMenuItem("Motif", 79);
        mmotif.addActionListener(new UIActionListener(mmotif, this.menuArray));
        mmotif.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LookandFeel.this.setUI(landf_motif);
                LookandFeel.this.props.setProperty("look_and_feel", landf_motif);
                LookandFeel.this.props.storeProperty();
            }
        });
        this.menuArray.addElement(mmotif);
        this.add(mmotif);
        if (this.init_lf != null && this.init_lf.equals(landf_motif)) {
            mmotif.setState(true);
        }
        MyJCheckBoxMenuItem mwin = new MyJCheckBoxMenuItem("Windows", 87);
        mwin.addActionListener(new UIActionListener(mwin, this.menuArray));
        mwin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LookandFeel.this.setUI(landf_win);
                LookandFeel.this.props.setProperty("look_and_feel", landf_win);
                LookandFeel.this.props.storeProperty();
            }
        });
        this.menuArray.addElement(mwin);
        this.add(mwin);
        if (this.init_lf != null && this.init_lf.equals(landf_win)) {
            mwin.setState(true);
        }
    }

    protected void setUI(String str) {
        this.parent.setUI(str);
    }
}

