/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.imageviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;

class ImagePrinter
extends JComponent
implements Printable {
    private Image image;
    private double SCALE = 0.5;

    public ImagePrinter() {
    }

    public ImagePrinter(Image image) {
        this.image = image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void printImage() {
        PrinterJob job = PrinterJob.getPrinterJob();
        Book book = new Book();
        book.append(this, job.defaultPage());
        job.setPageable(book);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int print(Graphics g, PageFormat format, int index) throws PrinterException {
        double formatHeight;
        double scaleHeight;
        if (index > 1) {
            return 1;
        }
        int imageWidth = this.image.getWidth(null);
        int imageHeight = this.image.getHeight(null);
        double formatWidth = format.getImageableWidth();
        double scaleWidth = formatWidth / (double)imageWidth;
        this.SCALE = scaleWidth <= (scaleHeight = (formatHeight = format.getImageableHeight()) / (double)imageHeight) ? scaleWidth : scaleHeight;
        ((Graphics2D)g).translate(format.getImageableX(), format.getImageableY());
        ((Graphics2D)g).transform(AffineTransform.getScaleInstance(this.SCALE, this.SCALE));
        g.drawImage(this.image, 0, 0, null);
        return 0;
    }
}

