/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.filebrowser;

import com.jcraft.jsch.ChannelSftp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import jp.advancesoft.chase.filebrowser.ComboBoxFileBrowser;
import jp.advancesoft.chase.filebrowser.FileBrowserEvent;
import jp.advancesoft.chase.filebrowser.FileBrowserNode;
import jp.advancesoft.chase.filebrowser.FileBrowserParent;
import jp.advancesoft.chase.filebrowser.MouseListenerTree;
import jp.advancesoft.chase.settings.PropertiesManager;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import org.apache.log4j.Logger;

public class FileBrowserTree
extends JPanel {
    private static Logger logger = Logger.getLogger(FileBrowserTree.class.getName());
    public static final int WINDOWS = 0;
    public static final int UNIX = 1;
    private int mode = 0;
    private int type = 0;
    private int os = 0;
    private String initialDir;
    private String FS = System.getProperty("file.separator");
    private int curdir = 0;
    private RemoteFile[] templist;
    private RemoteFile[][] work = new RemoteFile[512][];
    private RemoteFile root;
    private JScrollPane scrollpane;
    private ComboBoxFileBrowser combo;
    protected JTree tree;
    private Vector listeners = new Vector();
    private boolean isremote = false;
    private ChannelSftp c;
    private boolean initExpand = true;
    private FileBrowserParent parent;

    public FileBrowserTree(int os) {
        this.os = os;
        this.init();
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserParent parent) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.init();
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserParent parent, boolean isremote) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.isremote = isremote;
        this.mode = this.mode;
        if (!isremote) {
            this.init();
        }
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserParent parent, boolean isremote, ChannelSftp c) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.isremote = isremote;
        this.c = c;
        this.mode = this.mode;
        if (!isremote) {
            this.init();
        }
    }

    public FileBrowserTree(int os, FileBrowserParent parent, int mode) {
        this.os = os;
        this.parent = parent;
        this.mode = mode;
        this.init();
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserParent parent, int mode) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.mode = mode;
        this.init();
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserParent parent, boolean isremote, int mode) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.isremote = isremote;
        this.mode = mode;
        if (!isremote) {
            this.init();
        }
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserParent parent, boolean isremote, ChannelSftp c, int mode) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.isremote = isremote;
        this.c = c;
        this.mode = mode;
        if (!isremote) {
            this.init();
        }
    }

    public void setChannelSftp(ChannelSftp c) {
        this.c = c;
    }

    public void setParent(FileBrowserParent parent) {
        this.parent = parent;
    }

    public RemoteFile[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            logger.info("no file selected!");
            return null;
        }
        RemoteFile[] ret = new RemoteFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            ret[i] = this.getSubDirList(paths[i]);
        }
        return ret;
    }

    public RemoteFile getCurrentDir() {
        TreePath path = this.tree.getSelectionPath();
        RemoteFile f = this.getSubDirList(path);
        if (f == null) {
            return null;
        }
        logger.debug("file: " + f + ", isDir: " + f.isDirectory());
        RemoteFile ret = f;
        if (!f.isDirectory()) {
            ret = (RemoteFile)f.getParentFile();
            logger.debug("dir at getcurrentdir: " + ret);
        }
        return ret;
    }

    public void setRemote(boolean isremote) {
        this.isremote = isremote;
    }

    public boolean isRemote() {
        return this.isremote;
    }

    public void addFileBrowserListener(FileBrowserParent fbl) {
        this.listeners.addElement(fbl);
    }

    public void init(String initialDir) {
        this.initialDir = initialDir;
        this.init();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void init() {
        String exp;
        if (this.mode == 1 || this.mode == 0) {
            this.type = FileBrowserNode.SFTP_CLIENT;
        }
        if (this.os == 1) {
            this.FS = "/";
        }
        if ((exp = PropertiesManager.getGlobalProperties(0).getProperty("file_browser_init_expand")) != null && exp.trim().equalsIgnoreCase("false")) {
            this.initExpand = false;
        }
        this.setLayout(new BoxLayout(this, 1));
        if (this.root == null) {
            if (this.initialDir == null || !new RemoteFile(this.initialDir, this.c).exists()) {
                if (this.os == 0) {
                    RemoteFile[] roots = (RemoteFile[])RemoteFile.listRoots();
                    this.root = roots[1];
                } else {
                    this.root = new RemoteFile("/", this.c);
                }
            } else {
                this.root = new RemoteFile(this.initialDir + this.FS, this.c);
            }
        }
        this.createTree();
    }

    private void createTree() {
        FileBrowserNode treenode = FileBrowserNode.getInstance(this.root.getAbsolutePath(), this.type);
        this.tree = new JTree(treenode);
        this.tree.setSelectionRow(0);
        FileBrowserNode treenode_tmp = FileBrowserNode.getInstance("", this.type);
        treenode.add(treenode_tmp);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent e) {
                TreePath tp = e.getPath();
                RemoteFile file = FileBrowserTree.this.getSubDirList(tp);
                FileBrowserTree.this.addExpandTree(tp, file);
            }

            public void treeWillCollapse(TreeExpansionEvent e) {
                TreePath tp = e.getPath().getParentPath();
                RemoteFile file = FileBrowserTree.this.getSubDirList(tp);
                FileBrowserTree.this.showDirectory(tp, file);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FileBrowserTree.this.notifyListeners();
            }
        });
        this.tree.addMouseListener(new MouseListenerTree(this.parent, this.mode));
        this.removeAll();
        this.scrollpane = new JScrollPane(this.tree);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.combo = new ComboBoxFileBrowser(this, this.c);
        JButton btnreload = new JButton("reload");
        p.add(this.combo);
        p.add(btnreload);
        this.add(p);
        this.add(this.scrollpane);
        if (this.initExpand) {
            this.tree.expandRow(0);
        }
        this.revalidate();
        btnreload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileBrowserTree.this.init();
            }
        });
    }

    private void notifyListeners() {
        FileBrowserEvent fbe = new FileBrowserEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FileBrowserParent)this.listeners.elementAt(i)).directoryHasChanged(fbe);
        }
    }

    private void addExpandTree(TreePath tp, RemoteFile file) {
        if (file == null) {
            return;
        }
        FileBrowserNode node = (FileBrowserNode)tp.getLastPathComponent();
        logger.debug("at addExpandTree: " + node.toString());
        if (node == null) {
            return;
        }
        if (file.isDirectory()) {
            int i;
            this.templist = (RemoteFile[])file.listFiles();
            if (this.templist.length == 0) {
                return;
            }
            ++this.curdir;
            this.work[this.curdir] = this.templist;
            logger.debug("templist");
            for (i = 0; i < this.templist.length; ++i) {
                logger.debug("templist: " + this.templist[i].getAbsolutePath());
            }
            Arrays.sort(this.work[this.curdir]);
            node.removeAllChildren();
            for (i = 0; i < this.work[this.curdir].length; ++i) {
                Object[] files;
                FileBrowserNode temp = FileBrowserNode.getInstance(this.work[this.curdir][i].getName(), this.type);
                logger.debug("at addExpandTree: " + temp.toString());
                node.add(temp);
                if (!this.work[this.curdir][i].isDirectory() || (files = (RemoteFile[])this.work[this.curdir][i].listFiles()) == null || files.length == 0) continue;
                Arrays.sort(files);
                for (int j = 0; j < files.length; ++j) {
                    FileBrowserNode tempsub = FileBrowserNode.getInstance(((RemoteFile)files[j]).getName(), this.type);
                    logger.debug("tempsub: " + tempsub.toString());
                    temp.add(tempsub);
                }
            }
        }
    }

    private void showDirectory(TreePath tp, RemoteFile file) {
        if (file == null) {
            this.templist = new RemoteFile[1];
            ++this.curdir;
            this.work[this.curdir] = this.templist;
            return;
        }
        FileBrowserNode node = (FileBrowserNode)tp.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (file.isDirectory()) {
            this.templist = (RemoteFile[])file.listFiles();
            if (this.templist.length == 0) {
                return;
            }
            ++this.curdir;
            this.work[this.curdir] = this.templist;
            Arrays.sort(this.work[this.curdir]);
        }
    }

    private RemoteFile getSubDirList(TreePath treepath) {
        if (treepath == null) {
            return null;
        }
        String string = treepath.getPathComponent(0).toString();
        if (!string.trim().endsWith(this.FS)) {
            string = string + this.FS;
        }
        int count = treepath.getPathCount();
        for (int i = 1; i < count; ++i) {
            string = string + treepath.getPathComponent(i).toString();
            if (i + 1 == count) break;
            string = string + this.FS;
        }
        logger.debug("subdirlist: " + string);
        return new RemoteFile(string, this.c);
    }

    protected RemoteFile getCurrentRoot() {
        return this.root;
    }

    protected void setNewRoot(RemoteFile newRoot) {
        this.root = newRoot;
        this.createTree();
    }

    protected ChannelSftp getChannelSftp() {
        return this.c;
    }
}

