/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.mouselistener;

import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.mouselistener.MouseMotionListenerAction;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.DynamicallyEditable;
import jp.advancesoft.chase.acviewer.scenegraphelements.TGAtom;
import org.apache.log4j.Logger;

public class RightClickAction
extends MouseMotionListenerAction {
    private Logger logger = Logger.getLogger(RightClickAction.class.getName());
    private double x_last = 0.0;
    private double y_last = 0.0;
    private Transform3D buffer;

    public RightClickAction(MainPanel parent) {
        super(parent);
    }

    void init(MouseEvent e) {
        this.x_last = 0.0;
        this.y_last = 0.0;
        this.buffer = new Transform3D();
    }

    void finalize(MouseEvent e) {
        int i;
        TGAtom tgatom = (TGAtom)this.parent.getScene().getTGAtom();
        DynamicallyEditable[] editable = tgatom.getDynamicallyEditableElements();
        boolean update = false;
        Vector aobjVector = new Vector();
        Vector<BranchGroup> buffervec = new Vector<BranchGroup>();
        for (int i2 = 0; i2 < editable.length; ++i2) {
            editable[i2].dynamicallyEditFinalize(tgatom);
            buffervec.addElement(editable[i2].getBuffer());
        }
        int selected = tgatom.getSelectedAtomCount();
        this.parent.getCD().getAtomCoords().getAtomList().setUndoCount(selected);
        this.parent.getCD().update();
        for (i = 0; i < buffervec.size(); ++i) {
            if (buffervec.elementAt(i) == null) continue;
            ((BranchGroup)buffervec.elementAt(i)).detach();
        }
        for (i = 0; i < buffervec.size(); ++i) {
            if (!(buffervec.elementAt(i) instanceof AtomObject)) continue;
            ((AtomObject)buffervec.elementAt(i)).createBuffer();
        }
        this.x_last = 0.0;
        this.y_last = 0.0;
        this.buffer = new Transform3D();
    }

    void processMouseDrag(MouseEvent e) {
        this.logger.debug(this);
        this.logger.debug(" modifiersex: " + MouseEvent.getModifiersExText(e.getModifiersEx()));
        if (((TGAtom)this.parent.getScene().getTGAtom()).getSelectedAtomCount() == 0) {
            return;
        }
        Point3d ptmp = RightClickAction.getCoordsFromMousePos(this.parent, e);
        double x = ptmp.x;
        double y = ptmp.y;
        if (this.x_last == 0.0 && this.y_last == 0.0) {
            this.x_last = x;
            this.y_last = y;
            return;
        }
        Transform3D tgatom3d = new Transform3D();
        this.parent.getScene().getTGAtom().getTransform(tgatom3d);
        if (!tgatom3d.equals(this.buffer)) {
            this.buffer = new Transform3D(tgatom3d);
            this.x_last = x;
            this.y_last = y;
            return;
        }
        double dx = x - this.x_last;
        double dy = y - this.y_last;
        TGAtom tgatom = (TGAtom)this.parent.getScene().getTGAtom();
        Vector3d translation = new Vector3d();
        translation.x = dx;
        translation.y = -dy;
        Matrix3d rotation = new Matrix3d();
        Transform3D transform3d = new Transform3D(rotation, translation, 1.0);
        DynamicallyEditable[] editables = tgatom.getDynamicallyEditableElements();
        if (editables == null || editables.length == 0) {
            return;
        }
        for (int i = 0; i < editables.length; ++i) {
            editables[i].dynamicallyEditIntermediateState(transform3d, tgatom, e);
        }
        this.x_last = x;
        this.y_last = y;
    }

    void processMouseMove(MouseEvent e) {
    }

    public String toString() {
        return "right click action!";
    }
}

