/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer;

import jp.advancesoft.chase.acviewer.ACVDataManager;
import jp.advancesoft.chase.acviewer.ConfigDataManager;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.Show3D;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;

public class ScaleShiftXYZ {
    public static int EDGE_OF_CELL = 0;
    public static int CENTER_OF_CELL = 1;
    private int shiftPolicy = EDGE_OF_CELL;
    private MainPanel parent;
    private ACVDataManager mACVD;
    private ConfigDataManager mCD;
    private double[][] xyz;
    private double[][] cellvec;
    private int NumAt;
    private double lenmax = -1000000.0;
    private double jusinX = 0.0;
    private double jusinY = 0.0;
    private double jusinZ = 0.0;

    public ScaleShiftXYZ(ACVDataManager mACVD) {
        this.mACVD = mACVD;
        this.init();
    }

    public ScaleShiftXYZ(Show3D s3d) {
        this.mACVD = s3d.getACV();
        this.mCD = s3d.getCD();
        this.init();
    }

    public ScaleShiftXYZ(ACVDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
        this.init();
    }

    public ScaleShiftXYZ() {
        this.init();
    }

    private void init() {
        GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
        String foo = gp.getProperty("atom_shift_policy");
        int itmp = EDGE_OF_CELL;
        if (foo != null && foo.length() != 0) {
            try {
                itmp = Integer.parseInt(foo);
            }
            catch (Exception ex) {
                itmp = EDGE_OF_CELL;
            }
        }
        this.shiftPolicy = itmp;
    }

    public void setCellShiftPolicy(int shiftPolicy) {
        this.shiftPolicy = shiftPolicy;
    }

    private void SSXYZ(int sw_cell) {
        double z;
        double y;
        double x;
        int i;
        double xmax = -100000.0;
        double ymax = -100000.0;
        double zmax = -100000.0;
        double xmin = -xmax;
        double ymin = -ymax;
        double zmin = -zmax;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (i = 0; i < this.NumAt; ++i) {
            x = this.xyz[i][0];
            y = this.xyz[i][1];
            z = this.xyz[i][2];
            sumX += x;
            sumY += y;
            sumZ += z;
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (z < zmin) {
                zmin = z;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y > ymax) {
                ymax = y;
            }
            if (!(z > zmax)) continue;
            zmax = z;
        }
        double lenx = xmax - xmin;
        double leny = ymax - ymin;
        double lenz = zmax - zmin;
        if (lenx > this.lenmax) {
            this.lenmax = lenx;
        }
        if (leny > this.lenmax) {
            this.lenmax = leny;
        }
        if (lenz > this.lenmax) {
            this.lenmax = lenz;
        }
        if (this.NumAt == 1) {
            this.lenmax = 1.0;
        }
        this.lenmax /= new Float(this.mACVD.getScale()).doubleValue();
        this.mCD.setLenMax(this.lenmax);
        this.jusinX = sumX / (double)this.NumAt;
        this.jusinY = sumY / (double)this.NumAt;
        this.jusinZ = sumZ / (double)this.NumAt;
        this.mCD.setCOM(new double[]{this.jusinX, this.jusinY, this.jusinZ});
        for (i = 0; i < this.NumAt; ++i) {
            x = this.xyz[i][0];
            y = this.xyz[i][1];
            z = this.xyz[i][2];
            x -= this.jusinX;
            y -= this.jusinY;
            z -= this.jusinZ;
            this.xyz[i][0] = x /= this.lenmax;
            this.xyz[i][1] = y /= this.lenmax;
            this.xyz[i][2] = z /= this.lenmax;
        }
        if (sw_cell == 1) {
            for (i = 0; i < 3; ++i) {
                x = this.cellvec[i][0];
                y = this.cellvec[i][1];
                z = this.cellvec[i][2];
                this.cellvec[i][0] = x /= this.lenmax;
                this.cellvec[i][1] = y /= this.lenmax;
                this.cellvec[i][2] = z /= this.lenmax;
                if (this.mCD.getCellOrigin() || this.shiftPolicy == CENTER_OF_CELL) {
                    x = -this.jusinX;
                    y = -this.jusinY;
                    z = -this.jusinZ;
                    this.mCD.setCellOriginVector(x /= this.lenmax, y /= this.lenmax, z /= this.lenmax);
                    continue;
                }
                x = xmin - this.jusinX;
                y = ymin - this.jusinY;
                z = zmin - this.jusinZ;
                this.mCD.setCellOriginVector(x /= this.lenmax, y /= this.lenmax, z /= this.lenmax);
            }
        }
    }

    public void SSVecs(double[][] xyz, int NumAt) {
        this.xyz = xyz;
        this.NumAt = NumAt;
        this.SSXYZ(0);
    }

    public void SSVecs(double[][] xyz, int NumAt, double[][] cellvec) {
        this.xyz = xyz;
        this.cellvec = cellvec;
        this.NumAt = NumAt;
        this.SSXYZ(1);
    }

    public double[][] getXYZ() {
        return this.xyz;
    }

    public double[][] getCellVec() {
        return this.cellvec;
    }

    public double getLenMax() {
        return this.lenmax;
    }

    public double[] getCOM() {
        return new double[]{this.jusinX, this.jusinY, this.jusinZ};
    }
}

