/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVResolver;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;
    private Hashtable dotClasses;
    private boolean noDotSecurity = false;
    public DVResolver resolver;
    public Hashtable cnmap;

    public Library(Class[] classArray, Class[] classArray2) {
        this(classArray, classArray2, null);
    }

    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3) {
        this(classArray, classArray2, classArray3, null);
    }

    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3, DVResolver dVResolver) {
        this(classArray, classArray2, classArray3, dVResolver, null);
    }

    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3, DVResolver dVResolver, Hashtable hashtable) {
        this.cnmap = hashtable;
        this.resolver = dVResolver;
        if (classArray3 == null) {
            this.dotClasses = null;
        } else {
            this.noDotSecurity = classArray3.length == 0;
            this.dotClasses = new Hashtable();
            Class[] classArray4 = new Class[1];
            int n = 0;
            while (n < classArray3.length) {
                this.rehash(classArray3[n]);
                ++n;
            }
        }
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (classArray != null) {
            Library.rehash(classArray, this.names, null, this.stateless);
        }
        if (classArray2 != null) {
            Library.rehash(classArray2, this.names, this.dynIDs, null);
        }
    }

    private void rehash(Class clazz) {
        Hashtable hashtable = new Hashtable();
        Class[] classArray = new Class[]{clazz};
        Library.rehash(classArray, hashtable, new Hashtable(), null);
        this.dotClasses.put(clazz, hashtable);
    }

    private static void rehash(Class[] classArray, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        int n = 0;
        while (n < classArray.length) {
            Integer n2 = new Integer(n);
            Method[] methodArray = classArray[n].getMethods();
            Field[] fieldArray = classArray[n].getFields();
            int n3 = methodArray.length;
            int n4 = n3 + fieldArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Method method;
                AccessibleObject accessibleObject = method = n5 < n3 ? methodArray[n5] : fieldArray[n5 - n3];
                if ((method.getModifiers() & 8) > 0) {
                    if (hashtable3 != null && Library.rehash(hashtable, method)) {
                        hashtable3.put(method, Boolean.TRUE);
                    }
                } else if (hashtable2 != null && Library.rehash(hashtable, method)) {
                    hashtable2.put(method, n2);
                }
                ++n5;
            }
            ++n;
        }
    }

    private static boolean rehash(Hashtable hashtable, Member member) {
        Hashtable hashtable2;
        String string = member.getName();
        String string2 = Library.getSignature(member);
        if (Library.isField(member)) {
            string2 = "()" + string2;
        }
        if ((hashtable2 = (Hashtable)hashtable.get(string)) == null) {
            Hashtable<String, Member> hashtable3 = new Hashtable<String, Member>();
            hashtable3.put(string2, member);
            hashtable.put(string, hashtable3);
            return true;
        }
        Object v = hashtable2.get(string2);
        if (v == null) {
            hashtable2.put(string2, member);
            return true;
        }
        return false;
    }

    public void markStateDependent(String string, Class[] classArray) throws CompilationException {
        Member member = this.getMember(null, string, classArray);
        Object v = this.stateless.remove(member);
    }

    public boolean isStateless(Member member) {
        return this.stateless.containsKey(member);
    }

    public Member getMember(Class clazz, String string, Class[] classArray) throws CompilationException {
        Object object;
        Object[] objectArray;
        Hashtable hashtable;
        Hashtable hashtable2 = this.names;
        if (clazz != null) {
            if (this.dotClasses == null) {
                throw new CompilationException(11, null);
            }
            if (!this.noDotSecurity && !this.dotClasses.containsKey(clazz)) {
                Object[] objectArray2 = new Object[]{clazz};
                throw new CompilationException(12, objectArray2);
            }
            hashtable2 = (Hashtable)this.dotClasses.get(clazz);
            if (hashtable2 == null) {
                this.rehash(clazz);
                hashtable2 = (Hashtable)this.dotClasses.get(clazz);
            }
        }
        if ((hashtable = (Hashtable)hashtable2.get(string)) == null) {
            Object[] objectArray3 = new Object[]{string, clazz};
            throw new CompilationException(clazz == null ? 5 : 6, objectArray3);
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Member)enumeration.nextElement();
            object = Library.getParameterTypes((Member)objectArray);
            boolean bl = false;
            if (classArray != null) {
                if (((Class[])object).length == classArray.length) {
                    bl = true;
                    int n = 0;
                    while (n < ((Class[])object).length && bl) {
                        bl = OP.isWidening(classArray[n], object[n]);
                        ++n;
                    }
                }
            } else {
                boolean bl2 = bl = ((Class[])object).length == 0;
            }
            if (!bl) continue;
            vector.addElement(objectArray);
        }
        if (vector.size() == 0) {
            objectArray = new Object[]{string, Library.describe(string, classArray), clazz};
            throw new CompilationException(clazz == null ? 7 : 8, objectArray);
        }
        if (vector.size() == 1) {
            return (Member)vector.firstElement();
        }
        objectArray = vector.elements();
        object = (Member)objectArray.nextElement();
        Class[] classArray2 = Library.getParameterTypes((Member)object);
        while (objectArray.hasMoreElements()) {
            Member member = (Member)objectArray.nextElement();
            Class[] classArray3 = Library.getParameterTypes(member);
            boolean bl = true;
            boolean bl3 = true;
            int n = 0;
            while (n < classArray3.length) {
                bl = bl && OP.isWidening(classArray3[n], classArray2[n]);
                bl3 = bl3 && OP.isWidening(classArray2[n], classArray3[n]);
                ++n;
            }
            if (bl && !bl3) {
                object = member;
                classArray2 = classArray3;
            }
            if (bl ^ bl3) continue;
            Object[] objectArray4 = new Object[]{Library.describe(string, classArray2), Library.describe(string, classArray3), Library.describe(string, classArray), clazz};
            throw new CompilationException(clazz == null ? 9 : 10, objectArray4);
        }
        return object;
    }

    protected static String describe(String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('(');
        if (classArray != null) {
            int n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(classArray[n].toString());
                ++n;
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public int getDynamicMethodClassID(Member member) {
        Integer n = (Integer)this.dynIDs.get(member);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static Class getType(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof LocalField) {
            return ((LocalField)member).getType();
        }
        return OP.specialTypes[9];
    }

    public static Class[] getParameterTypes(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes();
        }
        if (member instanceof LocalMethod) {
            return ((LocalMethod)member).getParameterTypes();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getParameterTypes();
        }
        return new Class[0];
    }

    public static String getSignature(Member member) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Library.isField(member)) {
            Class[] classArray = Library.getParameterTypes(member);
            stringBuffer.append('(');
            int n = 0;
            while (n < classArray.length) {
                Library.appendSignature(stringBuffer, classArray[n]);
                ++n;
            }
            stringBuffer.append(')');
        }
        Library.appendSignature(stringBuffer, Library.getType(member));
        return stringBuffer.toString();
    }

    public static boolean isField(Member member) {
        return member instanceof Field || member instanceof LocalField && !(member instanceof LocalMethod);
    }

    public static String getSignature(Class clazz) {
        return Library.appendSignature(new StringBuffer(), clazz).toString();
    }

    private static StringBuffer appendSignature(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isPrimitive()) {
            int n = OP.typeID(clazz);
            stringBuffer.append(n > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(n));
        } else if (clazz.isArray()) {
            stringBuffer.append('[');
            Library.appendSignature(stringBuffer, clazz.getComponentType());
        } else {
            stringBuffer.append('L');
            Library.appendHistoricalForm(stringBuffer, clazz.getName());
            stringBuffer.append(';');
        }
        return stringBuffer;
    }

    public static String toHistoricalForm(String string) {
        return Library.appendHistoricalForm(new StringBuffer(), string).toString();
    }

    private static StringBuffer appendHistoricalForm(StringBuffer stringBuffer, String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '.') {
                c = '/';
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer;
    }
}

