/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.AbstractDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.statistics.HistogramType;
import org.jfree.util.ObjectUtils;

public class HistogramDataset
extends AbstractDataset
implements IntervalXYDataset,
Cloneable,
Serializable {
    private List list = new ArrayList();
    private HistogramType type = HistogramType.FREQUENCY;

    public void setType(HistogramType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null 'type' argument");
        }
        this.type = type;
    }

    public HistogramType getType() {
        return this.type;
    }

    public void addSeries(String name, double[] values, int bins, double minimum, double maximum) {
        int i;
        if (values == null) {
            throw new IllegalArgumentException("HistogramDataset.addSeries(...): 'values' argument must not be null.");
        }
        if (bins < 1) {
            throw new IllegalArgumentException("HistogramDataset.addSeries(...): number of bins must be at least 1");
        }
        double binWidth = (maximum - minimum) / (double)bins;
        double tmp = minimum;
        ArrayList<HistogramBin> binList = new ArrayList<HistogramBin>(bins);
        for (i = 0; i < bins; ++i) {
            HistogramBin bin = null;
            bin = i == bins - 1 ? new HistogramBin(tmp, maximum) : new HistogramBin(tmp, tmp + binWidth);
            tmp += binWidth;
            binList.add(bin);
        }
        block1: for (i = 0; i < values.length; ++i) {
            for (int j = 0; j < bins; ++j) {
                HistogramBin currentBin = (HistogramBin)binList.get(j);
                if (!(values[i] >= currentBin.getStartBoundary()) || !(values[i] <= currentBin.getEndBoundary())) continue;
                currentBin.incrementCount();
                continue block1;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("bins", binList);
        map.put("values.length", new Integer(values.length));
        map.put("bin width", new Double(binWidth));
        this.list.add(map);
    }

    public void addSeries(String name, double[] values, int bins) {
        double minimum = this.getMinimum(values);
        double maximum = this.getMaximum(values);
        this.addSeries(name, values, bins, minimum, maximum);
    }

    private double getMinimum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private double getMaximum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double max = -1.7976931348623157E308;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    List getBins(int series) {
        Map map = (Map)this.list.get(series);
        return (List)map.get("bins");
    }

    private int getTotal(int series) {
        Map map = (Map)this.list.get(series);
        return (Integer)map.get("values.length");
    }

    private double getBinWidth(int series) {
        Map map = (Map)this.list.get(series);
        return (Double)map.get("bin width");
    }

    public int getSeriesCount() {
        return this.list.size();
    }

    public String getSeriesName(int series) {
        Map map = (Map)this.list.get(series);
        return (String)map.get("name");
    }

    public int getItemCount(int series) {
        return this.getBins(series).size();
    }

    public Number getXValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double x = (bin.getStartBoundary() + bin.getEndBoundary()) / 2.0;
        return new Double(x);
    }

    public Number getYValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double total = this.getTotal(series);
        double binWidth = this.getBinWidth(series);
        if (this.type == HistogramType.FREQUENCY) {
            return new Double(bin.getCount());
        }
        if (this.type == HistogramType.RELATIVE_FREQUENCY) {
            return new Double((double)bin.getCount() / total);
        }
        if (this.type == HistogramType.SCALE_AREA_TO_1) {
            return new Double((double)bin.getCount() / (binWidth * total));
        }
        throw new IllegalStateException();
    }

    public Number getStartXValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getStartBoundary());
    }

    public Number getEndXValue(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getEndBoundary());
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof HistogramDataset) {
            HistogramDataset dataset = (HistogramDataset)obj;
            boolean b0 = ObjectUtils.equal((Object)dataset.type, (Object)this.type);
            boolean b1 = ObjectUtils.equal((Object)dataset.list, (Object)this.list);
            return b0 && b1;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

